/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.util.Observers;

public class ResolvedObservers<T> {
    private static final ResolvedObservers<Object> EMPTY = new ResolvedObservers<Object>(Collections.emptySet(), Collections.emptySet(), false){

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private final Set<ObserverMethod<? super T>> immediateObservers;
    private final Set<ObserverMethod<? super T>> transactionObservers;
    private final boolean metadataRequired;

    public static <T> ResolvedObservers<T> of(Set<ObserverMethod<? super T>> observers) {
        if (observers.isEmpty()) {
            return EMPTY;
        }
        boolean metadataRequired = false;
        ArrayList<ObserverMethod<T>> immediateObservers = new ArrayList<ObserverMethod<T>>();
        ArrayList<ObserverMethod<T>> transactionObservers = new ArrayList<ObserverMethod<T>>();
        for (ObserverMethod<T> observerMethod : observers) {
            if (TransactionPhase.IN_PROGRESS == observerMethod.getTransactionPhase()) {
                immediateObservers.add(observerMethod);
            } else {
                transactionObservers.add(observerMethod);
            }
            if (metadataRequired || !Observers.isEventMetadataRequired(observerMethod)) continue;
            metadataRequired = true;
        }
        return new ResolvedObservers<T>(ImmutableSet.copyOf(immediateObservers), ImmutableSet.copyOf(transactionObservers), metadataRequired);
    }

    private ResolvedObservers(Set<ObserverMethod<? super T>> immediateObservers, Set<ObserverMethod<? super T>> transactionObservers, boolean metadataRequired) {
        this.immediateObservers = immediateObservers;
        this.transactionObservers = transactionObservers;
        this.metadataRequired = metadataRequired;
    }

    Set<ObserverMethod<? super T>> getImmediateObservers() {
        return this.immediateObservers;
    }

    Set<ObserverMethod<? super T>> getTransactionObservers() {
        return this.transactionObservers;
    }

    boolean isMetadataRequired() {
        return this.metadataRequired;
    }

    public boolean isEmpty() {
        return false;
    }

    public Set<ObserverMethod<? super T>> getAllObservers() {
        return ImmutableSet.builder().addAll(this.immediateObservers).addAll(this.transactionObservers).build();
    }
}

