/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Method;
import org.jboss.classfilewriter.util.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodInformation;

public class StaticMethodInformation
implements MethodInformation {
    private final String name;
    private final String descriptor;
    private final String[] parameterTypes;
    private final String returnType;
    private final String declaringClass;
    private final int modifiers;

    public StaticMethodInformation(String name, Class<?>[] parameterTypes, Class<?> returnType, String declaringClass) {
        this(name, parameterTypes, returnType, declaringClass, 1);
    }

    public StaticMethodInformation(String name, Class<?>[] parameterTypes, Class<?> returnType, String declaringClass, int modifiers) {
        this.name = name;
        this.parameterTypes = DescriptorUtils.parameterDescriptors((Class[])parameterTypes);
        this.returnType = DescriptorUtils.makeDescriptor(returnType);
        this.declaringClass = declaringClass;
        StringBuilder builder = new StringBuilder("(");
        for (String p : this.parameterTypes) {
            builder.append(p);
        }
        builder.append(')');
        builder.append(this.returnType);
        this.descriptor = builder.toString();
        this.modifiers = modifiers;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public StaticMethodInformation(String name, String[] parameterTypes, String returnType, String declaringClass) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.declaringClass = declaringClass;
        StringBuilder builder = new StringBuilder("(");
        for (String p : this.parameterTypes) {
            builder.append(p);
        }
        builder.append(')');
        builder.append(returnType);
        this.descriptor = builder.toString();
        this.modifiers = 1;
    }

    @Override
    public String getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public Method getMethod() {
        return null;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }
}

