/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.core;

import java.util.Collection;

class Assertions {
    Assertions() {
    }

    static <T> T requiresNotNullParameter(T value, String name) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Parameter %s is required and cannot be null.", name));
        }
        return value;
    }

    static String requiresNotNullOrNotEmptyParameter(String value, String name) throws IllegalArgumentException {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("Parameter %s is required and cannot be null or empty.", name));
        }
        return value;
    }

    static <E, T extends Collection<E>> T requiresNotNullOrNotEmptyParameter(T value, String name) throws IllegalArgumentException {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(String.format("Parameter %s is required and cannot be null or empty.", name));
        }
        return value;
    }
}

