/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.registry.RegistryEntryProvider;
import org.wildfly.clustering.spi.CacheGroupServiceName;

public class EJBRemotingConnectorClientMappingsEntryProviderService
extends AbstractService<RegistryEntryProvider<String, List<ClientMapping>>> {
    private final RegistryEntryProvider<String, List<ClientMapping>> registryEntryProvider = new ClientMappingEntryProvider();
    private final InjectedValue<ServerEnvironment> serverEnvironment = new InjectedValue();
    private final InjectedValue<RemotingConnectorBindingInfoService.RemotingConnectorInfo> remotingConnectorInfo = new InjectedValue();

    public ServiceBuilder<RegistryEntryProvider<String, List<ClientMapping>>> build(ServiceTarget target, String clientMappingsClusterName, ServiceName remotingServerInfoServiceName) {
        return target.addService(CacheGroupServiceName.REGISTRY_ENTRY.getServiceName(clientMappingsClusterName, "client-mappings"), (Service)this).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.serverEnvironment).addDependency(remotingServerInfoServiceName, RemotingConnectorBindingInfoService.RemotingConnectorInfo.class, this.remotingConnectorInfo);
    }

    public RegistryEntryProvider<String, List<ClientMapping>> getValue() {
        return this.registryEntryProvider;
    }

    List<ClientMapping> getClientMappings() {
        ArrayList<ClientMapping> ret = new ArrayList<ClientMapping>();
        RemotingConnectorBindingInfoService.RemotingConnectorInfo info = (RemotingConnectorBindingInfoService.RemotingConnectorInfo)this.remotingConnectorInfo.getValue();
        if (info.getSocketBinding().getClientMappings() != null && !info.getSocketBinding().getClientMappings().isEmpty()) {
            ret.addAll(info.getSocketBinding().getClientMappings());
        } else {
            InetAddress clientNetworkAddress;
            String destinationAddress = info.getSocketBinding().getAddress().getHostAddress();
            try {
                clientNetworkAddress = InetAddress.getByName("::");
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            ClientMapping defaultClientMapping = new ClientMapping(clientNetworkAddress, 0, destinationAddress, info.getSocketBinding().getAbsolutePort());
            ret.add(defaultClientMapping);
        }
        return ret;
    }

    String getNodeName() {
        return ((ServerEnvironment)this.serverEnvironment.getValue()).getNodeName();
    }

    class ClientMappingEntryProvider
    implements RegistryEntryProvider<String, List<ClientMapping>> {
        ClientMappingEntryProvider() {
        }

        public String getKey() {
            return EJBRemotingConnectorClientMappingsEntryProviderService.this.getNodeName();
        }

        public List<ClientMapping> getValue() {
            return EJBRemotingConnectorClientMappingsEntryProviderService.this.getClientMappings();
        }
    }
}

