/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.AsyncConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AsyncConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<AsyncConfiguration> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private final AttributeSet attributes = AsyncConfiguration.attributeDefinitionSet();

    protected AsyncConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    @Deprecated
    public AsyncConfigurationBuilder asyncMarshalling() {
        log.ignoreAsyncMarshalling();
        return this;
    }

    @Deprecated
    public AsyncConfigurationBuilder asyncMarshalling(boolean async) {
        log.ignoreAsyncMarshalling();
        return this;
    }

    @Deprecated
    public AsyncConfigurationBuilder syncMarshalling() {
        log.ignoreAsyncMarshalling();
        return this;
    }

    public AsyncConfigurationBuilder replQueue(ReplicationQueue replicationQueue) {
        this.attributes.attribute(AsyncConfiguration.REPLICATION_QUEUE).set((Object)replicationQueue);
        return this;
    }

    public AsyncConfigurationBuilder replQueueInterval(long interval) {
        this.attributes.attribute(AsyncConfiguration.REPLICATION_QUEUE_INTERVAL).set((Object)interval);
        return this;
    }

    public AsyncConfigurationBuilder replQueueInterval(long interval, TimeUnit unit) {
        return this.replQueueInterval(unit.toMillis(interval));
    }

    public AsyncConfigurationBuilder replQueueMaxElements(int elements) {
        this.attributes.attribute(AsyncConfiguration.REPLICATION_QUEUE_MAX_ELEMENTS).set((Object)elements);
        return this;
    }

    public AsyncConfigurationBuilder useReplQueue(boolean use) {
        this.attributes.attribute(AsyncConfiguration.USE_REPLICATION_QUEUE).set((Object)use);
        return this;
    }

    public void validate() {
        if (((Boolean)this.attributes.attribute(AsyncConfiguration.USE_REPLICATION_QUEUE).get()).booleanValue() && this.getClusteringBuilder().cacheMode().isDistributed()) {
            throw log.noReplicationQueueDistributedCache();
        }
        if (((Boolean)this.attributes.attribute(AsyncConfiguration.USE_REPLICATION_QUEUE).get()).booleanValue() && this.getClusteringBuilder().cacheMode().isSynchronous()) {
            throw log.replicationQueueOnlyForAsyncCaches();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public AsyncConfiguration create() {
        return new AsyncConfiguration(this.attributes.protect());
    }

    public AsyncConfigurationBuilder read(AsyncConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return AsyncConfigurationBuilder.class.getSimpleName() + this.attributes;
    }
}

