/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Map;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.GroupCommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.cl.OptionGroup;
import org.jboss.aesh.cl.OptionList;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedCommandBuilder;
import org.jboss.aesh.cl.internal.ProcessedOptionBuilder;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserBuilder;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.console.AeshInvocationProviders;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.activator.AeshOptionActivatorProvider;
import org.jboss.aesh.console.command.completer.AeshCompleterInvocationProvider;
import org.jboss.aesh.console.command.container.AeshCommandContainer;
import org.jboss.aesh.console.command.converter.AeshConverterInvocationProvider;
import org.jboss.aesh.console.command.validator.AeshValidatorInvocationProvider;
import org.jboss.aesh.util.ReflectionUtil;

public class ParserGenerator {
    public static AeshCommandContainer generateCommandLineParser(Command paramInstance) throws CommandLineParserException {
        return ParserGenerator.doGenerateCommandLineParser(paramInstance);
    }

    public static AeshCommandContainer generateCommandLineParser(Class<? extends Command> clazz) throws CommandLineParserException {
        return ParserGenerator.doGenerateCommandLineParser(ReflectionUtil.newInstance(clazz));
    }

    private static AeshCommandContainer doGenerateCommandLineParser(Command commandObject) throws CommandLineParserException {
        Class<?> clazz = commandObject.getClass();
        CommandDefinition command = clazz.getAnnotation(CommandDefinition.class);
        if (command != null) {
            ProcessedCommand processedCommand = new ProcessedCommandBuilder().name(command.name()).description(command.description()).validator(command.validator()).command(commandObject).resultHandler(command.resultHandler()).create();
            ParserGenerator.processCommand(processedCommand, clazz);
            return new AeshCommandContainer(new CommandLineParserBuilder().processedCommand(processedCommand).create());
        }
        GroupCommandDefinition groupCommand = clazz.getAnnotation(GroupCommandDefinition.class);
        if (groupCommand != null) {
            ProcessedCommand processedGroupCommand = new ProcessedCommandBuilder().name(groupCommand.name()).description(groupCommand.description()).validator(groupCommand.validator()).command(commandObject).resultHandler(groupCommand.resultHandler()).create();
            ParserGenerator.processCommand(processedGroupCommand, clazz);
            AeshCommandContainer groupContainer = new AeshCommandContainer(new CommandLineParserBuilder().processedCommand(processedGroupCommand).create());
            for (Class<? extends Command> groupClazz : groupCommand.groupCommands()) {
                Command groupInstance = ReflectionUtil.newInstance(groupClazz);
                groupContainer.addChild(ParserGenerator.doGenerateCommandLineParser(groupInstance));
            }
            return groupContainer;
        }
        throw new CommandLineParserException("Commands must be annotated with @CommandDefinition or @GroupCommandDefinition");
    }

    private static void processCommand(ProcessedCommand processedCommand, Class clazz) throws CommandLineParserException {
        for (Field field : clazz.getDeclaredFields()) {
            ParserGenerator.processField(processedCommand, field);
        }
        if (clazz.getSuperclass() != null) {
            ParserGenerator.processCommand(processedCommand, clazz.getSuperclass());
        }
    }

    private static void processField(ProcessedCommand processedCommand, Field field) throws CommandLineParserException {
        Option o = field.getAnnotation(Option.class);
        if (o != null) {
            OptionType optionType = o.hasValue() ? OptionType.NORMAL : OptionType.BOOLEAN;
            if (o.name() == null || o.name().length() < 1) {
                processedCommand.addOption(new ProcessedOptionBuilder().shortName(o.shortName()).name(field.getName()).description(o.description()).required(o.required()).valueSeparator(',').addAllDefaultValues(o.defaultValue()).type(field.getType()).fieldName(field.getName()).optionType(optionType).converter(o.converter()).completer(o.completer()).validator(o.validator()).activator(o.activator()).renderer(o.renderer()).overrideRequired(o.overrideRequired()).create());
            } else {
                processedCommand.addOption(new ProcessedOptionBuilder().shortName(o.shortName()).name(o.name()).description(o.description()).required(o.required()).valueSeparator(',').addAllDefaultValues(o.defaultValue()).type(field.getType()).fieldName(field.getName()).optionType(optionType).converter(o.converter()).completer(o.completer()).validator(o.validator()).activator(o.activator()).renderer(o.renderer()).overrideRequired(o.overrideRequired()).create());
            }
        } else {
            OptionList ol = field.getAnnotation(OptionList.class);
            if (ol != null) {
                if (!Collection.class.isAssignableFrom(field.getType())) {
                    throw new CommandLineParserException("OptionList field must be instance of Collection");
                }
                Class type = Object.class;
                if (field.getGenericType() != null) {
                    ParameterizedType listType = (ParameterizedType)field.getGenericType();
                    type = (Class)listType.getActualTypeArguments()[0];
                }
                if (ol.name() == null || ol.name().length() < 1) {
                    processedCommand.addOption(new ProcessedOptionBuilder().shortName(ol.shortName()).name(field.getName()).description(ol.description()).required(ol.required()).valueSeparator(ol.valueSeparator()).addAllDefaultValues(ol.defaultValue()).type(type).fieldName(field.getName()).optionType(OptionType.LIST).converter(ol.converter()).completer(ol.completer()).validator(ol.validator()).activator(ol.activator()).renderer(ol.renderer()).create());
                } else {
                    processedCommand.addOption(new ProcessedOptionBuilder().shortName(ol.shortName()).name(ol.name()).description(ol.description()).required(ol.required()).valueSeparator(ol.valueSeparator()).addAllDefaultValues(ol.defaultValue()).type(type).fieldName(field.getName()).optionType(OptionType.LIST).converter(ol.converter()).completer(ol.completer()).validator(ol.validator()).activator(ol.activator()).renderer(ol.renderer()).create());
                }
            } else {
                OptionGroup og = field.getAnnotation(OptionGroup.class);
                if (og != null) {
                    if (!Map.class.isAssignableFrom(field.getType())) {
                        throw new CommandLineParserException("OptionGroup field must be instance of Map");
                    }
                    Class type = Object.class;
                    if (field.getGenericType() != null) {
                        ParameterizedType listType = (ParameterizedType)field.getGenericType();
                        type = (Class)listType.getActualTypeArguments()[1];
                    }
                    String name = og.name() == null || og.name().length() < 1 ? field.getName() : og.name();
                    processedCommand.addOption(new ProcessedOptionBuilder().shortName(og.shortName()).name(name).description(og.description()).required(og.required()).valueSeparator(',').addAllDefaultValues(og.defaultValue()).type(type).fieldName(field.getName()).optionType(OptionType.GROUP).converter(og.converter()).completer(og.completer()).validator(og.validator()).activator(og.activator()).renderer(og.renderer()).create());
                } else {
                    Arguments a = field.getAnnotation(Arguments.class);
                    if (a != null) {
                        if (!Collection.class.isAssignableFrom(field.getType())) {
                            throw new CommandLineParserException("Arguments field must be instance of Collection");
                        }
                        Class type = Object.class;
                        if (field.getGenericType() != null) {
                            ParameterizedType listType = (ParameterizedType)field.getGenericType();
                            type = (Class)listType.getActualTypeArguments()[0];
                        }
                        processedCommand.setArgument(new ProcessedOptionBuilder().shortName('\u0000').name("").description(a.description()).required(false).valueSeparator(a.valueSeparator()).addAllDefaultValues(a.defaultValue()).type(type).fieldName(field.getName()).optionType(OptionType.ARGUMENT).converter(a.converter()).completer(a.completer()).validator(a.validator()).create());
                    }
                }
            }
        }
    }

    public static void parseAndPopulate(Command instance, String commandName, String ... input) throws CommandLineParserException, OptionValidatorException {
        StringBuilder builder = new StringBuilder(commandName);
        for (String s : input) {
            builder.append(" ").append(s);
        }
        ParserGenerator.parseAndPopulate(instance, builder.toString());
    }

    public static void parseAndPopulate(Command instance, String input) throws CommandLineParserException, OptionValidatorException {
        CommandLineParser cl = ParserGenerator.doGenerateCommandLineParser(instance).getParser();
        AeshInvocationProviders invocationProviders = new AeshInvocationProviders(new AeshConverterInvocationProvider(), new AeshCompleterInvocationProvider(), new AeshValidatorInvocationProvider(), new AeshOptionActivatorProvider());
        cl.getCommandPopulator().populateObject(cl.parse(input), invocationProviders, null, true);
    }
}

