/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.agent.monitor.inventory.Name;

public class NameSet {
    private final Name name;
    private final boolean enabled;
    private final Set<Name> nameSet;

    public static NameSetBuilder builder() {
        return new NameSetBuilder();
    }

    private NameSet(Name name, boolean enabled, Set<Name> nameSet) {
        this.name = name;
        this.enabled = enabled;
        this.nameSet = nameSet;
    }

    public Name getName() {
        return this.name;
    }

    public Set<Name> getNameSet() {
        return this.nameSet;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDisabledOrEmpty() {
        return !this.isEnabled() || this.nameSet == null || this.nameSet.isEmpty();
    }

    public static class NameSetBuilder {
        private boolean enabled = true;
        private Name name;
        private Set<Name> nameSet = new HashSet<Name>();

        private NameSetBuilder() {
        }

        public NameSet build() {
            return new NameSet(this.name, this.enabled, Collections.unmodifiableSet(this.nameSet));
        }

        public NameSetBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public NameSetBuilder nameOfSet(Name setName) {
            this.name = setName;
            return this;
        }

        public NameSetBuilder name(Name name) {
            this.nameSet.add(name);
            return this;
        }
    }
}

