/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.CacheGroupAliasBuilderProvider;
import org.wildfly.clustering.spi.CacheGroupBuilderProvider;

public class RouteCacheGroupBuilderProvider
implements CacheGroupBuilderProvider,
CacheGroupAliasBuilderProvider {
    static final String CACHE_NAME = "routing";
    private final Class<? extends CacheGroupBuilderProvider> providerClass;

    RouteCacheGroupBuilderProvider(Class<? extends CacheGroupBuilderProvider> providerClass) {
        this.providerClass = providerClass;
    }

    public Collection<Builder<?>> getBuilders(String containerName, String cacheName) {
        LinkedList builders = new LinkedList();
        if (cacheName.equals("default")) {
            builders.add((Builder<?>)new TemplateConfigurationBuilder(containerName, CACHE_NAME, cacheName){

                public ConfigurationBuilder createConfigurationBuilder() {
                    ConfigurationBuilder builder = super.createConfigurationBuilder();
                    CacheMode mode = builder.clustering().cacheMode();
                    builder.clustering().cacheMode(mode.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
                    builder.persistence().clearStores();
                    return builder;
                }
            });
            builders.add((Builder<?>)new CacheBuilder(containerName, CACHE_NAME));
            for (CacheGroupBuilderProvider cacheGroupBuilderProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
                builders.addAll(cacheGroupBuilderProvider.getBuilders(containerName, CACHE_NAME));
            }
        }
        return builders;
    }

    public Collection<Builder<?>> getBuilders(String containerName, String aliasCacheName, String targetCacheName) {
        return this.getBuilders(containerName, aliasCacheName);
    }
}

