/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.extension;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.extension.DMRAvailAttributes;
import org.hawkular.agent.monitor.extension.DMRAvailSetAttributes;
import org.hawkular.agent.monitor.extension.DMRMetricAttributes;
import org.hawkular.agent.monitor.extension.DMRMetricSetAttributes;
import org.hawkular.agent.monitor.extension.DMROperationAttributes;
import org.hawkular.agent.monitor.extension.DMROperationParamAttributes;
import org.hawkular.agent.monitor.extension.DMRResourceConfigAttributes;
import org.hawkular.agent.monitor.extension.DMRResourceTypeAttributes;
import org.hawkular.agent.monitor.extension.DMRResourceTypeSetAttributes;
import org.hawkular.agent.monitor.extension.DiagnosticsAttributes;
import org.hawkular.agent.monitor.extension.FileStoresAttributes;
import org.hawkular.agent.monitor.extension.JMXAvailAttributes;
import org.hawkular.agent.monitor.extension.JMXAvailSetAttributes;
import org.hawkular.agent.monitor.extension.JMXMetricAttributes;
import org.hawkular.agent.monitor.extension.JMXMetricSetAttributes;
import org.hawkular.agent.monitor.extension.JMXOperationAttributes;
import org.hawkular.agent.monitor.extension.JMXResourceConfigAttributes;
import org.hawkular.agent.monitor.extension.JMXResourceTypeAttributes;
import org.hawkular.agent.monitor.extension.JMXResourceTypeSetAttributes;
import org.hawkular.agent.monitor.extension.LocalDMRAttributes;
import org.hawkular.agent.monitor.extension.LocalJMXAttributes;
import org.hawkular.agent.monitor.extension.MemoryAttributes;
import org.hawkular.agent.monitor.extension.PlatformAttributes;
import org.hawkular.agent.monitor.extension.PowerSourcesAttributes;
import org.hawkular.agent.monitor.extension.ProcessorsAttributes;
import org.hawkular.agent.monitor.extension.RemoteDMRAttributes;
import org.hawkular.agent.monitor.extension.RemoteJMXAttributes;
import org.hawkular.agent.monitor.extension.StorageAttributes;
import org.hawkular.agent.monitor.extension.SubsystemAttributes;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Interval;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.Name;
import org.hawkular.agent.monitor.inventory.NamedObject;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.OperationParam;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyType;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.inventory.TypeSet;
import org.hawkular.agent.monitor.inventory.TypeSets;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.jmx.JMXNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.Constants;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformPath;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;
import org.hawkular.agent.wildfly.log.AgentLoggers;
import org.hawkular.agent.wildfly.log.MsgLogger;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class MonitorServiceConfigurationBuilder {
    private static final MsgLogger log = AgentLoggers.getLogger(MonitorServiceConfigurationBuilder.class);
    private AgentCoreEngineConfiguration.ProtocolConfiguration.Builder<DMRNodeLocation> dmrConfigBuilder;
    private AgentCoreEngineConfiguration.ProtocolConfiguration.Builder<JMXNodeLocation> jmxConfigBuilder;
    private AgentCoreEngineConfiguration.ProtocolConfiguration.Builder<PlatformNodeLocation> platformConfigBuilder;
    private AgentCoreEngineConfiguration.DiagnosticsConfiguration diagnostics;
    private AgentCoreEngineConfiguration.StorageAdapterConfiguration storageAdapter;
    private AgentCoreEngineConfiguration.GlobalConfiguration globalConfiguration;

    public MonitorServiceConfigurationBuilder(ModelNode config, OperationContext context) throws OperationFailedException {
        this.globalConfiguration = MonitorServiceConfigurationBuilder.determineGlobalConfig(config, context);
        this.storageAdapter = MonitorServiceConfigurationBuilder.determineStorageAdapterConfig(config, context);
        this.diagnostics = MonitorServiceConfigurationBuilder.determineDiagnosticsConfig(config, context);
        this.dmrConfigBuilder = AgentCoreEngineConfiguration.ProtocolConfiguration.builder();
        this.jmxConfigBuilder = AgentCoreEngineConfiguration.ProtocolConfiguration.builder();
        this.platformConfigBuilder = AgentCoreEngineConfiguration.ProtocolConfiguration.builder();
        TypeSets.Builder dmrTypeSetsBuilder = TypeSets.builder();
        TypeSets.Builder jmxTypeSetsBuilder = TypeSets.builder();
        MonitorServiceConfigurationBuilder.determineMetricSetDmr(config, context, (TypeSets.Builder<DMRNodeLocation>)dmrTypeSetsBuilder, this.globalConfiguration);
        MonitorServiceConfigurationBuilder.determineAvailSetDmr(config, context, (TypeSets.Builder<DMRNodeLocation>)dmrTypeSetsBuilder, this.globalConfiguration);
        MonitorServiceConfigurationBuilder.determineMetricSetJmx(config, context, (TypeSets.Builder<JMXNodeLocation>)jmxTypeSetsBuilder, this.globalConfiguration);
        MonitorServiceConfigurationBuilder.determineAvailSetJmx(config, context, (TypeSets.Builder<JMXNodeLocation>)jmxTypeSetsBuilder, this.globalConfiguration);
        MonitorServiceConfigurationBuilder.determineResourceTypeSetDmr(config, context, (TypeSets.Builder<DMRNodeLocation>)dmrTypeSetsBuilder);
        MonitorServiceConfigurationBuilder.determineResourceTypeSetJmx(config, context, (TypeSets.Builder<JMXNodeLocation>)jmxTypeSetsBuilder);
        this.dmrConfigBuilder.typeSets(dmrTypeSetsBuilder.build());
        this.jmxConfigBuilder.typeSets(jmxTypeSetsBuilder.build());
        TypeSets<PlatformNodeLocation> platformTypeSets = MonitorServiceConfigurationBuilder.buildPlatformTypeSets(config, context);
        this.platformConfigBuilder.typeSets(platformTypeSets);
        if (!platformTypeSets.isDisabledOrEmpty()) {
            HashMap<String, String> customData = new HashMap<String, String>(2);
            customData.put("Machine Id", MonitorServiceConfigurationBuilder.determinePlatformMachineId(config, context));
            customData.put("Container Id", MonitorServiceConfigurationBuilder.determinePlatformContainerId(config, context));
            AgentCoreEngineConfiguration.EndpointConfiguration endpoint = new AgentCoreEngineConfiguration.EndpointConfiguration("platform", true, null, null, null, Avail.DOWN, null, null, null, customData, null);
            this.platformConfigBuilder.endpoint(endpoint);
        }
        this.determineManagedServers(config, context);
    }

    public AgentCoreEngineConfiguration build() {
        return new AgentCoreEngineConfiguration(this.globalConfiguration, this.diagnostics, this.storageAdapter, this.dmrConfigBuilder.build(), this.jmxConfigBuilder.build(), this.platformConfigBuilder.build());
    }

    private static void determineMetricSetDmr(ModelNode config, OperationContext context, TypeSets.Builder<DMRNodeLocation> typeSetsBuilder, AgentCoreEngineConfiguration.GlobalConfiguration globalConfiguration) throws OperationFailedException {
        boolean enabled = false;
        long minInterval = globalConfiguration.getMinCollectionIntervalSeconds();
        if (config.hasDefined("metric-set-dmr")) {
            List metricSetsList = config.get("metric-set-dmr").asPropertyList();
            for (Property metricSetProperty : metricSetsList) {
                String metricSetName = metricSetProperty.getName();
                if (metricSetName.indexOf(44) > -1) {
                    log.warnCommaInName(metricSetName);
                }
                ModelNode metricSetValueNode = metricSetProperty.getValue();
                TypeSet.TypeSetBuilder typeSetBuilder = TypeSet.builder().name(new Name(metricSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(metricSetValueNode, context, DMRMetricSetAttributes.ENABLED));
                if (metricSetValueNode.hasDefined("metric-dmr")) {
                    List metricsList = metricSetValueNode.get("metric-dmr").asPropertyList();
                    for (Property metricProperty : metricsList) {
                        MetricType metric;
                        String metricId = metricSetName + "~" + metricProperty.getName();
                        String metricName = metricProperty.getName();
                        ModelNode metricValueNode = metricProperty.getValue();
                        String attributeString = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, DMRMetricAttributes.ATTRIBUTE);
                        PathAddress pathAddress = MonitorServiceConfigurationBuilder.getPath(metricValueNode, context, DMRMetricAttributes.PATH);
                        boolean re = MonitorServiceConfigurationBuilder.getBoolean(metricValueNode, context, DMRMetricAttributes.RESOLVE_EXPRESSIONS);
                        boolean id = MonitorServiceConfigurationBuilder.getBoolean(metricValueNode, context, DMRMetricAttributes.INCLUDE_DEFAULTS);
                        String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, DMRMetricAttributes.METRIC_ID_TEMPLATE);
                        Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(metricValueNode, context, DMRMetricAttributes.METRIC_TAGS);
                        AttributeLocation location = new AttributeLocation((Object)new DMRNodeLocation(pathAddress, re, id), attributeString);
                        Interval interval = new Interval(MonitorServiceConfigurationBuilder.getInt(metricValueNode, context, DMRMetricAttributes.INTERVAL), MonitorServiceConfigurationBuilder.getTimeUnit(metricValueNode, context, DMRMetricAttributes.TIME_UNITS));
                        long intervalSecs = interval.seconds();
                        if (intervalSecs > 0L && intervalSecs < minInterval) {
                            log.warnf("Metric [%s] interval being changed from [%s]s to minimum of [%s]s", metricName, intervalSecs, minInterval);
                            interval = new Interval((int)minInterval, TimeUnit.SECONDS);
                        }
                        if ((metric = new MetricType(new ID(metricId), new Name(metricName), location, interval, MonitorServiceConfigurationBuilder.getMeasurementUnit(metricValueNode, context, DMRMetricAttributes.METRIC_UNITS), MonitorServiceConfigurationBuilder.getMetricType(metricValueNode, context, DMRMetricAttributes.METRIC_TYPE), metricIdTemplate, metricTags)).isDisabled()) {
                            log.debugf("Metric [%s] is Disabled for collection.", metric.getName());
                        }
                        typeSetBuilder.type((NamedObject)metric);
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.metricTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledMetricsConfigured("DMR");
        }
    }

    private static org.hawkular.metrics.client.common.MetricType getMetricType(ModelNode metricValueNode, OperationContext context, SimpleAttributeDefinition metricType) throws OperationFailedException {
        String metricTypeStr = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, metricType);
        if (metricTypeStr == null) {
            return org.hawkular.metrics.client.common.MetricType.GAUGE;
        }
        return org.hawkular.metrics.client.common.MetricType.valueOf((String)metricTypeStr.toUpperCase(Locale.ENGLISH));
    }

    private static MeasurementUnit getMeasurementUnit(ModelNode metricValueNode, OperationContext context, SimpleAttributeDefinition metricUnits) throws OperationFailedException {
        String metricUnitsStr = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, metricUnits);
        if (metricUnitsStr == null) {
            return MeasurementUnit.NONE;
        }
        return MeasurementUnit.valueOf((String)metricUnitsStr.toUpperCase(Locale.ENGLISH));
    }

    private static TimeUnit getTimeUnit(ModelNode metricValueNode, OperationContext context, SimpleAttributeDefinition timeUnits) throws OperationFailedException {
        String metricTimeUnitsStr = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, timeUnits);
        return TimeUnit.valueOf(metricTimeUnitsStr.toUpperCase());
    }

    private static void determineAvailSetDmr(ModelNode config, OperationContext context, TypeSets.Builder<DMRNodeLocation> typeSetsBuilder, AgentCoreEngineConfiguration.GlobalConfiguration globalConfiguration) throws OperationFailedException {
        boolean enabled = false;
        long minInterval = globalConfiguration.getMinCollectionIntervalSeconds();
        if (config.hasDefined("avail-set-dmr")) {
            List availSetsList = config.get("avail-set-dmr").asPropertyList();
            for (Property availSetProperty : availSetsList) {
                String availSetName = availSetProperty.getName();
                if (availSetName.indexOf(44) > -1) {
                    log.warnCommaInName(availSetName);
                }
                ModelNode availSetValueNode = availSetProperty.getValue();
                TypeSet.TypeSetBuilder typeSetBuilder = TypeSet.builder().name(new Name(availSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(availSetValueNode, context, DMRAvailSetAttributes.ENABLED));
                if (!availSetValueNode.hasDefined("avail-dmr")) continue;
                List availsList = availSetValueNode.get("avail-dmr").asPropertyList();
                for (Property availProperty : availsList) {
                    AvailType avail;
                    String availId = availSetName + "~" + availProperty.getName();
                    String availName = availProperty.getName();
                    ModelNode availValueNode = availProperty.getValue();
                    String attributeString = MonitorServiceConfigurationBuilder.getString(availValueNode, context, DMRAvailAttributes.ATTRIBUTE);
                    PathAddress pathAddress = MonitorServiceConfigurationBuilder.getPath(availValueNode, context, DMRAvailAttributes.PATH);
                    boolean re = MonitorServiceConfigurationBuilder.getBoolean(availValueNode, context, DMRAvailAttributes.RESOLVE_EXPRESSIONS);
                    boolean id = MonitorServiceConfigurationBuilder.getBoolean(availValueNode, context, DMRAvailAttributes.INCLUDE_DEFAULTS);
                    String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(availValueNode, context, DMRAvailAttributes.METRIC_ID_TEMPLATE);
                    Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(availValueNode, context, DMRAvailAttributes.METRIC_TAGS);
                    AttributeLocation location = new AttributeLocation((Object)new DMRNodeLocation(pathAddress, re, id), attributeString);
                    Interval interval = new Interval(MonitorServiceConfigurationBuilder.getInt(availValueNode, context, DMRMetricAttributes.INTERVAL), MonitorServiceConfigurationBuilder.getTimeUnit(availValueNode, context, DMRMetricAttributes.TIME_UNITS));
                    long intervalSecs = interval.seconds();
                    if (intervalSecs > 0L && intervalSecs < minInterval) {
                        log.warnf("Avail [%s] interval being changed from [%s]s to minimum of [%s]s", availName, intervalSecs, minInterval);
                        interval = new Interval((int)minInterval, TimeUnit.SECONDS);
                    }
                    if ((avail = new AvailType(new ID(availId), new Name(availName), location, interval, Pattern.compile(MonitorServiceConfigurationBuilder.getString(availValueNode, context, DMRAvailAttributes.UP_REGEX)), metricIdTemplate, metricTags)).isDisabled()) {
                        log.debugf("Avail [%s] is Disabled for collection.", avail.getName());
                    }
                    typeSetBuilder.type((NamedObject)avail);
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.availTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledAvailsConfigured("DMR");
        }
    }

    private static void determineMetricSetJmx(ModelNode config, OperationContext context, TypeSets.Builder<JMXNodeLocation> typeSetsBuilder, AgentCoreEngineConfiguration.GlobalConfiguration globalConfiguration) throws OperationFailedException {
        boolean enabled = false;
        long minInterval = globalConfiguration.getMinCollectionIntervalSeconds();
        if (config.hasDefined("metric-set-jmx")) {
            List metricSetsList = config.get("metric-set-jmx").asPropertyList();
            for (Property metricSetProperty : metricSetsList) {
                String metricSetName = metricSetProperty.getName();
                if (metricSetName.indexOf(44) > -1) {
                    log.warnCommaInName(metricSetName);
                }
                ModelNode metricSetValueNode = metricSetProperty.getValue();
                TypeSet.TypeSetBuilder typeSetBuilder = TypeSet.builder().name(new Name(metricSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(metricSetValueNode, context, JMXMetricSetAttributes.ENABLED));
                if (!metricSetValueNode.hasDefined("metric-jmx")) continue;
                List metricsList = metricSetValueNode.get("metric-jmx").asPropertyList();
                for (Property metricProperty : metricsList) {
                    String metricId = metricSetName + "~" + metricProperty.getName();
                    String metricName = metricProperty.getName();
                    ModelNode metricValueNode = metricProperty.getValue();
                    String objectName = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, JMXMetricAttributes.OBJECT_NAME);
                    String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(metricValueNode, context, JMXMetricAttributes.METRIC_ID_TEMPLATE);
                    Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(metricValueNode, context, JMXMetricAttributes.METRIC_TAGS);
                    try {
                        MetricType metric;
                        AttributeLocation location = new AttributeLocation((Object)new JMXNodeLocation(objectName), MonitorServiceConfigurationBuilder.getString(metricValueNode, context, JMXMetricAttributes.ATTRIBUTE));
                        Interval interval = new Interval(MonitorServiceConfigurationBuilder.getInt(metricValueNode, context, DMRMetricAttributes.INTERVAL), MonitorServiceConfigurationBuilder.getTimeUnit(metricValueNode, context, DMRMetricAttributes.TIME_UNITS));
                        long intervalSecs = interval.seconds();
                        if (intervalSecs > 0L && intervalSecs < minInterval) {
                            log.warnf("Metric [%s] interval being changed from [%s]s to minimum of [%s]s", metricName, intervalSecs, minInterval);
                            interval = new Interval((int)minInterval, TimeUnit.SECONDS);
                        }
                        if ((metric = new MetricType(new ID(metricId), new Name(metricName), location, interval, MonitorServiceConfigurationBuilder.getMeasurementUnit(metricValueNode, context, JMXMetricAttributes.METRIC_UNITS), MonitorServiceConfigurationBuilder.getMetricType(metricValueNode, context, JMXMetricAttributes.METRIC_TYPE), metricIdTemplate, metricTags)).isDisabled()) {
                            log.debugf("Metric [%s] is Disabled for collection.", metric.getName());
                        }
                        typeSetBuilder.type((NamedObject)metric);
                    }
                    catch (MalformedObjectNameException e) {
                        log.warnMalformedJMXObjectName(objectName, e);
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.metricTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledMetricsConfigured("JMX");
        }
    }

    private static void determineAvailSetJmx(ModelNode config, OperationContext context, TypeSets.Builder<JMXNodeLocation> typeSetsBuilder, AgentCoreEngineConfiguration.GlobalConfiguration globalConfiguration) throws OperationFailedException {
        boolean enabled = false;
        long minInterval = globalConfiguration.getMinCollectionIntervalSeconds();
        if (config.hasDefined("avail-set-jmx")) {
            List availSetsList = config.get("avail-set-jmx").asPropertyList();
            for (Property availSetProperty : availSetsList) {
                String availSetName = availSetProperty.getName();
                if (availSetName.indexOf(44) > -1) {
                    log.warnCommaInName(availSetName);
                }
                ModelNode availSetValueNode = availSetProperty.getValue();
                TypeSet.TypeSetBuilder typeSetBuilder = TypeSet.builder().name(new Name(availSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(availSetValueNode, context, JMXAvailSetAttributes.ENABLED));
                if (!availSetValueNode.hasDefined("avail-jmx")) continue;
                List availsList = availSetValueNode.get("avail-jmx").asPropertyList();
                for (Property availProperty : availsList) {
                    String availId = availSetName + "~" + availProperty.getName();
                    String availName = availProperty.getName();
                    ModelNode availValueNode = availProperty.getValue();
                    String objectName = MonitorServiceConfigurationBuilder.getString(availValueNode, context, JMXAvailAttributes.OBJECT_NAME);
                    String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(availValueNode, context, JMXAvailAttributes.METRIC_ID_TEMPLATE);
                    Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(availValueNode, context, JMXAvailAttributes.METRIC_TAGS);
                    try {
                        AvailType avail;
                        AttributeLocation location = new AttributeLocation((Object)new JMXNodeLocation(objectName), MonitorServiceConfigurationBuilder.getString(availValueNode, context, JMXAvailAttributes.ATTRIBUTE));
                        Interval interval = new Interval(MonitorServiceConfigurationBuilder.getInt(availValueNode, context, DMRMetricAttributes.INTERVAL), MonitorServiceConfigurationBuilder.getTimeUnit(availValueNode, context, DMRMetricAttributes.TIME_UNITS));
                        long intervalSecs = interval.seconds();
                        if (intervalSecs > 0L && intervalSecs < minInterval) {
                            log.warnf("Avail [%s] interval being changed from [%s]s to minimum of [%s]s", availName, intervalSecs, minInterval);
                            interval = new Interval((int)minInterval, TimeUnit.SECONDS);
                        }
                        if ((avail = new AvailType(new ID(availId), new Name(availName), location, interval, Pattern.compile(MonitorServiceConfigurationBuilder.getString(availValueNode, context, JMXAvailAttributes.UP_REGEX)), metricIdTemplate, metricTags)).isDisabled()) {
                            log.debugf("Avail [%s] is Disabled for collection.", avail.getName());
                        }
                        typeSetBuilder.type((NamedObject)avail);
                    }
                    catch (MalformedObjectNameException e) {
                        log.warnMalformedJMXObjectName(objectName, e);
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.availTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledAvailsConfigured("JMX");
        }
    }

    private static String determinePlatformMachineId(ModelNode config, OperationContext context) throws OperationFailedException {
        if (!config.hasDefined("platform")) {
            return null;
        }
        List asPropertyList = config.get("platform").asPropertyList();
        if (asPropertyList.size() == 0) {
            return null;
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one platform config allowed: " + config.toJSONString(true));
        }
        ModelNode platformValueNode = ((Property)asPropertyList.get(0)).getValue();
        String machineId = MonitorServiceConfigurationBuilder.getString(platformValueNode, context, PlatformAttributes.MACHINE_ID);
        return machineId;
    }

    private static String determinePlatformContainerId(ModelNode config, OperationContext context) throws OperationFailedException {
        if (!config.hasDefined("platform")) {
            return null;
        }
        List asPropertyList = config.get("platform").asPropertyList();
        if (asPropertyList.size() == 0) {
            return null;
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one platform config allowed: " + config.toJSONString(true));
        }
        ModelNode platformValueNode = ((Property)asPropertyList.get(0)).getValue();
        String containerId = MonitorServiceConfigurationBuilder.getString(platformValueNode, context, PlatformAttributes.CONTAINER_ID);
        return containerId;
    }

    private static TypeSets<PlatformNodeLocation> buildPlatformTypeSets(ModelNode config, OperationContext context) throws OperationFailedException {
        TypeSet typeSet;
        Interval interval;
        boolean enabled;
        if (!config.hasDefined("platform")) {
            log.infoNoPlatformConfig();
            return TypeSets.empty();
        }
        List asPropertyList = config.get("platform").asPropertyList();
        if (asPropertyList.size() == 0) {
            log.infoNoPlatformConfig();
            return TypeSets.empty();
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one platform config allowed: " + config.toJSONString(true));
        }
        ModelNode platformValueNode = ((Property)asPropertyList.get(0)).getValue();
        boolean typeSetsEnabled = MonitorServiceConfigurationBuilder.getBoolean(platformValueNode, context, PlatformAttributes.ENABLED);
        if (!typeSetsEnabled) {
            log.debugf("Platform monitoring is disabled", new Object[0]);
            return TypeSets.empty();
        }
        TypeSets.Builder typeSetsBuilder = TypeSets.builder();
        ID osId = Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeId();
        Name osName = Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeName();
        ResourceType.Builder rootTypeBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(osId)).name(osName)).location((Object)new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.OPERATING_SYSTEM).build()))).resourceNameTemplate("%s");
        ResourceConfigurationPropertyType machineIdConfigType = new ResourceConfigurationPropertyType(ID.NULL_ID, new Name("Machine Id"), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), "Machine Id"));
        rootTypeBldr.resourceConfigurationPropertyType(machineIdConfigType);
        ResourceConfigurationPropertyType containerIdConfigType = new ResourceConfigurationPropertyType(ID.NULL_ID, new Name("Container Id"), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), "Container Id"));
        rootTypeBldr.resourceConfigurationPropertyType(containerIdConfigType);
        Interval osInterval = new Interval(MonitorServiceConfigurationBuilder.getInt(platformValueNode, context, PlatformAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(platformValueNode, context, PlatformAttributes.TIME_UNITS).toUpperCase()));
        MetricType systemCpuLoad = new MetricType(Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeId(), Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_SYS_CPU_LOAD.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        MetricType systemLoadAverage = new MetricType(Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeId(), Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_SYS_LOAD_AVG.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.NONE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        MetricType processCount = new MetricType(Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeId(), Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.OS_PROCESS_COUNT.getMetricTypeId().getIDString()), osInterval, MeasurementUnit.NONE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
        TypeSet osMetrics = TypeSet.builder().name(Constants.PlatformResourceType.OPERATING_SYSTEM.getResourceTypeName()).type((NamedObject)systemCpuLoad).type((NamedObject)systemLoadAverage).type((NamedObject)processCount).build();
        typeSetsBuilder.metricTypeSet(osMetrics);
        rootTypeBldr.metricSetName(osMetrics.getName());
        MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(rootTypeBldr, typeSetsBuilder);
        ResourceType rootType = rootTypeBldr.build();
        TypeSet rootTypeSet = TypeSet.builder().enabled(true).name(osName).type((NamedObject)rootType).build();
        typeSetsBuilder.resourceTypeSet(rootTypeSet);
        if (platformValueNode.hasDefined("file-stores")) {
            asPropertyList = platformValueNode.get("file-stores").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode fileStoresNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(fileStoresNode, context, FileStoresAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(fileStoresNode, context, FileStoresAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(fileStoresNode, context, FileStoresAttributes.TIME_UNITS).toUpperCase()));
                    MetricType usableSpace = new MetricType(Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeId(), Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.FILE_STORE_USABLE_SPACE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    MetricType totalSpace = new MetricType(Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeId(), Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.FILE_STORE_TOTAL_SPACE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    TypeSet fileStoreMetrics = TypeSet.builder().name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName()).type((NamedObject)usableSpace).type((NamedObject)totalSpace).build();
                    typeSetsBuilder.metricTypeSet(fileStoreMetrics);
                    PlatformNodeLocation fileStoreLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.FILE_STORE).build());
                    ResourceType.Builder fileStoreBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.FILE_STORE.getResourceTypeId())).name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName())).location((Object)fileStoreLocation)).resourceNameTemplate(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName().getNameString() + " [%s]").parent(rootType.getName()).metricSetName(fileStoreMetrics.getName());
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(fileStoreBldr, typeSetsBuilder);
                    ResourceType fileStore = fileStoreBldr.build();
                    typeSet = TypeSet.builder().name(Constants.PlatformResourceType.FILE_STORE.getResourceTypeName()).type((NamedObject)fileStore).build();
                    typeSetsBuilder.resourceTypeSet(typeSet);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.file-stores config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        if (platformValueNode.hasDefined("memory")) {
            asPropertyList = platformValueNode.get("memory").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode memoryNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(memoryNode, context, MemoryAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(memoryNode, context, MemoryAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(memoryNode, context, MemoryAttributes.TIME_UNITS).toUpperCase()));
                    MetricType available = new MetricType(Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeId(), Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.MEMORY_AVAILABLE.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    MetricType total = new MetricType(Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeId(), Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.MEMORY_TOTAL.getMetricTypeId().getIDString()), interval, MeasurementUnit.BYTES, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    TypeSet memoryMetrics = TypeSet.builder().name(Constants.PlatformResourceType.MEMORY.getResourceTypeName()).type((NamedObject)available).type((NamedObject)total).build();
                    typeSetsBuilder.metricTypeSet(memoryMetrics);
                    PlatformNodeLocation memoryLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.MEMORY).build());
                    ResourceType.Builder memoryBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.MEMORY.getResourceTypeId())).name(Constants.PlatformResourceType.MEMORY.getResourceTypeName())).parent(rootType.getName()).location((Object)memoryLocation)).metricSetName(memoryMetrics.getName()).resourceNameTemplate(Constants.PlatformResourceType.MEMORY.getResourceTypeName().getNameString());
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(memoryBldr, typeSetsBuilder);
                    ResourceType memory = memoryBldr.build();
                    typeSet = TypeSet.builder().name(Constants.PlatformResourceType.MEMORY.getResourceTypeName()).type((NamedObject)memory).build();
                    typeSetsBuilder.resourceTypeSet(typeSet);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.memory config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        if (platformValueNode.hasDefined("processors")) {
            asPropertyList = platformValueNode.get("processors").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode processorsNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(processorsNode, context, ProcessorsAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(processorsNode, context, ProcessorsAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(processorsNode, context, ProcessorsAttributes.TIME_UNITS).toUpperCase()));
                    MetricType cpuUsage = new MetricType(Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeId(), Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.PROCESSOR_CPU_USAGE.getMetricTypeId().getIDString()), interval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    TypeSet processorMetrics = TypeSet.builder().name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName()).type((NamedObject)cpuUsage).build();
                    typeSetsBuilder.metricTypeSet(processorMetrics);
                    PlatformNodeLocation processorsLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.PROCESSOR).build());
                    ResourceType.Builder processorBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.PROCESSOR.getResourceTypeId())).name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName())).parent(rootType.getName()).location((Object)processorsLocation)).metricSetName(processorMetrics.getName()).resourceNameTemplate(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName().getNameString() + " [%s]");
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(processorBldr, typeSetsBuilder);
                    ResourceType processor = processorBldr.build();
                    TypeSet typeSet2 = TypeSet.builder().name(Constants.PlatformResourceType.PROCESSOR.getResourceTypeName()).type((NamedObject)processor).build();
                    typeSetsBuilder.resourceTypeSet(typeSet2);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.processors config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        if (platformValueNode.hasDefined("power-sources")) {
            asPropertyList = platformValueNode.get("power-sources").asPropertyList();
            if (asPropertyList.size() == 1) {
                ModelNode powerSourcesNode = ((Property)asPropertyList.get(0)).getValue();
                enabled = MonitorServiceConfigurationBuilder.getBoolean(powerSourcesNode, context, PowerSourcesAttributes.ENABLED);
                if (enabled) {
                    interval = new Interval(MonitorServiceConfigurationBuilder.getInt(powerSourcesNode, context, PowerSourcesAttributes.INTERVAL), TimeUnit.valueOf(MonitorServiceConfigurationBuilder.getString(powerSourcesNode, context, PowerSourcesAttributes.TIME_UNITS).toUpperCase()));
                    MetricType remainingCap = new MetricType(Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeId(), Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.POWER_SOURCE_REMAINING_CAPACITY.getMetricTypeId().getIDString()), interval, MeasurementUnit.PERCENTAGE, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    MetricType timeRemaining = new MetricType(Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeId(), Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeName(), new AttributeLocation((Object)new PlatformNodeLocation(PlatformPath.empty()), Constants.PlatformMetricType.POWER_SOURCE_TIME_REMAINING.getMetricTypeId().getIDString()), interval, MeasurementUnit.SECONDS, org.hawkular.metrics.client.common.MetricType.GAUGE, null, null);
                    TypeSet powerSourceMetrics = TypeSet.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName()).type((NamedObject)remainingCap).type((NamedObject)timeRemaining).build();
                    typeSetsBuilder.metricTypeSet(powerSourceMetrics);
                    PlatformNodeLocation powerSourcesLocation = new PlatformNodeLocation(PlatformPath.builder().any(Constants.PlatformResourceType.POWER_SOURCE).build());
                    ResourceType.Builder powerSourceBldr = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeId())).name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName())).parent(rootType.getName()).location((Object)powerSourcesLocation)).metricSetName(powerSourceMetrics.getName()).resourceNameTemplate(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName().getNameString() + " [%s]");
                    MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(powerSourceBldr, typeSetsBuilder);
                    ResourceType powerSource = powerSourceBldr.build();
                    typeSet = TypeSet.builder().name(Constants.PlatformResourceType.POWER_SOURCE.getResourceTypeName()).type((NamedObject)powerSource).build();
                    typeSetsBuilder.resourceTypeSet(typeSet);
                }
            } else if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Only one platform.power-sources config allowed: " + platformValueNode.toJSONString(true));
            }
        }
        return typeSetsBuilder.build();
    }

    private static AgentCoreEngineConfiguration.DiagnosticsConfiguration determineDiagnosticsConfig(ModelNode config, OperationContext context) throws OperationFailedException {
        if (!config.hasDefined("diagnostics")) {
            log.infoNoDiagnosticsConfig();
            return AgentCoreEngineConfiguration.DiagnosticsConfiguration.EMPTY;
        }
        List asPropertyList = config.get("diagnostics").asPropertyList();
        if (asPropertyList.size() == 0) {
            log.infoNoDiagnosticsConfig();
            return AgentCoreEngineConfiguration.DiagnosticsConfiguration.EMPTY;
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one diagnostics config allowed: " + config.toJSONString(true));
        }
        ModelNode diagnosticsValueNode = ((Property)asPropertyList.get(0)).getValue();
        String reportToStr = MonitorServiceConfigurationBuilder.getString(diagnosticsValueNode, context, DiagnosticsAttributes.REPORT_TO);
        AgentCoreEngineConfiguration.DiagnosticsReportTo reportTo = AgentCoreEngineConfiguration.DiagnosticsReportTo.valueOf((String)reportToStr.toUpperCase());
        boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(diagnosticsValueNode, context, DiagnosticsAttributes.ENABLED);
        int interval = MonitorServiceConfigurationBuilder.getInt(diagnosticsValueNode, context, DiagnosticsAttributes.INTERVAL);
        String diagnosticsTimeUnitsStr = MonitorServiceConfigurationBuilder.getString(diagnosticsValueNode, context, DiagnosticsAttributes.TIME_UNITS);
        TimeUnit timeUnits = TimeUnit.valueOf(diagnosticsTimeUnitsStr.toUpperCase());
        return new AgentCoreEngineConfiguration.DiagnosticsConfiguration(enabled, reportTo, interval, timeUnits);
    }

    private static AgentCoreEngineConfiguration.StorageAdapterConfiguration determineStorageAdapterConfig(ModelNode config, OperationContext context) throws OperationFailedException {
        if (!config.hasDefined("storage-adapter")) {
            throw new IllegalArgumentException("Missing storage adapter configuration: " + config.toJSONString(true));
        }
        List asPropertyList = config.get("storage-adapter").asPropertyList();
        if (asPropertyList.size() == 0) {
            throw new IllegalArgumentException("Missing storage adapter configuration: " + config.toJSONString(true));
        }
        if (asPropertyList.size() > 1) {
            throw new IllegalArgumentException("Only one storage adapter allowed: " + config.toJSONString(true));
        }
        ModelNode storageAdapterConfig = ((Property)asPropertyList.get(0)).getValue();
        String url = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.URL);
        boolean useSSL = false;
        if (url != null) {
            useSSL = url.startsWith("https");
            log.infoUsingSSL(url, useSSL);
        } else {
            useSSL = MonitorServiceConfigurationBuilder.getBoolean(storageAdapterConfig, context, StorageAttributes.USE_SSL);
        }
        String securityRealm = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.SECURITY_REALM);
        String keystorePath = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.KEYSTORE_PATH);
        String keystorePassword = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.KEYSTORE_PASSWORD);
        String serverOutboundSocketBindingRef = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.SERVER_OUTBOUND_SOCKET_BINDING_REF);
        String tenantId = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.TENANT_ID);
        String feedId = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.FEED_ID);
        String inventoryContext = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.INVENTORY_CONTEXT);
        String metricsContext = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.METRICS_CONTEXT);
        String feedcommContext = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.FEEDCOMM_CONTEXT);
        String username = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.USERNAME);
        String password = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.PASSWORD);
        String typeStr = MonitorServiceConfigurationBuilder.getString(storageAdapterConfig, context, StorageAttributes.TYPE);
        AgentCoreEngineConfiguration.StorageReportTo type = AgentCoreEngineConfiguration.StorageReportTo.valueOf((String)typeStr.toUpperCase());
        int connectTimeoutSeconds = MonitorServiceConfigurationBuilder.getInt(storageAdapterConfig, context, StorageAttributes.CONNECT_TIMEOUT_SECONDS);
        int readTimeoutSeconds = MonitorServiceConfigurationBuilder.getInt(storageAdapterConfig, context, StorageAttributes.READ_TIMEOUT_SECONDS);
        if (useSSL && securityRealm == null) {
            if (keystorePath == null) {
                throw new IllegalArgumentException("In order to use SSL, a securityRealm or keystorePath must be specified");
            }
            if (keystorePassword == null) {
                throw new IllegalArgumentException("In order to use SSL, a securityRealm or keystorePassword must be specified");
            }
        }
        if (username == null || password == null) {
            throw new IllegalArgumentException("Must have a username/password");
        }
        return new AgentCoreEngineConfiguration.StorageAdapterConfiguration(type, username, password, tenantId, feedId, url, useSSL, serverOutboundSocketBindingRef, inventoryContext, metricsContext, feedcommContext, keystorePath, keystorePassword, securityRealm, connectTimeoutSeconds, readTimeoutSeconds);
    }

    private static AgentCoreEngineConfiguration.GlobalConfiguration determineGlobalConfig(ModelNode config, OperationContext context) throws OperationFailedException {
        boolean subsystemEnabled = MonitorServiceConfigurationBuilder.getBoolean(config, context, SubsystemAttributes.ENABLED);
        boolean immutable = MonitorServiceConfigurationBuilder.getBoolean(config, context, SubsystemAttributes.IMMUTABLE);
        boolean inContainer = MonitorServiceConfigurationBuilder.getBoolean(config, context, SubsystemAttributes.IN_CONTAINER);
        String apiJndi = MonitorServiceConfigurationBuilder.getString(config, context, SubsystemAttributes.API_JNDI);
        int autoDiscoveryScanPeriodSecs = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.AUTO_DISCOVERY_SCAN_PERIOD_SECONDS);
        int minCollectionIntervalSecs = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.MIN_COLLECTION_INTERVAL_SECS);
        int numDmrSchedulerThreads = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.NUM_DMR_SCHEDULER_THREADS);
        int metricDispatcherBufferSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.METRIC_DISPATCHER_BUFFER_SIZE);
        int metricDispatcherMaxBatchSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.METRIC_DISPATCHER_MAX_BATCH_SIZE);
        int availDispatcherBufferSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.AVAIL_DISPATCHER_BUFFER_SIZE);
        int availDispatcherMaxBatchSize = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.AVAIL_DISPATCHER_MAX_BATCH_SIZE);
        int pingDispatcherPeriodSeconds = MonitorServiceConfigurationBuilder.getInt(config, context, SubsystemAttributes.PING_DISPATCHER_PERIOD_SECONDS);
        return new AgentCoreEngineConfiguration.GlobalConfiguration(subsystemEnabled, immutable, inContainer, apiJndi, autoDiscoveryScanPeriodSecs, minCollectionIntervalSecs, numDmrSchedulerThreads, metricDispatcherBufferSize, metricDispatcherMaxBatchSize, availDispatcherBufferSize, availDispatcherMaxBatchSize, pingDispatcherPeriodSeconds);
    }

    private static void determineResourceTypeSetDmr(ModelNode config, OperationContext context, TypeSets.Builder<DMRNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("resource-type-set-dmr")) {
            List resourceTypeSetsList = config.get("resource-type-set-dmr").asPropertyList();
            for (Property resourceTypeSetProperty : resourceTypeSetsList) {
                String resourceTypeSetName = resourceTypeSetProperty.getName();
                ModelNode resourceTypeSetValueNode = resourceTypeSetProperty.getValue();
                TypeSet.TypeSetBuilder typeSetBuilder = TypeSet.builder().name(new Name(resourceTypeSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(resourceTypeSetValueNode, context, DMRResourceTypeSetAttributes.ENABLED));
                if (resourceTypeSetName.indexOf(44) > -1) {
                    log.warnCommaInName(resourceTypeSetName);
                }
                if (resourceTypeSetValueNode.hasDefined("resource-type-dmr")) {
                    List resourceTypesList = resourceTypeSetValueNode.get("resource-type-dmr").asPropertyList();
                    for (Property resourceTypeProperty : resourceTypesList) {
                        ModelNode configModelNode;
                        ModelNode resourceTypeValueNode = resourceTypeProperty.getValue();
                        String resourceTypeName = resourceTypeProperty.getName();
                        ResourceType.Builder resourceTypeBuilder = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(ID.NULL_ID)).name(new Name(resourceTypeName))).location((Object)new DMRNodeLocation(MonitorServiceConfigurationBuilder.getPath(resourceTypeValueNode, context, DMRResourceTypeAttributes.PATH)))).resourceNameTemplate(MonitorServiceConfigurationBuilder.getString(resourceTypeValueNode, context, DMRResourceTypeAttributes.RESOURCE_NAME_TEMPLATE)).parents(MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, DMRResourceTypeAttributes.PARENTS));
                        List<Name> metricSets = MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, DMRResourceTypeAttributes.METRIC_SETS);
                        List<Name> availSets = MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, DMRResourceTypeAttributes.AVAIL_SETS);
                        resourceTypeBuilder.metricSetNames(metricSets).availSetNames(availSets);
                        ModelNode opModelNode = resourceTypeValueNode.get("operation-dmr");
                        if (opModelNode != null && opModelNode.isDefined()) {
                            List operationList = opModelNode.asPropertyList();
                            for (Property operationProperty : operationList) {
                                ModelNode operationValueNode = operationProperty.getValue();
                                String name = operationProperty.getName();
                                List<OperationParam> params = MonitorServiceConfigurationBuilder.getOpParamListFromOpNode(operationValueNode, context);
                                PathAddress pathAddress = MonitorServiceConfigurationBuilder.getPath(operationValueNode, context, DMROperationAttributes.PATH);
                                String internalName = MonitorServiceConfigurationBuilder.getString(operationValueNode, context, DMROperationAttributes.INTERNAL_NAME);
                                boolean modifies = MonitorServiceConfigurationBuilder.getBoolean(operationValueNode, context, DMROperationAttributes.MODIFIES);
                                Operation op = new Operation(ID.NULL_ID, new Name(name), (Object)new DMRNodeLocation(pathAddress), internalName, modifies, params);
                                resourceTypeBuilder.operation(op);
                            }
                        }
                        if ((configModelNode = resourceTypeValueNode.get("resource-config-dmr")) != null && configModelNode.isDefined()) {
                            List configList = configModelNode.asPropertyList();
                            for (Property configProperty : configList) {
                                ModelNode configValueNode = configProperty.getValue();
                                String configName = configProperty.getName();
                                String attributeString = MonitorServiceConfigurationBuilder.getString(configValueNode, context, DMRResourceConfigAttributes.ATTRIBUTE);
                                PathAddress pathAddress = MonitorServiceConfigurationBuilder.getPath(configValueNode, context, DMRResourceConfigAttributes.PATH);
                                boolean re = MonitorServiceConfigurationBuilder.getBoolean(configValueNode, context, DMRResourceConfigAttributes.RESOLVE_EXPRESSIONS);
                                boolean id = MonitorServiceConfigurationBuilder.getBoolean(configValueNode, context, DMRResourceConfigAttributes.INCLUDE_DEFAULTS);
                                ResourceConfigurationPropertyType configType = new ResourceConfigurationPropertyType(ID.NULL_ID, new Name(configName), new AttributeLocation((Object)new DMRNodeLocation(pathAddress, re, id), attributeString));
                                resourceTypeBuilder.resourceConfigurationPropertyType(configType);
                            }
                        }
                        MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(resourceTypeBuilder, typeSetsBuilder);
                        ResourceType resourceType = resourceTypeBuilder.build();
                        typeSetBuilder.type((NamedObject)resourceType);
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.resourceTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledResourceTypesConfigured("DMR");
        }
    }

    private static void determineResourceTypeSetJmx(ModelNode config, OperationContext context, TypeSets.Builder<JMXNodeLocation> typeSetsBuilder) throws OperationFailedException {
        boolean enabled = false;
        if (config.hasDefined("resource-type-set-jmx")) {
            List resourceTypeSetsList = config.get("resource-type-set-jmx").asPropertyList();
            for (Property resourceTypeSetProperty : resourceTypeSetsList) {
                String resourceTypeSetName = resourceTypeSetProperty.getName();
                ModelNode resourceTypeSetValueNode = resourceTypeSetProperty.getValue();
                TypeSet.TypeSetBuilder typeSetBuilder = TypeSet.builder().name(new Name(resourceTypeSetName)).enabled(MonitorServiceConfigurationBuilder.getBoolean(resourceTypeSetValueNode, context, JMXResourceTypeSetAttributes.ENABLED));
                if (resourceTypeSetName.indexOf(44) > -1) {
                    log.warnCommaInName(resourceTypeSetName);
                }
                if (resourceTypeSetValueNode.hasDefined("resource-type-jmx")) {
                    List resourceTypesList = resourceTypeSetValueNode.get("resource-type-jmx").asPropertyList();
                    for (Property resourceTypeProperty : resourceTypesList) {
                        ModelNode resourceTypeValueNode = resourceTypeProperty.getValue();
                        String resourceTypeName = resourceTypeProperty.getName();
                        String objectName = MonitorServiceConfigurationBuilder.getObjectName(resourceTypeValueNode, context, JMXResourceTypeAttributes.OBJECT_NAME);
                        try {
                            ModelNode configModelNode;
                            ResourceType.Builder resourceTypeBuilder = ((ResourceType.Builder)((ResourceType.Builder)((ResourceType.Builder)ResourceType.builder().id(ID.NULL_ID)).name(new Name(resourceTypeName))).location((Object)new JMXNodeLocation(objectName))).resourceNameTemplate(MonitorServiceConfigurationBuilder.getString(resourceTypeValueNode, context, JMXResourceTypeAttributes.RESOURCE_NAME_TEMPLATE)).parents(MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, JMXResourceTypeAttributes.PARENTS));
                            List<Name> metricSets = MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, JMXResourceTypeAttributes.METRIC_SETS);
                            List<Name> availSets = MonitorServiceConfigurationBuilder.getNameListFromString(resourceTypeValueNode, context, JMXResourceTypeAttributes.AVAIL_SETS);
                            resourceTypeBuilder.metricSetNames(metricSets).availSetNames(availSets);
                            ModelNode opModelNode = resourceTypeValueNode.get("operation-jmx");
                            if (opModelNode != null && opModelNode.isDefined()) {
                                List operationList = opModelNode.asPropertyList();
                                for (Property operationProperty : operationList) {
                                    ModelNode operationValueNode = operationProperty.getValue();
                                    String operationName = operationProperty.getName();
                                    Operation op = new Operation(ID.NULL_ID, new Name(operationName), (Object)new JMXNodeLocation(MonitorServiceConfigurationBuilder.getObjectName(operationValueNode, context, JMXOperationAttributes.OBJECT_NAME)), MonitorServiceConfigurationBuilder.getString(operationValueNode, context, JMXOperationAttributes.INTERNAL_NAME), MonitorServiceConfigurationBuilder.getBoolean(operationValueNode, context, JMXOperationAttributes.MODIFIES), null);
                                    resourceTypeBuilder.operation(op);
                                }
                            }
                            if ((configModelNode = resourceTypeValueNode.get("resource-config-jmx")) != null && configModelNode.isDefined()) {
                                List configList = configModelNode.asPropertyList();
                                for (Property configProperty : configList) {
                                    ModelNode configValueNode = configProperty.getValue();
                                    String configName = configProperty.getName();
                                    String on = MonitorServiceConfigurationBuilder.getObjectName(configValueNode, context, JMXResourceConfigAttributes.OBJECT_NAME);
                                    String attr = MonitorServiceConfigurationBuilder.getString(configValueNode, context, JMXResourceConfigAttributes.ATTRIBUTE);
                                    AttributeLocation attribLoc = new AttributeLocation((Object)new JMXNodeLocation(on), attr);
                                    ResourceConfigurationPropertyType configType = new ResourceConfigurationPropertyType(ID.NULL_ID, new Name(configName), attribLoc);
                                    resourceTypeBuilder.resourceConfigurationPropertyType(configType);
                                }
                            }
                            MonitorServiceConfigurationBuilder.populateMetricAndAvailTypesForResourceType(resourceTypeBuilder, typeSetsBuilder);
                            ResourceType resourceType = resourceTypeBuilder.build();
                            typeSetBuilder.type((NamedObject)resourceType);
                        }
                        catch (MalformedObjectNameException e) {
                            log.warnMalformedJMXObjectName(objectName, e);
                        }
                    }
                }
                TypeSet typeSet = typeSetBuilder.build();
                enabled = enabled || !typeSet.isDisabledOrEmpty();
                typeSetsBuilder.resourceTypeSet(typeSet);
            }
        }
        if (!enabled) {
            log.infoNoEnabledResourceTypesConfigured("JMX");
        }
    }

    private void determineManagedServers(ModelNode config, OperationContext context) throws OperationFailedException {
        if (config.hasDefined("managed-servers")) {
            Avail setAvailOnShutdown;
            String setAvailOnShutdownStr;
            String name;
            List asPropertyList = config.get("managed-servers").asPropertyList();
            if (asPropertyList.size() > 1) {
                throw new IllegalArgumentException("Can only have one <managed-resources>: " + config.toJSONString(true));
            }
            ModelNode managedServersValueNode = ((Property)asPropertyList.get(0)).getValue();
            if (managedServersValueNode.hasDefined("remote-dmr")) {
                List remoteDMRsList = managedServersValueNode.get("remote-dmr").asPropertyList();
                for (Property remoteDMRProperty : remoteDMRsList) {
                    name = remoteDMRProperty.getName();
                    ModelNode remoteDMRValueNode = remoteDMRProperty.getValue();
                    boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(remoteDMRValueNode, context, RemoteDMRAttributes.ENABLED);
                    setAvailOnShutdownStr = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.SET_AVAIL_ON_SHUTDOWN);
                    setAvailOnShutdown = setAvailOnShutdownStr == null ? null : Avail.valueOf((String)setAvailOnShutdownStr);
                    String protocol = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.PROTOCOL);
                    String host = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.HOST);
                    int port = MonitorServiceConfigurationBuilder.getInt(remoteDMRValueNode, context, RemoteDMRAttributes.PORT);
                    String username = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.USERNAME);
                    String password = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.PASSWORD);
                    boolean useSsl = MonitorServiceConfigurationBuilder.getBoolean(remoteDMRValueNode, context, RemoteDMRAttributes.USE_SSL);
                    String securityRealm = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.SECURITY_REALM);
                    List<Name> resourceTypeSets = MonitorServiceConfigurationBuilder.getNameListFromString(remoteDMRValueNode, context, RemoteDMRAttributes.RESOURCE_TYPE_SETS);
                    String tenantId = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.TENANT_ID);
                    String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(remoteDMRValueNode, context, RemoteDMRAttributes.METRIC_ID_TEMPLATE);
                    Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(remoteDMRValueNode, context, RemoteDMRAttributes.METRIC_TAGS);
                    if (useSsl && securityRealm == null) {
                        log.debugf("Using SSL with no security realm - will rely on the JVM truststore: " + name, new Object[0]);
                    }
                    if (protocol == null) {
                        protocol = useSsl ? "https-remoting" : "http-remoting";
                    }
                    ArrayList waitFor = new ArrayList();
                    if (remoteDMRValueNode.hasDefined("wait-for")) {
                        List waitForList = remoteDMRValueNode.get("wait-for").asPropertyList();
                        for (Property waitForProperty : waitForList) {
                            String resource = waitForProperty.getName();
                            try {
                                if (!"/".equals(resource)) {
                                    WildflyCompatibilityUtils.parseCLIStyleAddress((String)resource);
                                }
                            }
                            catch (Exception e) {
                                throw new OperationFailedException("Invalid wait-for name - not a valid DMR path: " + resource, (Throwable)e);
                            }
                            waitFor.add(new AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor(resource));
                        }
                    }
                    ConnectionData connectionData = new ConnectionData(protocol, host, port, username, password);
                    AgentCoreEngineConfiguration.EndpointConfiguration endpoint = new AgentCoreEngineConfiguration.EndpointConfiguration(name, enabled, resourceTypeSets, connectionData, securityRealm, setAvailOnShutdown, tenantId, metricIdTemplate, metricTags, null, (List)waitFor);
                    this.dmrConfigBuilder.endpoint(endpoint);
                }
            }
            if (managedServersValueNode.hasDefined("local-dmr")) {
                List localDMRsList = managedServersValueNode.get("local-dmr").asPropertyList();
                if (localDMRsList.size() > 1) {
                    throw new IllegalArgumentException("Can only have one <local-dmr>: " + config.toJSONString(true));
                }
                Property localDMRProperty = (Property)localDMRsList.get(0);
                String name2 = localDMRProperty.getName();
                ModelNode localDMRValueNode = localDMRProperty.getValue();
                boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(localDMRValueNode, context, LocalDMRAttributes.ENABLED);
                String setAvailOnShutdownStr2 = MonitorServiceConfigurationBuilder.getString(localDMRValueNode, context, LocalDMRAttributes.SET_AVAIL_ON_SHUTDOWN);
                Avail setAvailOnShutdown2 = setAvailOnShutdownStr2 == null ? null : Avail.valueOf((String)setAvailOnShutdownStr2);
                List<Name> resourceTypeSets = MonitorServiceConfigurationBuilder.getNameListFromString(localDMRValueNode, context, LocalDMRAttributes.RESOURCE_TYPE_SETS);
                String tenantId = MonitorServiceConfigurationBuilder.getString(localDMRValueNode, context, LocalDMRAttributes.TENANT_ID);
                String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(localDMRValueNode, context, LocalDMRAttributes.METRIC_ID_TEMPLATE);
                Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(localDMRValueNode, context, LocalDMRAttributes.METRIC_TAGS);
                ArrayList<AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor> waitFor = new ArrayList<AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor>();
                if (localDMRValueNode.hasDefined("wait-for")) {
                    List waitForList = localDMRValueNode.get("wait-for").asPropertyList();
                    for (Property waitForProperty : waitForList) {
                        String resource = waitForProperty.getName();
                        try {
                            if (!"/".equals(resource)) {
                                WildflyCompatibilityUtils.parseCLIStyleAddress((String)resource);
                            }
                        }
                        catch (Exception e) {
                            throw new OperationFailedException("Invalid wait-for name - not a valid DMR path: " + resource, (Throwable)e);
                        }
                        waitFor.add(new AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor(resource));
                    }
                }
                AgentCoreEngineConfiguration.EndpointConfiguration endpoint = new AgentCoreEngineConfiguration.EndpointConfiguration(name2, enabled, resourceTypeSets, null, null, setAvailOnShutdown2, tenantId, metricIdTemplate, metricTags, null, waitFor);
                this.dmrConfigBuilder.endpoint(endpoint);
            }
            if (managedServersValueNode.hasDefined("remote-jmx")) {
                List remoteJMXsList = managedServersValueNode.get("remote-jmx").asPropertyList();
                for (Property remoteJMXProperty : remoteJMXsList) {
                    URI url;
                    name = remoteJMXProperty.getName();
                    ModelNode remoteJMXValueNode = remoteJMXProperty.getValue();
                    boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(remoteJMXValueNode, context, RemoteJMXAttributes.ENABLED);
                    setAvailOnShutdownStr = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.SET_AVAIL_ON_SHUTDOWN);
                    setAvailOnShutdown = setAvailOnShutdownStr == null ? null : Avail.valueOf((String)setAvailOnShutdownStr);
                    String urlStr = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.URL);
                    String username = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.USERNAME);
                    String password = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.PASSWORD);
                    String securityRealm = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.SECURITY_REALM);
                    List<Name> resourceTypeSets = MonitorServiceConfigurationBuilder.getNameListFromString(remoteJMXValueNode, context, RemoteJMXAttributes.RESOURCE_TYPE_SETS);
                    String tenantId = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteJMXAttributes.TENANT_ID);
                    String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(remoteJMXValueNode, context, RemoteDMRAttributes.METRIC_ID_TEMPLATE);
                    Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(remoteJMXValueNode, context, RemoteDMRAttributes.METRIC_TAGS);
                    try {
                        url = new URI(urlStr);
                    }
                    catch (Exception e) {
                        throw new OperationFailedException("Invalid remote JMX URL: " + urlStr, (Throwable)e);
                    }
                    if (url.getScheme().equalsIgnoreCase("https") && securityRealm == null) {
                        log.debugf("Using SSL with no security realm - will rely on the JVM truststore: " + name, new Object[0]);
                    }
                    ArrayList<AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor> waitFor = new ArrayList<AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor>();
                    if (remoteJMXValueNode.hasDefined("wait-for")) {
                        List waitForList = remoteJMXValueNode.get("wait-for").asPropertyList();
                        for (Property waitForProperty : waitForList) {
                            String resource = waitForProperty.getName();
                            try {
                                new ObjectName(resource);
                            }
                            catch (Exception e) {
                                throw new OperationFailedException("Invalid wait-for name - not a valid JMX ObjectName: " + resource, (Throwable)e);
                            }
                            waitFor.add(new AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor(resource));
                        }
                    }
                    ConnectionData connectionData = new ConnectionData(url, username, password);
                    AgentCoreEngineConfiguration.EndpointConfiguration endpoint = new AgentCoreEngineConfiguration.EndpointConfiguration(name, enabled, resourceTypeSets, connectionData, securityRealm, setAvailOnShutdown, tenantId, metricIdTemplate, metricTags, null, waitFor);
                    this.jmxConfigBuilder.endpoint(endpoint);
                }
            }
            if (managedServersValueNode.hasDefined("local-jmx")) {
                List localJMXsList = managedServersValueNode.get("local-jmx").asPropertyList();
                for (Property localJMXProperty : localJMXsList) {
                    name = localJMXProperty.getName();
                    ModelNode localJMXValueNode = localJMXProperty.getValue();
                    boolean enabled = MonitorServiceConfigurationBuilder.getBoolean(localJMXValueNode, context, LocalJMXAttributes.ENABLED);
                    setAvailOnShutdownStr = MonitorServiceConfigurationBuilder.getString(localJMXValueNode, context, LocalJMXAttributes.SET_AVAIL_ON_SHUTDOWN);
                    setAvailOnShutdown = setAvailOnShutdownStr == null ? null : Avail.valueOf((String)setAvailOnShutdownStr);
                    String mbsNameStr = MonitorServiceConfigurationBuilder.getString(localJMXValueNode, context, LocalJMXAttributes.MBEAN_SERVER_NAME);
                    List<Name> resourceTypeSets = MonitorServiceConfigurationBuilder.getNameListFromString(localJMXValueNode, context, LocalJMXAttributes.RESOURCE_TYPE_SETS);
                    String tenantId = MonitorServiceConfigurationBuilder.getString(localJMXValueNode, context, LocalJMXAttributes.TENANT_ID);
                    String metricIdTemplate = MonitorServiceConfigurationBuilder.getString(localJMXValueNode, context, RemoteDMRAttributes.METRIC_ID_TEMPLATE);
                    Map<String, String> metricTags = MonitorServiceConfigurationBuilder.getMapFromString(localJMXValueNode, context, RemoteDMRAttributes.METRIC_TAGS);
                    ArrayList<AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor> waitFor = new ArrayList<AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor>();
                    if (localJMXValueNode.hasDefined("wait-for")) {
                        List waitForList = localJMXValueNode.get("wait-for").asPropertyList();
                        for (Property waitForProperty : waitForList) {
                            String resource = waitForProperty.getName();
                            try {
                                new ObjectName(resource);
                            }
                            catch (Exception e) {
                                throw new OperationFailedException("Invalid wait-for name - not a valid JMX ObjectName: " + resource, (Throwable)e);
                            }
                            waitFor.add(new AgentCoreEngineConfiguration.AbstractEndpointConfiguration.WaitFor(resource));
                        }
                    }
                    AgentCoreEngineConfiguration.EndpointConfiguration endpoint = new AgentCoreEngineConfiguration.EndpointConfiguration(name, enabled, resourceTypeSets, null, null, setAvailOnShutdown, tenantId, metricIdTemplate, metricTags, Collections.singletonMap("mbean-server-name", mbsNameStr), waitFor);
                    this.jmxConfigBuilder.endpoint(endpoint);
                }
            }
        }
    }

    private static boolean getBoolean(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        return value.isDefined() ? value.asBoolean() : false;
    }

    private static String getString(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        return value.isDefined() ? value.asString() : null;
    }

    private static PathAddress getPath(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        String path = MonitorServiceConfigurationBuilder.getString(modelNode, context, attrib);
        if (path == null) {
            return null;
        }
        if ("/".equals(path)) {
            return PathAddress.EMPTY_ADDRESS;
        }
        return WildflyCompatibilityUtils.parseCLIStyleAddress((String)path);
    }

    private static int getInt(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        return value.isDefined() ? value.asInt() : 0;
    }

    private static String getObjectName(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        String value = MonitorServiceConfigurationBuilder.getString(modelNode, context, attrib);
        if (value != null && !value.isEmpty()) {
            try {
                new ObjectName(value);
            }
            catch (MalformedObjectNameException e) {
                throw new OperationFailedException(String.format("Attribute [%s] is an invalid object name [%s]", attrib.getName(), value), (Throwable)e);
            }
        }
        return value;
    }

    private static List<Name> getNameListFromString(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        if (value.isDefined()) {
            String commaSeparatedList = value.asString();
            String[] stringArray = commaSeparatedList.split(",");
            ArrayList<Name> names = new ArrayList<Name>(stringArray.length);
            for (String str : stringArray) {
                names.add(new Name(str));
            }
            return names;
        }
        return Collections.emptyList();
    }

    private static List<OperationParam> getOpParamListFromOpNode(ModelNode modelNode, OperationContext context) throws OperationFailedException {
        ArrayList<OperationParam> ret = new ArrayList<OperationParam>();
        ModelNode params = modelNode.get("param");
        if (params == null || !params.isDefined()) {
            return Collections.emptyList();
        }
        List propList = params.asPropertyList();
        for (Property prop : propList) {
            String paramName = prop.getName();
            ModelNode paramModelNode = prop.getValue();
            String paramType = MonitorServiceConfigurationBuilder.getString(paramModelNode, context, DMROperationParamAttributes.TYPE);
            String paramDesc = MonitorServiceConfigurationBuilder.getString(paramModelNode, context, DMROperationParamAttributes.DESCRIPTION);
            String paramDefaultValue = MonitorServiceConfigurationBuilder.getString(paramModelNode, context, DMROperationParamAttributes.DEFAULT_VALUE);
            Boolean paramRequired = MonitorServiceConfigurationBuilder.getBoolean(paramModelNode, context, DMROperationParamAttributes.REQUIRED);
            OperationParam operationParam = new OperationParam(paramName, paramType, paramDesc, paramDefaultValue, paramRequired);
            ret.add(operationParam);
        }
        return ret;
    }

    private static Map<String, String> getMapFromString(ModelNode modelNode, OperationContext context, SimpleAttributeDefinition attrib) throws OperationFailedException {
        ModelNode value = attrib.resolveModelAttribute(context, modelNode);
        if (value.isDefined()) {
            HashMap<String, String> map = new HashMap<String, String>();
            String commaSeparatedList = value.asString();
            StringTokenizer strtok = new StringTokenizer(commaSeparatedList, ",");
            while (strtok.hasMoreTokens()) {
                String nameValueToken = strtok.nextToken().trim();
                String[] nameValueArr = nameValueToken.split("=");
                if (nameValueArr.length != 2) {
                    throw new OperationFailedException("missing '=' in name-value pair: " + commaSeparatedList);
                }
                map.put(nameValueArr[0].trim(), nameValueArr[1].trim());
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private static <L> void populateMetricAndAvailTypesForResourceType(ResourceType.Builder<?, L> resourceTypeBuilder, TypeSets.Builder<L> typeSetsBuilder) {
        Map metricTypeSets = typeSetsBuilder.getMetricTypeSets();
        List metricSetNames = resourceTypeBuilder.getMetricSetNames();
        for (Name metricSetName : metricSetNames) {
            TypeSet metricSet = (TypeSet)metricTypeSets.get(metricSetName);
            if (metricSet == null || !metricSet.isEnabled()) continue;
            resourceTypeBuilder.metricTypes(metricSet.getTypeMap().values());
        }
        Map availTypeSets = typeSetsBuilder.getAvailTypeSets();
        List availSetNames = resourceTypeBuilder.getAvailSetNames();
        for (Name availSetName : availSetNames) {
            TypeSet availSet = (TypeSet)availTypeSets.get(availSetName);
            if (availSet == null || !availSet.isEnabled()) continue;
            resourceTypeBuilder.availTypes(availSet.getTypeMap().values());
        }
    }
}

