/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.wildfly.cmd;

import java.util.HashMap;
import java.util.Map;
import org.hawkular.agent.monitor.cmd.AbstractDMRResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.ResourcePathResponse;
import org.hawkular.cmdgw.api.UpdateCollectionIntervalsRequest;
import org.hawkular.cmdgw.api.UpdateCollectionIntervalsResponse;
import org.hawkular.dmr.api.DmrApiException;
import org.hawkular.dmr.api.OperationBuilder;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;

public class UpdateCollectionIntervalsCommand
extends AbstractDMRResourcePathCommand<UpdateCollectionIntervalsRequest, UpdateCollectionIntervalsResponse> {
    private static final MsgLogger log = AgentLoggers.getLogger(UpdateCollectionIntervalsCommand.class);
    public static final Class<UpdateCollectionIntervalsRequest> REQUEST_CLASS = UpdateCollectionIntervalsRequest.class;

    public UpdateCollectionIntervalsCommand() {
        super("Update Collection Intervals", "Agent[DMR]");
    }

    protected UpdateCollectionIntervalsResponse createResponse() {
        return new UpdateCollectionIntervalsResponse();
    }

    protected BinaryData execute(ModelControllerClient mcc, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<UpdateCollectionIntervalsRequest> envelope, UpdateCollectionIntervalsResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        PathAddress agentAddress = WildflyCompatibilityUtils.parseCLIStyleAddress((String)modelNodePath);
        UpdateCollectionIntervalsRequest request = (UpdateCollectionIntervalsRequest)envelope.getBasicMessage();
        Map<PathAddress, String> metricTypes = this.filterUpdates(mcc, request.getMetricTypes(), false, agentAddress);
        Map<PathAddress, String> availTypes = this.filterUpdates(mcc, request.getAvailTypes(), true, agentAddress);
        if (this.isEmpty(metricTypes) && this.isEmpty(availTypes)) {
            log.debug((Object)"Skipping collection interval update, no valid type updates provided.");
            return null;
        }
        OperationBuilder.CompositeOperationBuilder composite = OperationBuilder.composite();
        this.addUpdates(composite, metricTypes);
        this.addUpdates(composite, availTypes);
        composite.allowResourceServiceRestart(false);
        ((OperationBuilder.ByNameOperationBuilder)composite.byNameOperation("start").address(agentAddress)).attribute("refresh", "true").attribute("delay", "500").parentBuilder();
        try {
            OperationBuilder.OperationResult opResult = composite.execute(mcc).assertSuccess();
            this.setServerRefreshIndicator(opResult, (ResourcePathResponse)response);
        }
        catch (DmrApiException e) {
            log.errorf("Failed to update collection intervals: %s", (Object)e.getMessage());
            throw e;
        }
        return null;
    }

    private Map<PathAddress, String> filterUpdates(ModelControllerClient mcc, Map<String, String> updates, boolean isAvail, PathAddress agentAddress) {
        if (this.isEmpty(updates)) {
            return null;
        }
        String agentPath = agentAddress.toCLIStyleString();
        HashMap<PathAddress, String> result = new HashMap<PathAddress, String>();
        for (Map.Entry<String, String> entry : updates.entrySet()) {
            String typeId = entry.getKey();
            String interval = entry.getValue();
            PathAddress metricType = null;
            try {
                String path = isAvail ? this.toAvailPath(typeId, agentPath) : this.toMetricPath(typeId, agentPath);
                metricType = WildflyCompatibilityUtils.parseCLIStyleAddress((String)path);
            }
            catch (Exception e1) {
                log.warnf("Unable to update interval for invalid type [%s]", (Object)typeId);
                continue;
            }
            try {
                Integer.valueOf(interval);
            }
            catch (Exception e) {
                log.warnf("Unable to update interval for type [%s], invalid interval [%s]", (Object)typeId, (Object)interval);
                continue;
            }
            if (!this.isValidAddress(mcc, metricType)) {
                log.warnf("Skipping collection interval update on invalid metric type [%s]", (Object)typeId);
                continue;
            }
            result.put(metricType, interval);
        }
        return result;
    }

    private boolean isValidAddress(ModelControllerClient mcc, PathAddress address) {
        try {
            ((OperationBuilder.ReadAttributeOperationBuilder)OperationBuilder.readAttribute().address(address)).name("interval").includeDefaults().execute(mcc).assertSuccess();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void addUpdates(OperationBuilder.CompositeOperationBuilder<?> composite, Map<PathAddress, String> updates) {
        if (!this.isEmpty(updates)) {
            for (Map.Entry<PathAddress, String> entry : updates.entrySet()) {
                PathAddress metricType = entry.getKey();
                String interval = entry.getValue();
                ((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)composite.writeAttribute().address(metricType)).attribute("interval", interval).allowResourceServiceRestart(false)).parentBuilder();
                ((OperationBuilder.WriteAttributeOperationBuilder)((OperationBuilder.WriteAttributeOperationBuilder)composite.writeAttribute().address(metricType)).attribute("time-units", "seconds").allowResourceServiceRestart(false)).parentBuilder();
            }
        }
    }

    private String toMetricPath(String metricTypeId, String agentPath) {
        String[] a = metricTypeId.split("~");
        if (a.length != 2) {
            throw new IllegalArgumentException("MetricTypeId must be of form MetricTypeSet~MetricTypeName");
        }
        return agentPath + (agentPath.endsWith("/") ? "" : "/") + "metric-set-dmr=" + a[0] + "/metric-dmr=" + a[1];
    }

    private String toAvailPath(String availTypeId, String agentPath) {
        String[] a = availTypeId.split("~");
        if (a.length != 2) {
            throw new IllegalArgumentException("AvailTypeId must be of form AvailTypeSet~AvailTypeName");
        }
        return agentPath + (agentPath.endsWith("/") ? "" : "/") + "avail-set-dmr=" + a[0] + "/avail-dmr=" + a[1];
    }

    private boolean isEmpty(Map<?, ?> c) {
        return null == c || c.isEmpty();
    }

    protected void validate(BasicMessageWithExtraData<UpdateCollectionIntervalsRequest> envelope, MonitoredEndpoint<? extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> endpoint) {
    }

    protected void validate(String modelNodePath, BasicMessageWithExtraData<UpdateCollectionIntervalsRequest> envelope) {
    }
}

