/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.wildfly.agent.installer;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hawkular.wildfly.agent.installer.DomainTargetConfigInfo;
import org.hawkular.wildfly.agent.installer.HostTargetConfigInfo;
import org.hawkular.wildfly.agent.installer.InstallerConfiguration;
import org.hawkular.wildfly.agent.installer.StandaloneTargetConfigInfo;
import org.hawkular.wildfly.agent.installer.TargetConfigInfo;
import org.hawkular.wildfly.module.installer.DeploymentConfiguration;
import org.hawkular.wildfly.module.installer.ExtensionDeployer;
import org.hawkular.wildfly.module.installer.XmlEdit;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserBuilder;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.console.command.Command;
import org.jboss.logging.Logger;

public class AgentInstaller {
    private static final Logger log = Logger.getLogger(AgentInstaller.class);
    private static final String SECURITY_REALM_NAME = "HawkularRealm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ProcessedCommand<?> options = null;
        ArrayList<File> filesToDelete = new ArrayList<File>();
        try {
            boolean useOutboundSocketBinding;
            TargetConfigInfo targetConfigInfo;
            String targetConfig;
            File moduleTempFile;
            URL moduleZipUrl;
            String hawkularServerPort;
            String hawkularServerHost;
            String hawkularServerProtocol;
            String jbossHome;
            options = InstallerConfiguration.buildCommandLineOptions();
            CommandLineParser parser = new CommandLineParserBuilder().processedCommand(options).create();
            StringBuilder argLine = new StringBuilder("hawkular-wildfly-agent-installer");
            for (String str : args) {
                argLine.append(' ').append(str);
            }
            CommandLine<Command> commandLine = parser.parse(argLine.toString());
            InstallerConfiguration installerConfig = new InstallerConfiguration(commandLine);
            boolean passwordsEncrypted = commandLine.hasOption("encryption-key");
            if (passwordsEncrypted) {
                boolean saltSpecified;
                String key = commandLine.getOptionValue("encryption-key", null);
                String saltAsString = commandLine.getOptionValue("encryption-salt", null);
                if (key == null || key.isEmpty()) {
                    key = AgentInstaller.readPasswordFromStdin("Encryption key:");
                }
                if (!(saltSpecified = commandLine.hasOption("encryption-salt"))) {
                    saltAsString = key;
                }
                if (saltAsString == null || saltAsString.isEmpty()) {
                    saltAsString = AgentInstaller.readPasswordFromStdin("Salt:");
                }
                assert (saltAsString != null);
                assert (key != null);
                byte[] salt = saltAsString.getBytes("UTF-8");
                installerConfig.decodeProperties(key, salt);
            }
            if ((jbossHome = installerConfig.getTargetLocation()) == null) {
                File jbossHomeFile = new File(".").getCanonicalFile();
                if (!(jbossHomeFile.exists() && jbossHomeFile.isDirectory() && jbossHomeFile.canRead() && new File(jbossHomeFile, "modules").isDirectory())) {
                    throw new Exception("target-location must be specified");
                }
                jbossHome = jbossHomeFile.getCanonicalPath();
            }
            if (installerConfig.getUsername() == null || installerConfig.getPassword() == null) {
                throw new Exception("You must provide credentials (username/password) in installer configuration");
            }
            if (installerConfig.getServerUrl() == null) {
                throw new Exception("You must provide the Hawkular Server URL");
            }
            try {
                URL hawkularServerUrl = new URL(installerConfig.getServerUrl());
                hawkularServerProtocol = hawkularServerUrl.getProtocol();
                hawkularServerHost = hawkularServerUrl.getHost();
                hawkularServerPort = String.valueOf(hawkularServerUrl.getPort());
                if ("-1".equals(hawkularServerPort)) {
                    hawkularServerPort = "80";
                }
            }
            catch (MalformedURLException mue) {
                Matcher m = Pattern.compile("(https?|\\$\\{.+\\})://(.+):(\\d+|\\$\\{.+\\})").matcher(installerConfig.getServerUrl());
                if (m.matches() && m.groupCount() == 3) {
                    hawkularServerProtocol = m.group(1);
                    hawkularServerHost = m.group(2);
                    hawkularServerPort = m.group(3);
                }
                throw new Exception("Server URL cannot be parsed.", mue);
            }
            String moduleZip = installerConfig.getModuleDistribution();
            if (installerConfig.isConfigOnly()) {
                moduleZipUrl = null;
            } else if (moduleZip == null) {
                moduleTempFile = AgentInstaller.downloadModuleZip(AgentInstaller.getHawkularServerAgentDownloadUrl(installerConfig), jbossHome);
                if (moduleTempFile == null) {
                    throw new IOException("Failed to retrieve module dist from server, You can use option [module-dist] to supply your own");
                }
                filesToDelete.add(moduleTempFile);
                moduleZipUrl = moduleTempFile.toURI().toURL();
            } else if (moduleZip.startsWith("classpath:")) {
                String resourceUrl = moduleZip.substring(10);
                if (!resourceUrl.startsWith("/")) {
                    resourceUrl = "/" + resourceUrl;
                }
                if (resourceUrl.equals("/")) {
                    resourceUrl = AgentInstaller.isEAP6(jbossHome) ? "/hawkular-wildfly-agent-wf-extension-eap6.zip" : "/hawkular-wildfly-agent-wf-extension.zip";
                }
                if ((moduleZipUrl = AgentInstaller.class.getResource(resourceUrl)) == null) {
                    throw new IOException("Unable to load module.zip from classpath [" + resourceUrl + "]");
                }
            } else if (moduleZip.matches("(http|https|file):.*")) {
                moduleTempFile = AgentInstaller.downloadModuleZip(new URL(moduleZip), jbossHome);
                if (moduleTempFile == null) {
                    throw new IOException("Failed to retrieve agent module from server, option [module-dist] is now required but it was not supplied");
                }
                filesToDelete.add(moduleTempFile);
                moduleZipUrl = moduleTempFile.toURI().toURL();
            } else {
                moduleZipUrl = new File(moduleZip).toURI().toURL();
            }
            File socketBindingSnippetFile = AgentInstaller.createSocketBindingSnippet(hawkularServerHost, hawkularServerPort);
            filesToDelete.add(socketBindingSnippetFile);
            DeploymentConfiguration.Builder configurationBldr = DeploymentConfiguration.builder().jbossHome(new File(jbossHome)).module(moduleZipUrl).defaultModuleId("org.hawkular.agent").defaultModuleRelativePath("/system/add-ons/hawkular-agent/").socketBinding(socketBindingSnippetFile.toURI().toURL());
            if (installerConfig.getSubsystemSnippet() != null) {
                try {
                    configurationBldr.subsystem(new URL(installerConfig.getSubsystemSnippet()));
                }
                catch (MalformedURLException mue) {
                    File file = new File(installerConfig.getSubsystemSnippet());
                    if (file.exists()) {
                        configurationBldr.subsystem(file.getAbsoluteFile().toURI().toURL());
                    }
                    throw new FileNotFoundException("Subsystem snippet not found at [" + installerConfig.getSubsystemSnippet() + "]");
                }
            }
            if ((targetConfig = installerConfig.getTargetConfig()) != null) {
                configurationBldr.serverConfig(targetConfig);
            } else {
                targetConfig = DeploymentConfiguration.DEFAULT_SERVER_CONFIG;
            }
            if (targetConfig.matches(".*standalone[^/]*.xml")) {
                targetConfigInfo = new StandaloneTargetConfigInfo();
            } else if (targetConfig.matches(".*host[^/]*.xml")) {
                targetConfigInfo = new HostTargetConfigInfo();
            } else if (targetConfig.matches(".*domain[^/]*.xml")) {
                targetConfigInfo = new DomainTargetConfigInfo();
            } else {
                log.warnf("Don't know the kind of config this is, will assume standalone: [%s]", (Object)targetConfig);
                targetConfigInfo = new StandaloneTargetConfigInfo();
            }
            String keystorePath = installerConfig.getKeystorePath();
            String keystorePass = installerConfig.getKeystorePassword();
            if (hawkularServerProtocol.equals("https") && keystorePath == null) {
                throw new Exception(String.format("When using https protocol, the following keystore command line option is required: %s", "keystore-path"));
            }
            if (keystorePath != null) {
                File keystoreSrcFile;
                if (keystorePass == null && ((keystorePass = AgentInstaller.readPasswordFromStdin("Keystore password:")) == null || keystorePass.isEmpty())) {
                    keystorePass = "";
                    log.warn("keystore-password was not provided; using empty password");
                }
                if (!(keystoreSrcFile = new File(keystorePath)).isFile() || !keystoreSrcFile.canRead()) {
                    throw new FileNotFoundException("Cannot read " + keystoreSrcFile.getAbsolutePath());
                }
                File targetConfigDir = new File(targetConfig).isAbsolute() ? new File(targetConfig).getParentFile() : new File(jbossHome, targetConfig).getParentFile();
                Path keystoreDst = Paths.get(targetConfigDir.getAbsolutePath(), new String[0]).resolve(keystoreSrcFile.getName());
                if (!keystoreDst.toFile().exists()) {
                    log.info("Copy [" + keystoreSrcFile.getAbsolutePath() + "] to [" + keystoreDst.toString() + "]");
                    Files.copy(Paths.get(keystoreSrcFile.getAbsolutePath(), new String[0]), keystoreDst, new CopyOption[0]);
                }
                String securityRealm = AgentInstaller.createSecurityRealm(keystoreSrcFile.getName(), keystorePass);
                configurationBldr.addXmlEdit(new XmlEdit(targetConfigInfo.getSecurityRealmsXPath(), securityRealm));
            }
            configurationBldr.addXmlEdit(AgentInstaller.createStorageAdapter(targetConfigInfo, keystorePath != null, installerConfig));
            configurationBldr.addXmlEdit(AgentInstaller.createManagedServers(targetConfigInfo, installerConfig));
            configurationBldr.addXmlEdit(AgentInstaller.setEnableFlag(targetConfigInfo, installerConfig));
            configurationBldr.modulesHome("modules");
            boolean bl = useOutboundSocketBinding = hawkularServerProtocol.startsWith("http") && targetConfigInfo instanceof StandaloneTargetConfigInfo;
            if (!useOutboundSocketBinding) {
                configurationBldr.socketBinding(null);
            }
            new ExtensionDeployer().install(configurationBldr.build());
        }
        catch (CommandLineParserException pe) {
            log.error(pe);
            AgentInstaller.printHelp(options);
            if (Boolean.getBoolean("org.hawkular.wildfly.agent.installer.throw-exception-on-error")) {
                throw pe;
            }
        }
        catch (Exception ex) {
            log.error(ex);
            if (Boolean.getBoolean("org.hawkular.wildfly.agent.installer.throw-exception-on-error")) {
                throw ex;
            }
        }
        finally {
            for (File fileToDelete : filesToDelete) {
                if (fileToDelete.delete()) continue;
                log.warn("Failed to delete temporary file: " + fileToDelete);
            }
        }
    }

    private static String readPasswordFromStdin(String message) {
        Console console = System.console();
        if (console == null) {
            return null;
        }
        console.writer().write(message);
        console.writer().flush();
        return String.valueOf(console.readPassword());
    }

    private static String createSecurityRealm(String keystoreFile, String keystorePass) {
        return "<security-realm name=\"HawkularRealm\">" + "<authentication>" + ("<truststore path=\"" + keystoreFile + "\"") + " relative-to=\"jboss.server.config.dir\"" + (" keystore-password=\"" + keystorePass + "\"") + " /></authentication></security-realm>";
    }

    private static XmlEdit createStorageAdapter(TargetConfigInfo targetConfigInfo, boolean withHttps, InstallerConfiguration installerConfig) {
        String serverUrl;
        boolean useOutboundSocketBinding;
        String select = targetConfigInfo.getProfileXPath() + "/*[namespace-uri()='urn:org.hawkular.agent:agent:1.0']/";
        StringBuilder xml = new StringBuilder("<storage-adapter");
        String tenantId = installerConfig.getTenantId();
        if (installerConfig.isMetricsOnlyMode()) {
            xml.append(" type=\"METRICS\"");
            if (tenantId == null || tenantId.isEmpty()) {
                throw new IllegalArgumentException("You must specify tenant-id when in metrics-only mode");
            }
        } else {
            xml.append(" type=\"HAWKULAR\"");
        }
        if (tenantId != null && !tenantId.isEmpty()) {
            xml.append(" tenant-id=\"" + tenantId + "\"");
        }
        if (withHttps) {
            xml.append(" security-realm=\"HawkularRealm\"").append(" use-ssl=\"true\"");
        }
        if (installerConfig.getFeedId() != null && !installerConfig.getFeedId().isEmpty()) {
            xml.append(" feed-id=\"" + installerConfig.getFeedId() + "\"");
        }
        if (installerConfig.getUsername() != null && !installerConfig.getUsername().isEmpty()) {
            xml.append(" username=\"" + installerConfig.getUsername() + "\"");
        }
        if (installerConfig.getPassword() != null && !installerConfig.getPassword().isEmpty()) {
            xml.append(" password=\"" + installerConfig.getPassword() + "\"");
        }
        boolean bl = useOutboundSocketBinding = (serverUrl = installerConfig.getServerUrl()).startsWith("http") && targetConfigInfo instanceof StandaloneTargetConfigInfo;
        if (useOutboundSocketBinding) {
            xml.append(" server-outbound-socket-binding-ref=\"hawkular\"");
        } else {
            xml.append(" url=\"").append(serverUrl).append("\"");
        }
        xml.append("/>");
        return new XmlEdit(select, xml.toString()).withAttribute("type").withIsIgnoreAttributeValue(true);
    }

    private static File createSocketBindingSnippet(String host, String port) throws IOException {
        StringBuilder xml = new StringBuilder("<outbound-socket-binding name=\"hawkular\">\n").append("  <remote-destination host=\"" + host + "\" port=\"" + port + "\" />\n").append("</outbound-socket-binding>");
        Path tempFile = Files.createTempFile("hawkular-wildfly-module-installer-outbound-socket-binding", ".xml", new FileAttribute[0]);
        Files.write(tempFile, xml.toString().getBytes(), new OpenOption[0]);
        return tempFile.toFile();
    }

    private static XmlEdit createManagedServers(TargetConfigInfo targetConfigInfo, InstallerConfiguration config) {
        String managedServerResourceTypeSets;
        String select = targetConfigInfo.getProfileXPath() + "/*[namespace-uri()='urn:org.hawkular.agent:agent:1.0']/";
        String managedServerName = config.getManagedServerName();
        if (managedServerName == null || managedServerName.trim().isEmpty()) {
            managedServerName = "Local";
        }
        if ((managedServerResourceTypeSets = config.getManagedResourceTypeSets()) == null || managedServerResourceTypeSets.trim().isEmpty()) {
            managedServerResourceTypeSets = targetConfigInfo.getManagedServerResourceTypeSets();
        }
        StringBuilder xml = new StringBuilder("<managed-servers>").append("<local-dmr name=\"" + managedServerName + "\" enabled=\"true\" resource-type-sets=\"" + managedServerResourceTypeSets + "\">").append("<wait-for name=\"/\" />").append("</local-dmr>").append("</managed-servers>");
        return new XmlEdit(select, xml.toString());
    }

    private static XmlEdit setEnableFlag(TargetConfigInfo targetConfigInfo, InstallerConfiguration config) {
        String select = targetConfigInfo.getProfileXPath() + "/*[namespace-uri()='urn:org.hawkular.agent:agent:1.0'][@enabled]";
        String isEnabled = String.valueOf(config.isEnabled());
        return new XmlEdit(select, isEnabled).withIsAttributeContent(true).withAttribute("enabled");
    }

    private static URL getHawkularServerAgentDownloadUrl(InstallerConfiguration config) throws Exception {
        try {
            String serverUrl = String.format("%s/hawkular/wildfly-agent/download", config.getDownloadServerUrl());
            return new URL(serverUrl);
        }
        catch (MalformedURLException e) {
            throw new Exception("Invalid download URL. Use --download-server-url to specify where the installer can download the module distribution. Or provide a module distribution to the installer via --module-dist", e);
        }
    }

    /*
     * Exception decompiling
     */
    private static File downloadModuleZip(URL url, String jbossHome) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void printHelp(ProcessedCommand<?> options) {
        if (options == null) {
            throw new RuntimeException("Cannot print help - options is null");
        }
        System.out.println(options.printHelp());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEAP6(String jbossHome) {
        try {
            File manifestFile = new File(jbossHome, "modules/system/layers/base/org/jboss/as/product/eap/dir/META-INF/MANIFEST.MF");
            if (!manifestFile.canRead()) {
                log.debugf("No readable manifest file at [%s], assuming the app server is not EAP 6.x.", (Object)manifestFile.getAbsolutePath());
                return false;
            }
            try (FileInputStream ios = new FileInputStream(manifestFile);){
                Manifest manifest = new Manifest(ios);
                String version = manifest.getMainAttributes().getValue("JBoss-Product-Release-Version");
                boolean bl = version != null && version.startsWith("6.");
                return bl;
            }
        }
        catch (Exception e) {
            log.debug("Unable to determine if the app server is EAP 6.x - assuming it is not. Cause: " + e);
            return false;
        }
    }
}

