/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.command.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.container.AeshCommandContainerBuilder;
import org.jboss.aesh.console.command.container.CommandContainer;

public class AeshInternalCommandRegistry {
    private final Map<String, CommandContainer> registry = new HashMap<String, CommandContainer>();

    public void addCommand(Command command) {
        this.putIntoRegistry(new AeshCommandContainerBuilder().create(command));
    }

    private void putIntoRegistry(CommandContainer commandContainer) {
        if (!commandContainer.haveBuildError() && !this.registry.containsKey(commandContainer.getParser().getProcessedCommand().getName())) {
            this.registry.put(commandContainer.getParser().getProcessedCommand().getName(), commandContainer);
        }
    }

    public CommandContainer getCommand(String name) {
        return this.registry.get(name);
    }

    public Set<String> getAllCommandNames() {
        return this.registry.keySet();
    }
}

