/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.solr;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Geo;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransaction;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfigurable;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.TemporaryBackendException;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.indexing.IndexEntry;
import com.thinkaurelius.titan.diskstorage.indexing.IndexFeatures;
import com.thinkaurelius.titan.diskstorage.indexing.IndexMutation;
import com.thinkaurelius.titan.diskstorage.indexing.IndexProvider;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.KeyInformation;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.diskstorage.solr.transform.GeoToWktConverter;
import com.thinkaurelius.titan.diskstorage.util.DefaultTransaction;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.AbstractDecimal;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.Not;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.types.ParameterType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class SolrIndex
implements IndexProvider {
    private static final Logger logger = LoggerFactory.getLogger(SolrIndex.class);
    private static final String COLLECTION_PARAM = "collection";
    private static final String DEFAULT_ID_FIELD = "document_id";
    public static final ConfigNamespace SOLR_NS = new ConfigNamespace(GraphDatabaseConfiguration.INDEX_NS, "solr", "Solr index configuration");
    public static final ConfigOption<String> SOLR_MODE = new ConfigOption(SOLR_NS, "mode", "The operation mode for Solr which is either via HTTP (`http`) or using SolrCloud (`cloud`)", ConfigOption.Type.GLOBAL_OFFLINE, (Object)"cloud");
    public static final ConfigOption<Boolean> DYNAMIC_FIELDS = new ConfigOption(SOLR_NS, "dyn-fields", "Whether to use dynamic fields (which appends the data type to the field name). If dynamic fields is disabledthe user must map field names and define them explicitly in the schema.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)true);
    public static final ConfigOption<String[]> KEY_FIELD_NAMES = new ConfigOption(SOLR_NS, "key-field-names", "Field name that uniquely identifies each document in Solr. Must be specified as a list of `collection=field`.", ConfigOption.Type.GLOBAL, String[].class);
    public static final ConfigOption<String> TTL_FIELD = new ConfigOption(SOLR_NS, "ttl_field", "Name of the TTL field for Solr collections.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)"ttl");
    public static final ConfigOption<String> ZOOKEEPER_URL = new ConfigOption(SOLR_NS, "zookeeper-url", "URL of the Zookeeper instance coordinating the SolrCloud cluster", ConfigOption.Type.MASKABLE, (Object)"localhost:2181");
    public static final ConfigOption<Integer> NUM_SHARDS = new ConfigOption(SOLR_NS, "num-shards", "Number of shards for a collection. This applies when creating a new collection which is only supported under the SolrCloud operation mode.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)1);
    public static final ConfigOption<Integer> MAX_SHARDS_PER_NODE = new ConfigOption(SOLR_NS, "max-shards-per-node", "Maximum number of shards per node. This applies when creating a new collection which is only supported under the SolrCloud operation mode.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)1);
    public static final ConfigOption<Integer> REPLICATION_FACTOR = new ConfigOption(SOLR_NS, "replication-factor", "Replication factor for a collection. This applies when creating a new collection which is only supported under the SolrCloud operation mode.", ConfigOption.Type.GLOBAL_OFFLINE, (Object)1);
    public static final ConfigOption<String[]> HTTP_URLS = new ConfigOption(SOLR_NS, "http-urls", "List of URLs to use to connect to Solr Servers (LBSolrServer is used), don't add core or collection name to the URL.", ConfigOption.Type.MASKABLE, (Object)new String[]{"http://localhost:8983/solr"});
    public static final ConfigOption<Integer> HTTP_CONNECTION_TIMEOUT = new ConfigOption(SOLR_NS, "http-connection-timeout", "Solr HTTP connection timeout.", ConfigOption.Type.MASKABLE, (Object)5000);
    public static final ConfigOption<Boolean> HTTP_ALLOW_COMPRESSION = new ConfigOption(SOLR_NS, "http-compression", "Enable/disable compression on the HTTP connections made to Solr.", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<Integer> HTTP_MAX_CONNECTIONS_PER_HOST = new ConfigOption(SOLR_NS, "http-max-per-host", "Maximum number of HTTP connections per Solr host.", ConfigOption.Type.MASKABLE, (Object)20);
    public static final ConfigOption<Integer> HTTP_GLOBAL_MAX_CONNECTIONS = new ConfigOption(SOLR_NS, "http-max", "Maximum number of HTTP connections in total to all Solr servers.", ConfigOption.Type.MASKABLE, (Object)100);
    private static final IndexFeatures SOLR_FEATURES = new IndexFeatures.Builder().supportsDocumentTTL().setDefaultStringMapping(Mapping.TEXT).supportedStringMappings(new Mapping[]{Mapping.TEXT, Mapping.STRING}).build();
    private final SolrServer solrServer;
    private final Configuration configuration;
    private final Mode mode;
    private final boolean dynFields;
    private final Map<String, String> keyFieldIds;
    private final String ttlField;
    private final int maxResults;

    public SolrIndex(final Configuration config) throws BackendException {
        block4: {
            Preconditions.checkArgument((config != null ? 1 : 0) != 0);
            this.configuration = config;
            this.mode = Mode.parse((String)config.get(SOLR_MODE, new String[0]));
            this.dynFields = (Boolean)config.get(DYNAMIC_FIELDS, new String[0]);
            this.keyFieldIds = this.parseKeyFieldsForCollections(config);
            this.maxResults = (Integer)config.get(GraphDatabaseConfiguration.INDEX_MAX_RESULT_SET_SIZE, new String[0]);
            this.ttlField = (String)config.get(TTL_FIELD, new String[0]);
            try {
                if (this.mode == Mode.CLOUD) {
                    String zookeeperUrl = (String)config.get(ZOOKEEPER_URL, new String[0]);
                    CloudSolrServer cloudServer = new CloudSolrServer(zookeeperUrl, true);
                    cloudServer.connect();
                    this.solrServer = cloudServer;
                    break block4;
                }
                if (this.mode == Mode.HTTP) {
                    HttpClient clientParams = HttpClientUtil.createClient((SolrParams)new ModifiableSolrParams(){
                        {
                            this.add("allowCompression", new String[]{((Boolean)config.get(HTTP_ALLOW_COMPRESSION, new String[0])).toString()});
                            this.add("connTimeout", new String[]{((Integer)config.get(HTTP_CONNECTION_TIMEOUT, new String[0])).toString()});
                            this.add("maxConnectionsPerHost", new String[]{((Integer)config.get(HTTP_MAX_CONNECTIONS_PER_HOST, new String[0])).toString()});
                            this.add("maxConnections", new String[]{((Integer)config.get(HTTP_GLOBAL_MAX_CONNECTIONS, new String[0])).toString()});
                        }
                    });
                    this.solrServer = new LBHttpSolrServer(clientParams, (String[])config.get(HTTP_URLS, new String[0]));
                    break block4;
                }
                throw new IllegalArgumentException("Unsupported Solr operation mode: " + (Object)((Object)this.mode));
            }
            catch (IOException e) {
                throw new PermanentBackendException((Throwable)e);
            }
        }
    }

    private Map<String, String> parseKeyFieldsForCollections(Configuration config) throws BackendException {
        String[] collectionFieldStatements;
        HashMap<String, String> keyFieldNames = new HashMap<String, String>();
        for (String collectionFieldStatement : collectionFieldStatements = config.has(KEY_FIELD_NAMES, new String[0]) ? (String[])config.get(KEY_FIELD_NAMES, new String[0]) : new String[]{}) {
            String[] parts = collectionFieldStatement.trim().split("=");
            if (parts.length != 2) {
                throw new PermanentBackendException("Unable to parse the collection name / key field name pair. It should be of the format collection=field");
            }
            String collectionName = parts[0];
            String keyFieldName = parts[1];
            keyFieldNames.put(collectionName, keyFieldName);
        }
        return keyFieldNames;
    }

    private String getKeyFieldId(String collection) {
        String field = this.keyFieldIds.get(collection);
        if (field == null) {
            field = DEFAULT_ID_FIELD;
        }
        return field;
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        if (this.mode == Mode.CLOUD) {
            CloudSolrServer cloudServer = (CloudSolrServer)this.solrServer;
            try {
                SolrIndex.createCollectionIfNotExists(cloudServer, this.configuration, store);
            }
            catch (IOException e) {
                throw new PermanentBackendException((Throwable)e);
            }
            catch (SolrServerException e) {
                throw new PermanentBackendException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new PermanentBackendException((Throwable)e);
            }
            catch (KeeperException e) {
                throw new PermanentBackendException((Throwable)e);
            }
        }
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        try {
            for (Map.Entry<String, Map<String, IndexMutation>> stores : mutations.entrySet()) {
                String collectionName = stores.getKey();
                String keyIdField = this.getKeyFieldId(collectionName);
                ArrayList<String> deleteIds = new ArrayList<String>();
                ArrayList<SolrInputDocument> changes = new ArrayList<SolrInputDocument>();
                for (Map.Entry<String, IndexMutation> entry : stores.getValue().entrySet()) {
                    String docId = entry.getKey();
                    IndexMutation mutation = entry.getValue();
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.isDeleted() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.hasDeletions() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isDeleted() || !mutation.hasAdditions() ? 1 : 0) != 0);
                    if (mutation.hasDeletions()) {
                        if (mutation.isDeleted()) {
                            logger.trace("Deleting entire document {}", (Object)docId);
                            deleteIds.add(docId);
                        } else {
                            HashSet fieldDeletions = Sets.newHashSet((Iterable)mutation.getDeletions());
                            if (mutation.hasAdditions()) {
                                for (IndexEntry indexEntry : mutation.getAdditions()) {
                                    fieldDeletions.remove(indexEntry);
                                }
                            }
                            this.deleteIndividualFieldsFromIndex(collectionName, keyIdField, docId, fieldDeletions);
                        }
                    }
                    if (!mutation.hasAdditions()) continue;
                    int ttl = mutation.determineTTL();
                    SolrInputDocument doc = new SolrInputDocument();
                    doc.setField(keyIdField, (Object)docId);
                    boolean isNewDoc = mutation.isNew();
                    if (isNewDoc) {
                        logger.trace("Adding new document {}", (Object)docId);
                    }
                    for (IndexEntry e : mutation.getAdditions()) {
                        final Object fieldValue = this.convertValue(e.value);
                        doc.setField(e.field, isNewDoc ? fieldValue : new HashMap<String, Object>(1){
                            {
                                super(x0);
                                this.put("set", fieldValue);
                            }
                        });
                    }
                    if (ttl > 0) {
                        Preconditions.checkArgument((boolean)isNewDoc, (String)"Solr only supports TTL on new documents [%s]", (Object[])new Object[]{docId});
                        doc.setField(this.ttlField, (Object)String.format("+%dSECONDS", ttl));
                    }
                    changes.add(doc);
                }
                this.commitDeletes(collectionName, deleteIds);
                this.commitDocumentChanges(collectionName, changes);
            }
        }
        catch (Exception e) {
            throw this.storageException(e);
        }
    }

    private Object convertValue(Object value) throws BackendException {
        if (value instanceof Geoshape) {
            return GeoToWktConverter.convertToWktString((Geoshape)value);
        }
        if (value instanceof AbstractDecimal) {
            return ((AbstractDecimal)value).doubleValue();
        }
        return value;
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        try {
            for (Map.Entry<String, Map<String, List<IndexEntry>>> stores : documents.entrySet()) {
                final String collectionName = stores.getKey();
                ArrayList<String> deleteIds = new ArrayList<String>();
                ArrayList<SolrInputDocument> newDocuments = new ArrayList<SolrInputDocument>();
                for (Map.Entry<String, List<IndexEntry>> entry : stores.getValue().entrySet()) {
                    final String docID = entry.getKey();
                    final List<IndexEntry> content = entry.getValue();
                    if (content == null || content.isEmpty()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Deleting document [{}]", (Object)docID);
                        }
                        deleteIds.add(docID);
                        continue;
                    }
                    newDocuments.add(new SolrInputDocument(){
                        {
                            this.setField(SolrIndex.this.getKeyFieldId(collectionName), docID);
                            for (IndexEntry addition : content) {
                                Object fieldValue = addition.value;
                                this.setField(addition.field, SolrIndex.this.convertValue(fieldValue));
                            }
                        }
                    });
                }
                this.commitDeletes(collectionName, deleteIds);
                this.commitDocumentChanges(collectionName, newDocuments);
            }
        }
        catch (Exception e) {
            throw new TemporaryBackendException("Could not restore Solr index", (Throwable)e);
        }
    }

    private void deleteIndividualFieldsFromIndex(String collectionName, String keyIdField, String docId, HashSet<IndexEntry> fieldDeletions) throws SolrServerException, IOException {
        if (fieldDeletions.isEmpty()) {
            return;
        }
        HashMap<String, String> fieldDeletes = new HashMap<String, String>(1){
            {
                this.put("set", null);
            }
        };
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField(keyIdField, (Object)docId);
        StringBuilder sb = new StringBuilder();
        for (IndexEntry fieldToDelete : fieldDeletions) {
            doc.addField(fieldToDelete.field, (Object)fieldDeletes);
            sb.append(fieldToDelete).append(",");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Deleting individual fields [{}] for document {}", (Object)sb.toString(), (Object)docId);
        }
        UpdateRequest singleDocument = SolrIndex.newUpdateRequest(collectionName);
        singleDocument.add(doc);
        this.solrServer.request((SolrRequest)singleDocument);
    }

    private void commitDocumentChanges(String collectionName, Collection<SolrInputDocument> documents) throws SolrServerException, IOException {
        if (documents.size() == 0) {
            return;
        }
        try {
            this.solrServer.request((SolrRequest)SolrIndex.newUpdateRequest(collectionName).add(documents));
        }
        catch (HttpSolrServer.RemoteSolrException rse) {
            logger.error("Unable to save documents to Solr as one of the shape objects stored were not compatible with Solr.", (Throwable)rse);
            logger.error("Details in failed document batch: ");
            for (SolrInputDocument d : documents) {
                Collection fieldNames = d.getFieldNames();
                for (String name : fieldNames) {
                    logger.error(name + ":" + d.getFieldValue(name).toString());
                }
            }
            throw rse;
        }
    }

    private void commitDeletes(String collectionName, List<String> deleteIds) throws SolrServerException, IOException {
        if (deleteIds.size() == 0) {
            return;
        }
        this.solrServer.request((SolrRequest)SolrIndex.newUpdateRequest(collectionName).deleteById(deleteIds));
    }

    public List<String> query(IndexQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        ArrayList<String> result;
        String collection = query.getStore();
        String keyIdField = this.getKeyFieldId(collection);
        SolrQuery solrQuery = SolrIndex.newQuery(collection, "*:*");
        String queryFilter = this.buildQueryFilter((Condition<TitanElement>)query.getCondition(), informations.get(collection));
        solrQuery.addFilterQuery(new String[]{queryFilter});
        if (!query.getOrder().isEmpty()) {
            List orders = query.getOrder();
            for (IndexQuery.OrderEntry order1 : orders) {
                String item = order1.getKey();
                SolrQuery.ORDER order = order1.getOrder() == Order.ASC ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
                solrQuery.addSort(new SolrQuery.SortClause(item, order));
            }
        }
        solrQuery.setStart(Integer.valueOf(0));
        if (query.hasLimit()) {
            solrQuery.setRows(Integer.valueOf(query.getLimit()));
        } else {
            solrQuery.setRows(Integer.valueOf(this.maxResults));
        }
        try {
            QueryResponse response = this.solrServer.query((SolrParams)solrQuery);
            if (logger.isDebugEnabled()) {
                logger.debug("Executed query [{}] in {} ms", (Object)query.getCondition(), (Object)response.getElapsedTime());
            }
            int totalHits = response.getResults().size();
            if (!query.hasLimit() && totalHits >= this.maxResults) {
                logger.warn("Query result set truncated to first [{}] elements for query: {}", (Object)this.maxResults, (Object)query);
            }
            result = new ArrayList<String>(totalHits);
            for (SolrDocument hit : response.getResults()) {
                result.add(hit.getFieldValue(keyIdField).toString());
            }
        }
        catch (HttpSolrServer.RemoteSolrException e) {
            logger.error("Query did not complete because parameters were not recognized : ", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (SolrServerException e) {
            logger.error("Unable to query Solr index.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        return result;
    }

    public Iterable<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever informations, BaseTransaction tx) throws BackendException {
        ArrayList<RawQuery.Result<String>> result;
        String collection = query.getStore();
        String keyIdField = this.getKeyFieldId(collection);
        SolrQuery solrQuery = SolrIndex.newQuery(collection, query.getQuery()).addField(keyIdField).setIncludeScore(true).setStart(Integer.valueOf(query.getOffset())).setRows(Integer.valueOf(query.hasLimit() ? query.getLimit() : this.maxResults));
        try {
            QueryResponse response = this.solrServer.query((SolrParams)solrQuery);
            if (logger.isDebugEnabled()) {
                logger.debug("Executed query [{}] in {} ms", (Object)query.getQuery(), (Object)response.getElapsedTime());
            }
            int totalHits = response.getResults().size();
            if (!query.hasLimit() && totalHits >= this.maxResults) {
                logger.warn("Query result set truncated to first [{}] elements for query: {}", (Object)this.maxResults, (Object)query);
            }
            result = new ArrayList<RawQuery.Result<String>>(totalHits);
            for (SolrDocument hit : response.getResults()) {
                double score = Double.parseDouble(hit.getFieldValue("score").toString());
                result.add((RawQuery.Result<String>)new RawQuery.Result((Object)hit.getFieldValue(keyIdField).toString(), score));
            }
        }
        catch (HttpSolrServer.RemoteSolrException e) {
            logger.error("Query did not complete because parameters were not recognized : ", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (SolrServerException e) {
            logger.error("Unable to query Solr index.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        return result;
    }

    private static String escapeValue(Object value) {
        return ClientUtils.escapeQueryChars((String)value.toString());
    }

    public String buildQueryFilter(Condition<TitanElement> condition, KeyInformation.StoreRetriever informations) {
        if (condition instanceof PredicateCondition) {
            PredicateCondition atom = (PredicateCondition)condition;
            Object value = atom.getValue();
            String key = (String)atom.getKey();
            TitanPredicate titanPredicate = atom.getPredicate();
            if (value instanceof Number) {
                String queryValue = SolrIndex.escapeValue(value);
                Preconditions.checkArgument((boolean)(titanPredicate instanceof Cmp), (Object)("Relation not supported on numeric types: " + titanPredicate));
                Cmp numRel = (Cmp)titanPredicate;
                switch (numRel) {
                    case EQUAL: {
                        return key + ":" + queryValue;
                    }
                    case NOT_EQUAL: {
                        return "-" + key + ":" + queryValue;
                    }
                    case LESS_THAN: {
                        return key + ":[* TO " + queryValue + "}";
                    }
                    case LESS_THAN_EQUAL: {
                        return key + ":[* TO " + queryValue + "]";
                    }
                    case GREATER_THAN: {
                        return key + ":{" + queryValue + " TO *]";
                    }
                    case GREATER_THAN_EQUAL: {
                        return key + ":[" + queryValue + " TO *]";
                    }
                }
                throw new IllegalArgumentException("Unexpected relation: " + numRel);
            }
            if (value instanceof String) {
                Mapping map = SolrIndex.getStringMapping(informations.get(key));
                assert (map == Mapping.TEXT || map == Mapping.STRING);
                if (map == Mapping.TEXT && !titanPredicate.toString().startsWith("CONTAINS")) {
                    throw new IllegalArgumentException("Text mapped string values only support CONTAINS queries and not: " + titanPredicate);
                }
                if (map == Mapping.STRING && titanPredicate.toString().startsWith("CONTAINS")) {
                    throw new IllegalArgumentException("String mapped string values do not support CONTAINS queries: " + titanPredicate);
                }
                if (titanPredicate == Text.CONTAINS) {
                    List terms = Text.tokenize((String)((String)(value = ((String)value).toLowerCase())));
                    if (terms.isEmpty()) {
                        return "";
                    }
                    if (terms.size() == 1) {
                        return key + ":(" + SolrIndex.escapeValue(terms.get(0)) + ")";
                    }
                    And andTerms = new And();
                    for (String term : terms) {
                        andTerms.add((Condition)new PredicateCondition((Object)key, titanPredicate, (Object)term));
                    }
                    return this.buildQueryFilter((Condition<TitanElement>)andTerms, informations);
                }
                if (titanPredicate == Text.PREFIX || titanPredicate == Text.CONTAINS_PREFIX) {
                    return key + ":" + SolrIndex.escapeValue(value) + "*";
                }
                if (titanPredicate == Text.REGEX || titanPredicate == Text.CONTAINS_REGEX) {
                    return key + ":/" + value + "/";
                }
                if (titanPredicate == Cmp.EQUAL) {
                    return key + ":\"" + SolrIndex.escapeValue(value) + "\"";
                }
                if (titanPredicate == Cmp.NOT_EQUAL) {
                    return "-" + key + ":\"" + SolrIndex.escapeValue(value) + "\"";
                }
                throw new IllegalArgumentException("Relation is not supported for string value: " + titanPredicate);
            }
            if (value instanceof Geoshape) {
                Geoshape geo = (Geoshape)value;
                if (geo.getType() == Geoshape.Type.CIRCLE) {
                    Geoshape.Point center = geo.getPoint();
                    return "{!geofilt sfield=" + key + " pt=" + center.getLatitude() + "," + center.getLongitude() + " d=" + geo.getRadius() + "} distErrPct=0";
                }
                if (geo.getType() == Geoshape.Type.BOX) {
                    Geoshape.Point southwest = geo.getPoint(0);
                    Geoshape.Point northeast = geo.getPoint(1);
                    return key + ":[" + southwest.getLatitude() + "," + southwest.getLongitude() + " TO " + northeast.getLatitude() + "," + northeast.getLongitude() + "]";
                }
                if (geo.getType() == Geoshape.Type.POLYGON) {
                    List<Geoshape.Point> coordinates = this.getPolygonPoints(geo);
                    StringBuilder poly = new StringBuilder(key + ":\"IsWithin(POLYGON((");
                    for (Geoshape.Point coordinate : coordinates) {
                        poly.append(coordinate.getLongitude()).append(" ").append(coordinate.getLatitude()).append(", ");
                    }
                    poly.append(coordinates.get(0).getLongitude()).append(" ").append(coordinates.get(0).getLatitude());
                    poly.append(")))\" distErrPct=0");
                    return poly.toString();
                }
            }
        } else {
            if (condition instanceof Not) {
                String sub = this.buildQueryFilter((Condition<TitanElement>)((Not)condition).getChild(), informations);
                if (StringUtils.isNotBlank((String)sub)) {
                    return "-(" + sub + ")";
                }
                return "";
            }
            if (condition instanceof And) {
                int numChildren = ((And)condition).size();
                StringBuilder sb = new StringBuilder();
                for (Condition c : condition.getChildren()) {
                    String sub = this.buildQueryFilter((Condition<TitanElement>)c, informations);
                    if (StringUtils.isBlank((String)sub)) continue;
                    if (!sub.startsWith("-") && numChildren > 1) {
                        sb.append("+");
                    }
                    sb.append(sub).append(" ");
                }
                return sb.toString();
            }
            if (condition instanceof Or) {
                StringBuilder sb = new StringBuilder();
                int element = 0;
                for (Condition c : condition.getChildren()) {
                    String sub = this.buildQueryFilter((Condition<TitanElement>)c, informations);
                    if (StringUtils.isBlank((String)sub)) continue;
                    if (element == 0) {
                        sb.append("(");
                    } else {
                        sb.append(" OR ");
                    }
                    sb.append(sub);
                    ++element;
                }
                if (element > 0) {
                    sb.append(")");
                }
                return sb.toString();
            }
            throw new IllegalArgumentException("Invalid condition: " + condition);
        }
        return null;
    }

    private List<Geoshape.Point> getPolygonPoints(Geoshape polygon) {
        ArrayList<Geoshape.Point> locations = new ArrayList<Geoshape.Point>();
        int index = 0;
        boolean hasCoordinates = true;
        while (hasCoordinates) {
            try {
                locations.add(polygon.getPoint(index));
            }
            catch (ArrayIndexOutOfBoundsException ignore) {
                hasCoordinates = false;
            }
        }
        return locations;
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) throws BackendException {
        return new DefaultTransaction(config);
    }

    public void close() throws BackendException {
        logger.trace("Shutting down connection to Solr", (Object)this.solrServer);
        this.solrServer.shutdown();
    }

    public void clearStorage() throws BackendException {
        try {
            if (this.mode != Mode.CLOUD) {
                throw new UnsupportedOperationException("Operation only supported for SolrCloud");
            }
            logger.debug("Clearing storage from Solr: {}", (Object)this.solrServer);
            ZkStateReader zkStateReader = ((CloudSolrServer)this.solrServer).getZkStateReader();
            zkStateReader.updateClusterState(true);
            ClusterState clusterState = zkStateReader.getClusterState();
            for (String collection : clusterState.getCollections()) {
                logger.debug("Clearing collection [{}] in Solr", (Object)collection);
                UpdateRequest deleteAll = SolrIndex.newUpdateRequest(collection);
                deleteAll.deleteByQuery("*:*");
                this.solrServer.request((SolrRequest)deleteAll);
            }
        }
        catch (SolrServerException e) {
            logger.error("Unable to clear storage from index due to server error on Solr.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to clear storage from index due to low-level I/O error.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unable to clear storage from index due to general error.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public boolean supports(KeyInformation information, TitanPredicate titanPredicate) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (mapping != Mapping.DEFAULT && !AttributeUtil.isString((Class)dataType)) {
            return false;
        }
        if (Number.class.isAssignableFrom(dataType)) {
            return titanPredicate instanceof Cmp;
        }
        if (dataType == Geoshape.class) {
            return titanPredicate == Geo.WITHIN;
        }
        if (AttributeUtil.isString((Class)dataType)) {
            switch (mapping) {
                case DEFAULT: 
                case TEXT: {
                    return titanPredicate == Text.CONTAINS || titanPredicate == Text.CONTAINS_PREFIX || titanPredicate == Text.CONTAINS_REGEX;
                }
                case STRING: {
                    return titanPredicate == Cmp.EQUAL || titanPredicate == Cmp.NOT_EQUAL || titanPredicate == Text.REGEX || titanPredicate == Text.PREFIX;
                }
            }
        }
        return false;
    }

    public boolean supports(KeyInformation information) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        return Number.class.isAssignableFrom(dataType) || dataType == Geoshape.class ? mapping == Mapping.DEFAULT : AttributeUtil.isString((Class)dataType) && (mapping == Mapping.DEFAULT || mapping == Mapping.TEXT || mapping == Mapping.STRING);
    }

    public String mapKey2Field(String key, KeyInformation keyInfo) {
        String postfix;
        Preconditions.checkArgument((!StringUtils.containsAny((String)key, (char[])new char[]{' '}) ? 1 : 0) != 0, (String)"Invalid key name provided: %s", (Object[])new Object[]{key});
        if (!this.dynFields) {
            return key;
        }
        if (ParameterType.MAPPED_NAME.hasParameter(keyInfo.getParameters())) {
            return key;
        }
        Class datatype = keyInfo.getDataType();
        if (AttributeUtil.isString((Class)datatype)) {
            Mapping map = SolrIndex.getStringMapping(keyInfo);
            switch (map) {
                case TEXT: {
                    postfix = "_t";
                    break;
                }
                case STRING: {
                    postfix = "_s";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported string mapping: " + map);
                }
            }
        } else if (AttributeUtil.isWholeNumber((Class)datatype)) {
            postfix = datatype.equals(Long.class) ? "_l" : "_i";
        } else if (AttributeUtil.isDecimal((Class)datatype)) {
            postfix = datatype.equals(Float.class) ? "_f" : "_d";
        } else if (datatype.equals(Geoshape.class)) {
            postfix = "_g";
        } else {
            throw new IllegalArgumentException("Unsupported data type [" + datatype + "] for field: " + key);
        }
        return key + postfix;
    }

    public IndexFeatures getFeatures() {
        return SOLR_FEATURES;
    }

    private static Mapping getStringMapping(KeyInformation information) {
        assert (AttributeUtil.isString((Class)information.getDataType()));
        Mapping map = Mapping.getMapping((KeyInformation)information);
        if (map == Mapping.DEFAULT) {
            map = Mapping.TEXT;
        }
        return map;
    }

    private static UpdateRequest newUpdateRequest(String collection) {
        UpdateRequest req = new UpdateRequest();
        req.setParam(COLLECTION_PARAM, collection);
        req.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        return req;
    }

    private static SolrQuery newQuery(String collection, String query) {
        return new SolrQuery().setParam(COLLECTION_PARAM, new String[]{collection}).setQuery(query);
    }

    private BackendException storageException(Exception solrException) {
        return new TemporaryBackendException("Unable to complete query on Solr.", (Throwable)solrException);
    }

    private static void createCollectionIfNotExists(CloudSolrServer server, Configuration config, String collection) throws IOException, SolrServerException, KeeperException, InterruptedException {
        if (!SolrIndex.checkIfCollectionExists(server, collection)) {
            Integer numShards = (Integer)config.get(NUM_SHARDS, new String[0]);
            Integer maxShardsPerNode = (Integer)config.get(MAX_SHARDS_PER_NODE, new String[0]);
            Integer replicationFactor = (Integer)config.get(REPLICATION_FACTOR, new String[0]);
            CollectionAdminRequest.Create createRequest = new CollectionAdminRequest.Create();
            createRequest.setConfigName(collection);
            createRequest.setCollectionName(collection);
            createRequest.setNumShards(numShards);
            createRequest.setMaxShardsPerNode(maxShardsPerNode);
            createRequest.setReplicationFactor(replicationFactor);
            CollectionAdminResponse createResponse = createRequest.process((SolrServer)server);
            if (createResponse.isSuccess()) {
                logger.trace("Collection {} successfully created.", (Object)collection);
            } else {
                throw new SolrServerException(Joiner.on((String)"\n").join((Iterable)createResponse.getErrorMessages()));
            }
        }
        SolrIndex.waitForRecoveriesToFinish(server, collection);
    }

    private static boolean checkIfCollectionExists(CloudSolrServer server, String collection) throws KeeperException, InterruptedException {
        ZkStateReader zkStateReader = server.getZkStateReader();
        zkStateReader.updateClusterState(true);
        ClusterState clusterState = zkStateReader.getClusterState();
        return clusterState.getCollectionOrNull(collection) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForRecoveriesToFinish(CloudSolrServer server, String collection) throws KeeperException, InterruptedException {
        ZkStateReader zkStateReader = server.getZkStateReader();
        try {
            boolean cont = true;
            while (cont) {
                boolean sawLiveRecovering = false;
                zkStateReader.updateClusterState(true);
                ClusterState clusterState = zkStateReader.getClusterState();
                Map slices = clusterState.getSlicesMap(collection);
                Preconditions.checkNotNull((Object)("Could not find collection:" + collection), (Object)slices);
                for (Map.Entry entry : slices.entrySet()) {
                    Map shards = ((Slice)entry.getValue()).getReplicasMap();
                    for (Map.Entry shard : shards.entrySet()) {
                        String state = ((Replica)shard.getValue()).getStr("state");
                        if (!state.equals("recovering") && !state.equals("sync") && !state.equals("down") || !clusterState.liveNodesContain(((Replica)shard.getValue()).getStr("node_name"))) continue;
                        sawLiveRecovering = true;
                    }
                }
                if (!sawLiveRecovering) {
                    cont = false;
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        finally {
            logger.info("Exiting solr wait");
        }
    }

    private static enum Mode {
        HTTP,
        CLOUD;


        public static Mode parse(String mode) {
            for (Mode m : Mode.values()) {
                if (!m.toString().equalsIgnoreCase(mode)) continue;
                return m;
            }
            throw new IllegalArgumentException("Unrecognized mode: " + mode);
        }
    }
}

