/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.NonTxTransactionalAccessDelegate;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.access.TxTransactionalAccessDelegate;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.infinispan.AdvancedCache;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class TransactionalAccessDelegate {
    protected static final Log log = LogFactory.getLog(TransactionalAccessDelegate.class);
    protected static final boolean TRACE_ENABLED = log.isTraceEnabled();
    protected final AdvancedCache cache;
    protected final BaseRegion region;
    protected final PutFromLoadValidator putValidator;
    protected final AdvancedCache<Object, Object> writeCache;

    public static TransactionalAccessDelegate create(BaseRegion region, PutFromLoadValidator validator) {
        if (region.getCache().getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            return new TxTransactionalAccessDelegate(region, validator);
        }
        return new NonTxTransactionalAccessDelegate(region, validator);
    }

    protected TransactionalAccessDelegate(BaseRegion region, PutFromLoadValidator validator) {
        this.region = region;
        this.cache = region.getCache();
        this.putValidator = validator;
        this.writeCache = Caches.ignoreReturnValuesCache(this.cache);
    }

    public Object get(SessionImplementor session, Object key, long txTimestamp) throws CacheException {
        if (!this.region.checkValid()) {
            return null;
        }
        Object val = this.cache.get(key);
        if (val == null) {
            this.putValidator.registerPendingPut(session, key, txTimestamp);
        }
        return val;
    }

    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(session, key, value, txTimestamp, version, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        if (!this.region.checkValid()) {
            if (TRACE_ENABLED) {
                log.tracef("Region %s not valid", (Object)this.region.getName());
            }
            return false;
        }
        if (minimalPutOverride && this.cache.containsKey(key)) {
            return false;
        }
        PutFromLoadValidator.Lock lock = this.putValidator.acquirePutFromLoadLock(session, key, txTimestamp);
        if (lock == null) {
            if (TRACE_ENABLED) {
                log.tracef("Put from load lock not acquired for key %s", key);
            }
            return false;
        }
        try {
            this.writeCache.putForExternalRead(key, value);
        }
        finally {
            this.putValidator.releasePutFromLoadLock(key, lock);
        }
        return true;
    }

    public abstract boolean insert(SessionImplementor var1, Object var2, Object var3, Object var4) throws CacheException;

    public abstract boolean update(SessionImplementor var1, Object var2, Object var3, Object var4, Object var5) throws CacheException;

    public void remove(SessionImplementor session, Object key) throws CacheException {
        if (!this.putValidator.beginInvalidatingKey(session, key)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.remove(key);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
    }

    public void removeAll() throws CacheException {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                throw new CacheException("Failed to invalidate pending putFromLoad calls for region " + this.region.getName());
            }
            Caches.removeAll(this.cache);
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }

    public void evict(Object key) throws CacheException {
        this.writeCache.remove(key);
    }

    public void evictAll() throws CacheException {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                throw new CacheException("Failed to invalidate pending putFromLoad calls for region " + this.region.getName());
            }
            this.region.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }

    public void unlockItem(SessionImplementor session, Object key) throws CacheException {
        if (!this.putValidator.endInvalidatingKey(session, key)) {
            log.warn((Object)("Failed to end invalidating pending putFromLoad calls for key " + key + " from region " + this.region.getName() + "; the key won't be cached until invalidation expires."));
        }
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value, Object version) {
        if (!this.putValidator.endInvalidatingKey(session, key)) {
            log.warn((Object)("Failed to end invalidating pending putFromLoad calls for key " + key + " from region " + this.region.getName() + "; the key won't be cached until invalidation expires."));
        }
        return false;
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        if (!this.putValidator.endInvalidatingKey(session, key)) {
            log.warn((Object)("Failed to end invalidating pending putFromLoad calls for key " + key + " from region " + this.region.getName() + "; the key won't be cached until invalidation expires."));
        }
        return false;
    }
}

