/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.Arrays;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;

public class EndInvalidationCommand
extends BaseRpcCommand {
    private Object[] keys;
    private Object lockOwner;
    private PutFromLoadValidator putFromLoadValidator;

    public EndInvalidationCommand(String cacheName) {
        this(cacheName, null, null);
    }

    public EndInvalidationCommand(String cacheName, Object[] keys, Object lockOwner) {
        super(cacheName);
        this.keys = keys;
        this.lockOwner = lockOwner;
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        for (Object key : this.keys) {
            this.putFromLoadValidator.endInvalidatingKey(this.lockOwner, key);
        }
        return null;
    }

    public byte getCommandId() {
        return 121;
    }

    public Object[] getParameters() {
        return new Object[]{this.keys, this.lockOwner};
    }

    public void setParameters(int commandId, Object[] parameters) {
        this.keys = (Object[])parameters[0];
        this.lockOwner = parameters[1];
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    public boolean canBlock() {
        return true;
    }

    public void setPutFromLoadValidator(PutFromLoadValidator putFromLoadValidator) {
        this.putFromLoadValidator = putFromLoadValidator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EndInvalidationCommand{");
        sb.append("cacheName=").append(this.cacheName);
        sb.append(", keys=").append(Arrays.toString(this.keys));
        sb.append(", lockOwner=").append(this.lockOwner);
        sb.append('}');
        return sb.toString();
    }
}

