/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.infinispan.ClusterSharedConnectionProvider;
import org.hibernate.search.infinispan.ClusterTestHelper;
import org.hibernate.search.infinispan.SimpleEmail;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TwoNodesTest {
    private final String to = "spam@hibernate.org";
    private final String messageText = "to get started as a real spam expert, search for 'getting an iphone' on Hibernate forums";
    FullTextSessionBuilder nodea;
    FullTextSessionBuilder nodeb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSomething() {
        Assert.assertEquals((int)2, (int)ClusterTestHelper.clusterSize(this.nodea));
        FullTextSession fullTextSession = this.nodea.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        SimpleEmail mail = new SimpleEmail();
        mail.to = "spam@hibernate.org";
        mail.message = "to get started as a real spam expert, search for 'getting an iphone' on Hibernate forums";
        fullTextSession.save((Object)mail);
        transaction.commit();
        fullTextSession.close();
        this.verifyNodeSeesUpdatedIndex(this.nodeb);
        FullTextSessionBuilder nodeC = ClusterTestHelper.createClusterNode();
        Assert.assertEquals((int)3, (int)ClusterTestHelper.clusterSize(this.nodea));
        try {
            this.verifyNodeSeesUpdatedIndex(nodeC);
        }
        finally {
            nodeC.close();
        }
        Assert.assertEquals((int)2, (int)ClusterTestHelper.clusterSize(this.nodea));
        this.verifyNodeSeesUpdatedIndex(this.nodea);
        this.verifyNodeSeesUpdatedIndex(this.nodeb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyNodeSeesUpdatedIndex(FullTextSessionBuilder node) {
        FullTextSession fullTextSession = node.openFullTextSession();
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(SimpleEmail.class).get();
            Query query = queryBuilder.keyword().onField("message").matching((Object)"Hibernate Getting Started").createQuery();
            List list = fullTextSession.createFullTextQuery(query, new Class[0]).setProjection(new String[]{"message"}).list();
            Assert.assertEquals((int)1, (int)list.size());
            Object[] result = (Object[])list.get(0);
            Assert.assertEquals((Object)"to get started as a real spam expert, search for 'getting an iphone' on Hibernate forums", (Object)result[0]);
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.nodea = ClusterTestHelper.createClusterNode();
        this.nodeb = ClusterTestHelper.createClusterNode();
        ClusterTestHelper.waitMembersCount(this.nodea, 2);
    }

    @After
    public void tearDown() throws Exception {
        this.nodea.close();
        this.nodeb.close();
    }

    @BeforeClass
    public static void prepareConnectionPool() {
        ClusterSharedConnectionProvider.realStart();
    }

    @AfterClass
    public static void shutdownConnectionPool() {
        ClusterSharedConnectionProvider.realStop();
    }
}

