/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import java.util.List;
import junit.framework.AssertionFailedError;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.ClusterSharedConnectionProvider;
import org.hibernate.search.infinispan.SimpleEmail;
import org.hibernate.search.infinispan.impl.InfinispanDirectoryProvider;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.manager.EmbeddedCacheManager;

public class ClusterTestHelper {
    public static FullTextSessionBuilder createClusterNode() {
        FullTextSessionBuilder node = new FullTextSessionBuilder().setProperty("hibernate.search.default.directory_provider", "infinispan").setProperty("hibernate.search.default.indexwriter.chunk_size", "13").setProperty("hibernate.hbm2ddl.auto", "create").setProperty("hibernate.search.infinispan.configuration_resourcename", "testing-hibernatesearch-infinispan.xml").setProperty("hibernate.connection.provider_class", ClusterSharedConnectionProvider.class.getName()).addAnnotatedClass(SimpleEmail.class);
        return node.build();
    }

    public static void waitMembersCount(FullTextSessionBuilder node, int expectedSize) {
        int currentSize = 0;
        int loopCounter = 0;
        while (currentSize < expectedSize) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new AssertionFailedError(e.getMessage());
            }
            currentSize = ClusterTestHelper.clusterSize(node);
            if (loopCounter <= 200) continue;
            throw new AssertionFailedError("timeout while waiting for all nodes to join in cluster");
        }
    }

    public static int clusterSize(FullTextSessionBuilder node) {
        SearchFactoryIntegrator searchFactory = (SearchFactoryIntegrator)node.getSearchFactory();
        EntityIndexBinder mailIndexBinding = searchFactory.getIndexBindingForEntity(SimpleEmail.class);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)mailIndexBinding.getIndexManagers()[0];
        InfinispanDirectoryProvider directoryProvider = (InfinispanDirectoryProvider)indexManager.getDirectoryProvider();
        EmbeddedCacheManager cacheManager = directoryProvider.getCacheManager();
        List members = cacheManager.getMembers();
        return members.size();
    }
}

