/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.io.ByteBuffer;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.NotSerializableException;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.jboss.ExternalizerTable;
import org.infinispan.marshall.jboss.JBossMarshaller;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class VersionAwareMarshaller
extends AbstractMarshaller
implements StreamingMarshaller {
    private static final Log log = LogFactory.getLog(VersionAwareMarshaller.class);
    private final boolean trace = log.isTraceEnabled();
    private static final int VERSION_510 = 510;
    private final JBossMarshaller defaultMarshaller = new JBossMarshaller();
    private String cacheName;

    public void inject(Cache cache, Configuration cfg, InvocationContextContainer icc, ExternalizerTable extTable, GlobalConfiguration globalCfg) {
        this.cacheName = cfg == null ? null : cache.getName();
        this.defaultMarshaller.inject(extTable, cfg, icc, globalCfg);
    }

    @Override
    public void start() {
        this.defaultMarshaller.start();
    }

    @Override
    public void stop() {
        this.defaultMarshaller.stop();
    }

    @Override
    protected ByteBuffer objectToBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(estimatedSize);
        ObjectOutput out = this.startObjectOutput(baos, false, estimatedSize);
        try {
            this.defaultMarshaller.objectToObjectStream(obj, out);
        }
        catch (java.io.NotSerializableException nse) {
            if (log.isDebugEnabled()) {
                log.debug("Object is not serializable", nse);
            }
            throw new NotSerializableException(nse.getMessage(), nse.getCause());
        }
        catch (IOException ioe) {
            if (ioe.getCause() instanceof InterruptedException) {
                if (log.isTraceEnabled()) {
                    log.trace("Interrupted exception while marshalling", ioe.getCause());
                }
                throw (InterruptedException)ioe.getCause();
            }
            log.errorMarshallingObject(ioe);
            throw ioe;
        }
        finally {
            this.finishObjectOutput(out);
        }
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object objectFromByteBuffer(byte[] bytes, int offset, int len) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes, offset, len);
        ObjectInput in = this.startObjectInput(is, false);
        Object o = null;
        try {
            o = this.defaultMarshaller.objectFromObjectStream(in);
        }
        finally {
            this.finishObjectInput(in);
        }
        return o;
    }

    @Override
    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant, int estimatedSize) throws IOException {
        ObjectOutput out = this.defaultMarshaller.startObjectOutput(os, isReentrant, estimatedSize);
        try {
            int version = 510;
            out.writeShort(510);
            if (this.trace) {
                log.tracef("Wrote version %s", 510);
            }
        }
        catch (Exception e) {
            this.finishObjectOutput(out);
            log.unableToReadVersionId();
            throw new IOException("Unable to read version id from first two bytes of stream : " + e.getMessage());
        }
        return out;
    }

    @Override
    @Deprecated
    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant) throws IOException {
        return this.startObjectOutput(os, isReentrant, 512);
    }

    @Override
    public void finishObjectOutput(ObjectOutput oo) {
        this.defaultMarshaller.finishObjectOutput(oo);
    }

    @Override
    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        this.defaultMarshaller.objectToObjectStream(obj, out);
    }

    @Override
    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        ObjectInput in = this.defaultMarshaller.startObjectInput(is, isReentrant);
        try {
            short versionId = in.readShort();
            if (this.trace) {
                log.tracef("Read version %s", versionId);
            }
        }
        catch (Exception e) {
            this.finishObjectInput(in);
            log.unableToReadVersionId();
            throw new IOException("Unable to read version id from first two bytes of stream: " + e.getMessage());
        }
        return in;
    }

    @Override
    public void finishObjectInput(ObjectInput oi) {
        this.defaultMarshaller.finishObjectInput(oi);
    }

    @Override
    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException, InterruptedException {
        try {
            return this.defaultMarshaller.objectFromObjectStream(in);
        }
        catch (EOFException e) {
            EOFException ee = new EOFException("The stream ended unexpectedly.  Please check whether the source of the stream encountered any issues generating the stream.");
            ee.initCause(e);
            throw ee;
        }
        catch (IOException ioe) {
            if (this.trace) {
                log.trace("Log exception reported", ioe);
            }
            if (ioe.getCause() instanceof InterruptedException) {
                throw (InterruptedException)ioe.getCause();
            }
            throw ioe;
        }
    }

    @Override
    public boolean isMarshallable(Object o) throws Exception {
        return this.defaultMarshaller.isMarshallable(o);
    }

    public String getCacheName() {
        return this.cacheName;
    }
}

