/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.Similarity;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.engine.impl.EmptyBuildContext;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.CommonPropertiesParse;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.spi.SerializerService;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderFactory;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DirectoryBasedIndexManager
implements IndexManager {
    private static Log log = LoggerFactory.make();
    private String indexName;
    private DirectoryProvider directoryProvider;
    private Similarity similarity;
    private BackendQueueProcessor backend;
    private OptimizerStrategy optimizer;
    private LuceneIndexingParameters indexingParameters;
    private final Set<Class<?>> containedEntityTypes = new HashSet();
    private LuceneWorkSerializer serializer;
    private SearchFactoryImplementor boundSearchFactory = null;
    private DirectoryBasedReaderProvider readers = null;
    private IndexWriterConfig writerConfig;
    private ServiceManager serviceManager;

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public ReaderProvider getReaderProvider() {
        return this.readers;
    }

    @Override
    public void destroy() {
        this.readers.stop();
        this.backend.close();
        this.directoryProvider.stop();
        if (this.serializer != null) {
            this.serviceManager.releaseService(SerializerService.class);
        }
    }

    @Override
    public void initialize(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        this.indexName = indexName;
        this.directoryProvider = this.createDirectoryProvider(indexName, cfg, buildContext);
        this.indexingParameters = CommonPropertiesParse.extractIndexingPerformanceOptions(cfg);
        this.optimizer = CommonPropertiesParse.getOptimizerStrategy(this, cfg);
        this.backend = this.createBackend(indexName, cfg, buildContext);
        this.directoryProvider.start(this);
        this.readers = this.createIndexReader(indexName, cfg, buildContext);
        this.serviceManager = buildContext.getServiceManager();
    }

    @Override
    public Set<Class<?>> getContainedTypes() {
        return this.containedEntityTypes;
    }

    @Override
    public Similarity getSimilarity() {
        return this.similarity;
    }

    @Override
    public void setSimilarity(Similarity newSimilarity) {
        this.similarity = newSimilarity;
        this.triggerWorkspaceReconfiguration();
        if (this.writerConfig != null) {
            this.writerConfig.setSimilarity(this.similarity);
        }
    }

    @Override
    public void performStreamOperation(LuceneWork singleOperation, IndexingMonitor monitor, boolean forceAsync) {
        this.backend.applyStreamWork(singleOperation, monitor);
    }

    @Override
    public void performOperations(List<LuceneWork> workList, IndexingMonitor monitor) {
        this.backend.applyWork(workList, monitor);
    }

    public String toString() {
        return "DirectoryBasedIndexManager [indexName=" + this.indexName + "]";
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        return this.boundSearchFactory.getAnalyzer(name);
    }

    @Override
    public void setSearchFactory(SearchFactoryImplementor boundSearchFactory) {
        this.boundSearchFactory = boundSearchFactory;
        this.triggerWorkspaceReconfiguration();
    }

    @Override
    public void addContainedEntity(Class<?> entity) {
        this.containedEntityTypes.add(entity);
        this.triggerWorkspaceReconfiguration();
    }

    @Override
    public void optimize() {
        this.performStreamOperation(OptimizeLuceneWork.INSTANCE, null, false);
    }

    public BackendQueueProcessor getBackendQueueProcessor() {
        return this.backend;
    }

    public void setIndexWriterConfig(IndexWriterConfig writerConfig) {
        this.writerConfig = writerConfig;
    }

    public EntityIndexBinding getIndexBinding(Class<?> entityType) {
        return this.boundSearchFactory.getIndexBinding(entityType);
    }

    public Lock getDirectoryModificationLock() {
        return this.backend.getExclusiveWriteLock();
    }

    public DirectoryProvider getDirectoryProvider() {
        return this.directoryProvider;
    }

    public OptimizerStrategy getOptimizerStrategy() {
        return this.optimizer;
    }

    public LuceneIndexingParameters getIndexingParameters() {
        return this.indexingParameters;
    }

    @Override
    public LuceneWorkSerializer getSerializer() {
        if (this.serializer == null) {
            EmptyBuildContext buildContext = new EmptyBuildContext(this.serviceManager, this.boundSearchFactory);
            this.serializer = (LuceneWorkSerializer)this.serviceManager.requestService(SerializerService.class, buildContext);
            log.indexManagerUsesSerializationService(this.indexName, this.serializer.describeSerializer());
        }
        return this.serializer;
    }

    private void triggerWorkspaceReconfiguration() {
        if (this.boundSearchFactory != null) {
            this.backend.indexMappingChanged();
        }
    }

    protected BackendQueueProcessor createBackend(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        return BackendFactory.createBackend(this, buildContext, cfg);
    }

    protected DirectoryBasedReaderProvider createIndexReader(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        return CommonPropertiesParse.createDirectoryBasedReaderProvider(this, cfg);
    }

    protected DirectoryProvider createDirectoryProvider(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        return DirectoryProviderFactory.createDirectoryProvider(indexName, cfg, buildContext);
    }
}

