/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Set;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.Util;

public class ReplaceCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final byte COMMAND_ID = 11;
    Object oldValue;
    Object newValue;
    Metadata metadata;
    private CacheNotifier notifier;
    boolean successful = true;
    boolean ignorePreviousValue;
    private Equivalence valueEquivalence;

    public ReplaceCommand() {
    }

    public ReplaceCommand(Object key, Object oldValue, Object newValue, CacheNotifier notifier, Metadata metadata, Set<Flag> flags, Equivalence valueEquivalence) {
        super(key, flags);
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.notifier = notifier;
        this.metadata = metadata;
        this.valueEquivalence = valueEquivalence;
    }

    public void init(CacheNotifier notifier, Configuration cfg) {
        this.notifier = notifier;
        this.valueEquivalence = cfg.dataContainer().valueEquivalence();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReplaceCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e != null) {
            if (ctx.isOriginLocal() && (e.isNull() || e.getValue() == null)) {
                e.setChanged(false);
                return this.returnValue(null, false, ctx);
            }
            if (this.oldValue == null || this.isValueEquals(this.oldValue, e.getValue()) || this.ignorePreviousValue) {
                e.setChanged(true);
                Object old = e.setValue(this.newValue);
                return this.returnValue(old, true, ctx);
            }
            e.setChanged(false);
        }
        return this.returnValue(null, false, ctx);
    }

    private boolean isValueEquals(Object oldValue, Object newValue) {
        if (this.valueEquivalence != null) {
            return this.valueEquivalence.equals(oldValue, newValue);
        }
        return oldValue.equals(newValue);
    }

    private Object returnValue(Object beingReplaced, boolean successful, InvocationContext ctx) {
        Object previousValue;
        this.successful = successful;
        Object object = previousValue = this.oldValue == null ? beingReplaced : this.oldValue;
        if (successful) {
            this.notifier.notifyCacheEntryModified(this.key, previousValue, previousValue == null, true, ctx, this);
        }
        if (this.oldValue == null) {
            return beingReplaced;
        }
        return successful;
    }

    @Override
    public byte getCommandId() {
        return 11;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.oldValue, this.newValue, this.metadata, this.ignorePreviousValue, Flag.copyWithoutRemotableFlags(this.flags), this.previousRead};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 11) {
            throw new IllegalArgumentException("Invalid method name");
        }
        this.key = parameters[0];
        this.oldValue = parameters[1];
        this.newValue = parameters[2];
        this.metadata = (Metadata)parameters[3];
        this.ignorePreviousValue = (Boolean)parameters[4];
        this.flags = (Set)parameters[5];
        this.previousRead = (Boolean)parameters[6];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplaceCommand that = (ReplaceCommand)o;
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.newValue != null ? !this.newValue.equals(that.newValue) : that.newValue != null) {
            return false;
        }
        return !(this.oldValue != null ? !this.oldValue.equals(that.oldValue) : that.oldValue != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return !this.ignorePreviousValue;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    public boolean isIgnorePreviousValue() {
        return this.ignorePreviousValue;
    }

    public void setIgnorePreviousValue(boolean ignorePreviousValue) {
        this.ignorePreviousValue = ignorePreviousValue;
    }

    @Override
    public final boolean isReturnValueExpected() {
        return super.isReturnValueExpected() || this.isConditional();
    }

    @Override
    public String toString() {
        return "ReplaceCommand{key=" + Util.toStr(this.key) + ", oldValue=" + Util.toStr(this.oldValue) + ", newValue=" + Util.toStr(this.newValue) + ", metadata=" + this.metadata + ", flags=" + this.flags + ", successful=" + this.successful + ", ignorePreviousValue=" + this.ignorePreviousValue + '}';
    }
}

