/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.DeltaAwareCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.entries.NullMarkerEntry;
import org.infinispan.container.entries.NullMarkerEntryForRemoval;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.StateChangingEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntryFactoryImpl
implements EntryFactory {
    private static final Log log = LogFactory.getLog(EntryFactoryImpl.class);
    private final boolean trace = log.isTraceEnabled();
    protected boolean useRepeatableRead;
    private DataContainer container;
    protected boolean localModeWriteSkewCheck;
    private Configuration configuration;
    private CacheNotifier notifier;

    @Inject
    public void injectDependencies(DataContainer dataContainer, Configuration configuration, CacheNotifier notifier) {
        this.container = dataContainer;
        this.configuration = configuration;
        this.notifier = notifier;
    }

    @Start(priority=8)
    public void init() {
        this.useRepeatableRead = this.configuration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ;
        this.localModeWriteSkewCheck = this.configuration.locking().writeSkewCheck();
    }

    @Override
    public final CacheEntry wrapEntryForReading(InvocationContext ctx, Object key) throws InterruptedException {
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        if (cacheEntry == null) {
            cacheEntry = this.getFromContainer(key);
            if (this.useRepeatableRead) {
                MVCCEntry mvccEntry;
                if (cacheEntry == null) {
                    mvccEntry = this.createWrappedEntry(key, null, null, false, false);
                } else {
                    mvccEntry = this.createWrappedEntry(key, cacheEntry, null, false, false);
                    if (cacheEntry instanceof StateChangingEntry && mvccEntry != null) {
                        mvccEntry.copyStateFlagsFrom((StateChangingEntry)((Object)cacheEntry));
                    }
                }
                if (mvccEntry != null) {
                    ctx.putLookedUpEntry(key, mvccEntry);
                }
                return mvccEntry;
            }
            if (cacheEntry != null) {
                ctx.putLookedUpEntry(key, cacheEntry);
            }
            return cacheEntry;
        }
        return cacheEntry;
    }

    @Override
    public final MVCCEntry wrapEntryForClear(InvocationContext ctx, Object key) throws InterruptedException {
        return this.wrapEntry(ctx, key, null);
    }

    @Override
    public final MVCCEntry wrapEntryForReplace(InvocationContext ctx, ReplaceCommand cmd) throws InterruptedException {
        Object key = cmd.getKey();
        MVCCEntry mvccEntry = this.wrapEntry(ctx, key, cmd.getMetadata());
        if (mvccEntry == null) {
            ctx.putLookedUpEntry(key, null);
        }
        return mvccEntry;
    }

    @Override
    public final MVCCEntry wrapEntryForRemove(InvocationContext ctx, Object key) throws InterruptedException {
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        MVCCEntry mvccEntry = null;
        if (cacheEntry != null) {
            mvccEntry = cacheEntry instanceof MVCCEntry && !(cacheEntry instanceof NullMarkerEntry) ? (MVCCEntry)cacheEntry : this.wrapMvccEntryForRemove(ctx, key, cacheEntry);
        } else {
            InternalCacheEntry ice = this.getFromContainer(key);
            if (ice != null) {
                mvccEntry = this.wrapInternalCacheEntryForPut(ctx, key, ice, null);
                mvccEntry.setRemoved(true);
            }
        }
        if (mvccEntry == null) {
            ctx.putLookedUpEntry(key, null);
        } else {
            mvccEntry.copyForUpdate(this.container, this.localModeWriteSkewCheck);
        }
        return mvccEntry;
    }

    @Override
    public final MVCCEntry wrapEntryForPut(InvocationContext ctx, Object key, InternalCacheEntry icEntry, boolean undeleteIfNeeded, FlagAffectedCommand cmd) throws InterruptedException {
        MVCCEntry mvccEntry;
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        if (cacheEntry != null && cacheEntry.isNull()) {
            cacheEntry = null;
        }
        Metadata providedMetadata = cmd.getMetadata();
        if (cacheEntry != null) {
            mvccEntry = this.wrapMvccEntryForPut(ctx, key, cacheEntry, providedMetadata);
            mvccEntry.undelete(undeleteIfNeeded);
        } else {
            InternalCacheEntry ice;
            InternalCacheEntry internalCacheEntry = ice = icEntry == null ? this.getFromContainer(key) : icEntry;
            if (ice != null && cmd.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
                ctx.putLookedUpEntry(key, null);
                return null;
            }
            mvccEntry = ice != null ? this.wrapInternalCacheEntryForPut(ctx, key, ice, providedMetadata) : this.newMvccEntryForPut(ctx, key, cmd, providedMetadata);
        }
        mvccEntry.copyForUpdate(this.container, this.localModeWriteSkewCheck);
        return mvccEntry;
    }

    @Override
    public CacheEntry wrapEntryForDelta(InvocationContext ctx, Object deltaKey, Delta delta) throws InterruptedException {
        CacheEntry cacheEntry = this.getFromContext(ctx, deltaKey);
        DeltaAwareCacheEntry deltaAwareEntry = null;
        if (cacheEntry != null) {
            deltaAwareEntry = this.wrapEntryForDelta(ctx, deltaKey, cacheEntry);
        } else {
            InternalCacheEntry ice = this.getFromContainer(deltaKey);
            if (ice != null) {
                deltaAwareEntry = this.newDeltaAwareCacheEntry(ctx, deltaKey, (DeltaAware)ice.getValue());
            }
        }
        if (deltaAwareEntry != null) {
            deltaAwareEntry.appendDelta(delta);
        }
        return deltaAwareEntry;
    }

    private DeltaAwareCacheEntry wrapEntryForDelta(InvocationContext ctx, Object key, CacheEntry cacheEntry) {
        if (cacheEntry instanceof DeltaAwareCacheEntry) {
            return (DeltaAwareCacheEntry)cacheEntry;
        }
        return this.wrapInternalCacheEntryForDelta(ctx, key, cacheEntry);
    }

    private DeltaAwareCacheEntry wrapInternalCacheEntryForDelta(InvocationContext ctx, Object key, CacheEntry cacheEntry) {
        DeltaAwareCacheEntry e;
        if (cacheEntry instanceof MVCCEntry) {
            e = this.createWrappedDeltaEntry(key, (DeltaAware)cacheEntry.getValue(), cacheEntry);
        } else if (cacheEntry instanceof InternalCacheEntry) {
            cacheEntry = this.wrapInternalCacheEntryForPut(ctx, key, (InternalCacheEntry)cacheEntry, null);
            e = this.createWrappedDeltaEntry(key, (DeltaAware)cacheEntry.getValue(), cacheEntry);
        } else {
            e = this.createWrappedDeltaEntry(key, (DeltaAware)cacheEntry.getValue(), null);
        }
        ctx.putLookedUpEntry(key, e);
        return e;
    }

    private CacheEntry getFromContext(InvocationContext ctx, Object key) {
        CacheEntry cacheEntry = ctx.lookupEntry(key);
        if (this.trace) {
            log.tracef("Exists in context? %s ", cacheEntry);
        }
        return cacheEntry;
    }

    private InternalCacheEntry getFromContainer(Object key) {
        InternalCacheEntry ice = this.container.get(key);
        if (this.trace) {
            log.tracef("Retrieved from container %s", ice);
        }
        return ice;
    }

    private MVCCEntry newMvccEntryForPut(InvocationContext ctx, Object key, FlagAffectedCommand cmd, Metadata providedMetadata) {
        if (this.trace) {
            log.trace("Creating new entry.");
        }
        this.notifier.notifyCacheEntryCreated(key, null, true, ctx, cmd);
        MVCCEntry mvccEntry = this.createWrappedEntry(key, null, providedMetadata, true, false);
        mvccEntry.setCreated(true);
        ctx.putLookedUpEntry(key, mvccEntry);
        return mvccEntry;
    }

    private MVCCEntry wrapMvccEntryForPut(InvocationContext ctx, Object key, CacheEntry cacheEntry, Metadata providedMetadata) {
        if (cacheEntry instanceof MVCCEntry) {
            return (MVCCEntry)cacheEntry;
        }
        return this.wrapInternalCacheEntryForPut(ctx, key, (InternalCacheEntry)cacheEntry, providedMetadata);
    }

    private MVCCEntry wrapInternalCacheEntryForPut(InvocationContext ctx, Object key, InternalCacheEntry cacheEntry, Metadata providedMetadata) {
        MVCCEntry mvccEntry = this.createWrappedEntry(key, cacheEntry, providedMetadata, false, false);
        ctx.putLookedUpEntry(key, mvccEntry);
        return mvccEntry;
    }

    private MVCCEntry wrapMvccEntryForRemove(InvocationContext ctx, Object key, CacheEntry cacheEntry) {
        MVCCEntry mvccEntry = this.createWrappedEntry(key, cacheEntry, null, false, true);
        if (cacheEntry instanceof StateChangingEntry) {
            mvccEntry.copyStateFlagsFrom((StateChangingEntry)((Object)cacheEntry));
        }
        ctx.putLookedUpEntry(key, mvccEntry);
        return mvccEntry;
    }

    private MVCCEntry wrapEntry(InvocationContext ctx, Object key, Metadata providedMetadata) {
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        MVCCEntry mvccEntry = null;
        if (cacheEntry != null) {
            mvccEntry = this.wrapMvccEntryForPut(ctx, key, cacheEntry, providedMetadata);
        } else {
            InternalCacheEntry ice = this.getFromContainer(key);
            if (ice != null) {
                mvccEntry = this.wrapInternalCacheEntryForPut(ctx, ice.getKey(), ice, providedMetadata);
            }
        }
        if (mvccEntry != null) {
            mvccEntry.copyForUpdate(this.container, this.localModeWriteSkewCheck);
        }
        return mvccEntry;
    }

    protected MVCCEntry createWrappedEntry(Object key, CacheEntry cacheEntry, Metadata providedMetadata, boolean isForInsert, boolean forRemoval) {
        Metadata metadata;
        Object value;
        Object object = value = cacheEntry != null ? cacheEntry.getValue() : null;
        Metadata metadata2 = providedMetadata != null ? providedMetadata : (metadata = cacheEntry != null ? cacheEntry.getMetadata() : null);
        if (value == null && !isForInsert) {
            return this.useRepeatableRead ? (forRemoval ? new NullMarkerEntryForRemoval(key, metadata) : NullMarkerEntry.getInstance()) : null;
        }
        return this.useRepeatableRead ? new RepeatableReadEntry(key, value, metadata) : new ReadCommittedEntry(key, value, metadata);
    }

    private DeltaAwareCacheEntry newDeltaAwareCacheEntry(InvocationContext ctx, Object key, DeltaAware deltaAware) {
        DeltaAwareCacheEntry deltaEntry = this.createWrappedDeltaEntry(key, deltaAware, null);
        ctx.putLookedUpEntry(key, deltaEntry);
        return deltaEntry;
    }

    private DeltaAwareCacheEntry createWrappedDeltaEntry(Object key, DeltaAware deltaAware, CacheEntry entry) {
        return new DeltaAwareCacheEntry(key, deltaAware, entry);
    }
}

