/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import javax.transaction.Transaction;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.AbstractInvocationContextContainer;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.SingleKeyNonTxInvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.RemoteTransaction;

public class NonTransactionalInvocationContextContainer
extends AbstractInvocationContextContainer {
    @Override
    @Inject
    public void init(Configuration config) {
        super.init(config);
    }

    @Override
    @Start
    public void start() {
        super.start();
    }

    @Override
    public InvocationContext createInvocationContext(boolean isWrite, int keyCount) {
        if (keyCount == 1) {
            SingleKeyNonTxInvocationContext result = new SingleKeyNonTxInvocationContext(true, this.keyEq);
            this.ctxHolder.set(result);
            return result;
        }
        if (keyCount > 0) {
            NonTxInvocationContext ctx = new NonTxInvocationContext(keyCount, true, this.keyEq);
            this.ctxHolder.set(ctx);
            return ctx;
        }
        return this.createInvocationContext(null);
    }

    @Override
    public InvocationContext createInvocationContext(Transaction tx) {
        return this.createNonTxInvocationContext();
    }

    @Override
    public NonTxInvocationContext createNonTxInvocationContext() {
        NonTxInvocationContext ctx = new NonTxInvocationContext(this.keyEq);
        ctx.setOriginLocal(true);
        this.ctxHolder.set(ctx);
        return ctx;
    }

    @Override
    public InvocationContext createSingleKeyNonTxInvocationContext() {
        SingleKeyNonTxInvocationContext result = new SingleKeyNonTxInvocationContext(true, this.keyEq);
        this.ctxHolder.set(result);
        return result;
    }

    @Override
    public NonTxInvocationContext createRemoteInvocationContext(Address origin) {
        NonTxInvocationContext ctx = new NonTxInvocationContext(this.keyEq);
        ctx.setOrigin(origin);
        this.ctxHolder.set(ctx);
        return ctx;
    }

    @Override
    public LocalTxInvocationContext createTxInvocationContext() {
        throw this.exception();
    }

    @Override
    public RemoteTxInvocationContext createRemoteTxInvocationContext(RemoteTransaction tx, Address origin) {
        throw this.exception();
    }

    private IllegalStateException exception() {
        return new IllegalStateException("This is a non-transactional cache - why need to build a transactional context for it!");
    }
}

