/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Collection;
import java.util.List;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractEnlistmentAdapter {
    private static Log log = LogFactory.getLog(AbstractEnlistmentAdapter.class);
    private final CommandsFactory commandsFactory;
    private final RpcManager rpcManager;
    private final TransactionTable txTable;
    private final ClusteringDependentLogic clusteringLogic;
    private final int hashCode;
    private final boolean isSecondPhaseAsync;
    private final boolean isPessimisticLocking;
    private final boolean isTotalOrder;

    public AbstractEnlistmentAdapter(CacheTransaction cacheTransaction, CommandsFactory commandsFactory, RpcManager rpcManager, TransactionTable txTable, ClusteringDependentLogic clusteringLogic, Configuration configuration) {
        this.commandsFactory = commandsFactory;
        this.rpcManager = rpcManager;
        this.txTable = txTable;
        this.clusteringLogic = clusteringLogic;
        this.isSecondPhaseAsync = Configurations.isSecondPhaseAsync(configuration);
        this.isPessimisticLocking = configuration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
        this.isTotalOrder = configuration.transaction().transactionProtocol().isTotalOrder();
        this.hashCode = AbstractEnlistmentAdapter.preComputeHashCode(cacheTransaction);
    }

    public AbstractEnlistmentAdapter(CommandsFactory commandsFactory, RpcManager rpcManager, TransactionTable txTable, ClusteringDependentLogic clusteringLogic, Configuration configuration) {
        this.commandsFactory = commandsFactory;
        this.rpcManager = rpcManager;
        this.txTable = txTable;
        this.clusteringLogic = clusteringLogic;
        this.isSecondPhaseAsync = Configurations.isSecondPhaseAsync(configuration);
        this.isPessimisticLocking = configuration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
        this.isTotalOrder = configuration.transaction().transactionProtocol().isTotalOrder();
        this.hashCode = 31;
    }

    protected final void releaseLocksForCompletedTransaction(LocalTransaction localTransaction) {
        GlobalTransaction gtx = localTransaction.getGlobalTransaction();
        this.txTable.removeLocalTransaction(localTransaction);
        if (this.isClustered()) {
            this.removeTransactionInfoRemotely(localTransaction, gtx);
        }
    }

    private void removeTransactionInfoRemotely(LocalTransaction localTransaction, GlobalTransaction gtx) {
        if (this.mayHaveRemoteLocks(localTransaction) && !this.isSecondPhaseAsync) {
            TxCompletionNotificationCommand command = this.commandsFactory.buildTxCompletionNotificationCommand(null, gtx);
            List<Address> owners = this.clusteringLogic.getOwners(localTransaction.getAffectedKeys());
            Collection<Address> commitNodes = localTransaction.getCommitNodes(owners, this.rpcManager.getTopologyId(), this.rpcManager.getMembers());
            log.tracef("About to invoke tx completion notification on commitNodes: %s", commitNodes);
            this.rpcManager.invokeRemotely(commitNodes, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(false, false));
        }
    }

    private boolean mayHaveRemoteLocks(LocalTransaction lt) {
        return !this.isTotalOrder && (lt.getRemoteLocksAcquired() != null && !lt.getRemoteLocksAcquired().isEmpty() || !lt.getModifications().isEmpty() || this.isPessimisticLocking && lt.getTopologyId() != this.rpcManager.getTopologyId());
    }

    public final int hashCode() {
        return this.hashCode;
    }

    private static int preComputeHashCode(CacheTransaction cacheTx) {
        return 31 + cacheTx.hashCode();
    }

    private boolean isClustered() {
        return this.rpcManager != null;
    }
}

