/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.EntityConsumerLuceneWorkProducer;
import org.hibernate.search.batchindexing.impl.Executors;
import org.hibernate.search.batchindexing.impl.IdentifierConsumerEntityProducer;
import org.hibernate.search.batchindexing.impl.IdentifierProducer;
import org.hibernate.search.batchindexing.impl.OptionallyWrapInJTATransaction;
import org.hibernate.search.batchindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.batchindexing.impl.SessionAwareRunnable;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BatchIndexingWorkspace
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final SearchFactoryImplementor searchFactory;
    private final SessionFactory sessionFactory;
    private final ThreadPoolExecutor execIdentifiersLoader;
    private final ProducerConsumerQueue<List<Serializable>> fromIdentifierListToEntities;
    private final ThreadPoolExecutor execFirstLoader;
    private final ProducerConsumerQueue<List<?>> fromEntityToAddwork;
    private final ThreadPoolExecutor execDocBuilding;
    private final int objectLoadingThreadNum;
    private final int luceneWorkerBuildingThreadNum;
    private final Class<?> indexedType;
    private final String idNameOfIndexedType;
    private final CountDownLatch producerEndSignal;
    private final CountDownLatch endAllSignal;
    private final MassIndexerProgressMonitor monitor;
    private final CacheMode cacheMode;
    private final int objectLoadingBatchSize;
    private final BatchBackend backend;
    private final long objectsLimit;
    private final int idFetchSize;

    public BatchIndexingWorkspace(SearchFactoryImplementor searchFactoryImplementor, SessionFactory sessionFactory, Class<?> entityType, int objectLoadingThreads, int collectionLoadingThreads, CacheMode cacheMode, int objectLoadingBatchSize, CountDownLatch endAllSignal, MassIndexerProgressMonitor monitor, BatchBackend backend, long objectsLimit, int idFetchSize) {
        this.indexedType = entityType;
        this.idFetchSize = idFetchSize;
        this.idNameOfIndexedType = searchFactoryImplementor.getIndexBinding(entityType).getDocumentBuilder().getIdentifierName();
        this.searchFactory = searchFactoryImplementor;
        this.sessionFactory = sessionFactory;
        this.objectLoadingThreadNum = objectLoadingThreads;
        this.luceneWorkerBuildingThreadNum = collectionLoadingThreads;
        this.cacheMode = cacheMode;
        this.objectLoadingBatchSize = objectLoadingBatchSize;
        this.backend = backend;
        this.execIdentifiersLoader = Executors.newFixedThreadPool((int)1, (String)"identifierloader");
        this.execFirstLoader = Executors.newFixedThreadPool((int)this.objectLoadingThreadNum, (String)"entityloader");
        this.execDocBuilding = Executors.newFixedThreadPool((int)this.luceneWorkerBuildingThreadNum, (String)"collectionsloader");
        this.fromIdentifierListToEntities = new ProducerConsumerQueue(1);
        this.fromEntityToAddwork = new ProducerConsumerQueue(this.objectLoadingThreadNum);
        this.endAllSignal = endAllSignal;
        this.producerEndSignal = new CountDownLatch(this.luceneWorkerBuildingThreadNum);
        this.monitor = monitor;
        this.objectsLimit = objectsLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ErrorHandler errorHandler = this.searchFactory.getErrorHandler();
        try {
            SessionAwareRunnable producer;
            int i;
            for (i = 0; i < this.luceneWorkerBuildingThreadNum; ++i) {
                producer = new EntityConsumerLuceneWorkProducer(this.fromEntityToAddwork, this.monitor, this.sessionFactory, this.producerEndSignal, this.searchFactory, this.cacheMode, this.backend, errorHandler);
                this.execDocBuilding.execute(new OptionallyWrapInJTATransaction(this.sessionFactory, errorHandler, producer));
            }
            for (i = 0; i < this.objectLoadingThreadNum; ++i) {
                producer = new IdentifierConsumerEntityProducer(this.fromIdentifierListToEntities, this.fromEntityToAddwork, this.monitor, this.sessionFactory, this.cacheMode, this.indexedType, this.idNameOfIndexedType, errorHandler);
                this.execFirstLoader.execute(new OptionallyWrapInJTATransaction(this.sessionFactory, errorHandler, producer));
            }
            IdentifierProducer producer2 = new IdentifierProducer(this.fromIdentifierListToEntities, this.sessionFactory, this.objectLoadingBatchSize, this.indexedType, this.monitor, this.objectsLimit, errorHandler, this.idFetchSize);
            this.execIdentifiersLoader.execute(new OptionallyWrapInJTATransaction(this.sessionFactory, errorHandler, producer2));
            this.execIdentifiersLoader.shutdown();
            this.execFirstLoader.shutdown();
            this.execDocBuilding.shutdown();
            try {
                this.producerEndSignal.await();
                log.debugf("All work for type %s has been produced", (Object)this.indexedType.getName());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SearchException("Interrupted on batch Indexing; index will be left in unknown state!", (Throwable)e);
            }
        }
        catch (RuntimeException re) {
            errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), (Throwable)re);
        }
        finally {
            this.endAllSignal.countDown();
        }
    }
}

