/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.util.Date;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class SolrRequestInfo {
    protected static final ThreadLocal<SolrRequestInfo> threadLocal = new ThreadLocal();
    protected SolrQueryRequest req;
    protected SolrQueryResponse rsp;
    protected Date now;
    protected ResponseBuilder rb;

    public static SolrRequestInfo getRequestInfo() {
        return threadLocal.get();
    }

    public static void setRequestInfo(SolrRequestInfo info) {
        SolrRequestInfo prev = threadLocal.get();
        if (prev != null) {
            SolrCore.log.error("Previous SolrRequestInfo was not closed!  req=" + prev.req.getOriginalParams().toString());
        }
        assert (prev == null);
        threadLocal.set(info);
    }

    public static void clearRequestInfo() {
        threadLocal.remove();
    }

    public SolrRequestInfo(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.req = req;
        this.rsp = rsp;
    }

    public Date getNOW() {
        if (this.now != null) {
            return this.now;
        }
        long ms = 0L;
        String nowStr = this.req.getParams().get("NOW");
        ms = nowStr != null ? Long.parseLong(nowStr) : this.req.getStartTime();
        this.now = new Date(ms);
        return this.now;
    }

    public SolrQueryRequest getReq() {
        return this.req;
    }

    public SolrQueryResponse getRsp() {
        return this.rsp;
    }

    public ResponseBuilder getResponseBuilder() {
        return this.rb;
    }

    public void setResponseBuilder(ResponseBuilder rb) {
        this.rb = rb;
    }
}

