/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.SolrIndexConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexWriter
extends IndexWriter {
    private static Logger log = LoggerFactory.getLogger(SolrIndexWriter.class);
    public static final String LOCK_TYPE_SIMPLE = "simple";
    public static final String LOCK_TYPE_NATIVE = "native";
    public static final String LOCK_TYPE_SINGLE = "single";
    public static final String LOCK_TYPE_NONE = "none";
    String name;
    private PrintStream infoStream;
    private volatile boolean isClosed = false;

    public static Directory getDirectory(String path, DirectoryFactory directoryFactory, SolrIndexConfig config) throws IOException {
        Directory d = directoryFactory.open(path);
        String rawLockType = config.lockType;
        String lockType = rawLockType.toLowerCase(Locale.ENGLISH).trim();
        if (LOCK_TYPE_SIMPLE.equals(lockType)) {
            d.setLockFactory((LockFactory)new SimpleFSLockFactory(path));
        } else if (LOCK_TYPE_NATIVE.equals(lockType)) {
            d.setLockFactory((LockFactory)new NativeFSLockFactory(path));
        } else if (LOCK_TYPE_SINGLE.equals(lockType)) {
            if (!(d.getLockFactory() instanceof SingleInstanceLockFactory)) {
                d.setLockFactory((LockFactory)new SingleInstanceLockFactory());
            }
        } else if (LOCK_TYPE_NONE.equals(lockType)) {
            log.error("CONFIGURATION WARNING: locks are disabled on " + path);
            d.setLockFactory((LockFactory)NoLockFactory.getNoLockFactory());
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized lockType: " + rawLockType);
        }
        return d;
    }

    public SolrIndexWriter(String name, String path, DirectoryFactory dirFactory, boolean create, IndexSchema schema, SolrIndexConfig config, IndexDeletionPolicy delPolicy) throws IOException {
        super(SolrIndexWriter.getDirectory(path, dirFactory, config), config.toIndexWriterConfig(schema).setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND).setIndexDeletionPolicy(delPolicy));
        if (config.maxFieldLength != -1) {
            this.setMaxFieldLength(config.maxFieldLength);
        }
        log.debug("Opened Writer " + name);
        this.name = name;
        String infoStreamFile = config.infoStreamFile;
        if (infoStreamFile != null) {
            File f = new File(infoStreamFile);
            File parent = f.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(f, true);
            this.infoStream = new TimeLoggingPrintStream(fos, true);
            this.setInfoStream(this.infoStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        log.debug("Closing Writer " + this.name);
        try {
            super.close();
            if (this.infoStream != null) {
                this.infoStream.close();
            }
            Object var2_1 = null;
            this.isClosed = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.isClosed = true;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IOException {
        try {
            super.rollback();
            Object var2_1 = null;
            this.isClosed = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.isClosed = true;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed) {
                log.error("SolrIndexWriter was not closed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.close();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    class TimeLoggingPrintStream
    extends PrintStream {
        private DateFormat dateFormat;

        public TimeLoggingPrintStream(OutputStream underlyingOutputStream, boolean autoFlush) {
            super(underlyingOutputStream, autoFlush);
            this.dateFormat = DateFormat.getDateTimeInstance();
        }

        public void println(String x) {
            this.print(this.dateFormat.format(new Date()) + " ");
            super.println(x);
        }
    }
}

