/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.works.AddWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkDelegate;
import org.hibernate.search.backend.impl.lucene.works.UpdateWorkDelegate;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ByTermUpdateWorkDelegate
extends UpdateWorkDelegate {
    private static final Log log = LoggerFactory.make();
    private final AddWorkDelegate addDelegate;
    private final Workspace workspace;

    ByTermUpdateWorkDelegate(Workspace workspace, AddWorkDelegate addDelegate) {
        super(null, null);
        this.workspace = workspace;
        this.addDelegate = addDelegate;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer, IndexingMonitor monitor) {
        Serializable id = work.getId();
        Class<?> managedType = work.getEntityClass();
        DocumentBuilderIndexedEntity<?> builder = this.workspace.getDocumentBuilder(managedType);
        try {
            if (DeleteWorkDelegate.isIdNumeric(builder)) {
                log.tracef("Deleting %s#%s by query using an IndexWriter#updateDocument as id is Numeric", managedType, id);
                writer.deleteDocuments(NumericFieldUtils.createExactMatchQuery(builder.getIdKeywordName(), id));
                this.addDelegate.performWork(work, writer, monitor);
            } else {
                log.tracef("Updating %s#%s by id using an IndexWriter#updateDocument.", managedType, id);
                Term idTerm = new Term(builder.getIdKeywordName(), work.getIdInString());
                Map<String, String> fieldToAnalyzerMap = work.getFieldToAnalyzerMap();
                ScopedAnalyzer analyzer = builder.getAnalyzer();
                analyzer = AddWorkDelegate.updateAnalyzerMappings(this.workspace, analyzer, fieldToAnalyzerMap);
                writer.updateDocument(idTerm, work.getDocument(), (Analyzer)analyzer);
            }
            this.workspace.notifyWorkApplied(work);
        }
        catch (Exception e) {
            String message = "Unable to update " + managedType + "#" + id + " in index.";
            throw new SearchException(message, e);
        }
        if (monitor != null) {
            monitor.documentsAdded(1L);
        }
    }
}

