/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.impl.DelegatingClassLoaderService;
import org.hibernate.search.cfg.impl.HibernateCoreIdUniquenessResolver;
import org.hibernate.search.cfg.spi.IdUniquenessResolver;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.cfg.spi.SearchConfigurationBase;
import org.hibernate.search.engine.impl.HibernateStatelessInitializer;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.spi.InstanceInitializer;

public class SearchConfigurationFromHibernateCore
extends SearchConfigurationBase
implements SearchConfiguration {
    private final Configuration cfg;
    private final org.hibernate.search.engine.service.classloading.spi.ClassLoaderService classLoaderService;
    private final Map<Class<? extends Service>, Object> providedServices;
    private ReflectionManager reflectionManager;

    public SearchConfigurationFromHibernateCore(Configuration cfg, ClassLoaderService hibernateClassLoaderService) {
        if (cfg == null) {
            throw new NullPointerException("Configuration is null");
        }
        this.cfg = cfg;
        if (hibernateClassLoaderService == null) {
            throw new NullPointerException("ClassLoaderService is null");
        }
        this.classLoaderService = new DelegatingClassLoaderService(hibernateClassLoaderService);
        HashMap<Class<IdUniquenessResolver>, HibernateCoreIdUniquenessResolver> providedServices = new HashMap<Class<IdUniquenessResolver>, HibernateCoreIdUniquenessResolver>(1);
        providedServices.put(IdUniquenessResolver.class, new HibernateCoreIdUniquenessResolver(cfg));
        this.providedServices = Collections.unmodifiableMap(providedServices);
    }

    public Iterator<Class<?>> getClassMappings() {
        return new ClassIterator(this.cfg.getClassMappings());
    }

    public Class<?> getClassMapping(String name) {
        return this.cfg.getClassMapping(name).getMappedClass();
    }

    public String getProperty(String propertyName) {
        return this.cfg.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.cfg.getProperties();
    }

    public ReflectionManager getReflectionManager() {
        if (this.reflectionManager == null) {
            try {
                this.reflectionManager = (ReflectionManager)this.cfg.getClass().getMethod("getReflectionManager", new Class[0]).invoke((Object)this.cfg, new Object[0]);
            }
            catch (Exception e) {
                this.reflectionManager = new JavaReflectionManager();
            }
        }
        return this.reflectionManager;
    }

    public SearchMapping getProgrammaticMapping() {
        return null;
    }

    public Map<Class<? extends Service>, Object> getProvidedServices() {
        return this.providedServices;
    }

    public InstanceInitializer getInstanceInitializer() {
        return HibernateStatelessInitializer.INSTANCE;
    }

    public boolean isIndexMetadataComplete() {
        return true;
    }

    public org.hibernate.search.engine.service.classloading.spi.ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    private static class ClassIterator
    implements Iterator<Class<?>> {
        private Iterator hibernatePersistentClassIterator;
        private Class<?> future;

        private ClassIterator(Iterator hibernatePersistentClassIterator) {
            this.hibernatePersistentClassIterator = hibernatePersistentClassIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.future != null) {
                return true;
            }
            do {
                if (!this.hibernatePersistentClassIterator.hasNext()) {
                    this.future = null;
                    return false;
                }
                PersistentClass pc = (PersistentClass)this.hibernatePersistentClassIterator.next();
                this.future = pc.getMappedClass();
            } while (this.future == null);
            return true;
        }

        @Override
        public Class<?> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Class<?> result = this.future;
            this.future = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot modify Hibernate Core metadata");
        }
    }
}

