/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantLock;

final class MultiWriteDrainableLinkedList<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private Node<T> first = null;
    private Node<T> last = null;

    MultiWriteDrainableLinkedList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(T element) {
        Node<T> newnode = new Node<T>(element);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.first == null) {
                this.first = newnode;
                this.last = newnode;
            } else {
                this.last.next = newnode;
                this.last = newnode;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterable<T> drainToDetachedIterable() {
        Node<T> head;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            head = this.first;
            this.first = null;
            this.last = null;
        }
        finally {
            lock.unlock();
        }
        if (head != null) {
            return new DetachedNodeIterable<T>(head);
        }
        return null;
    }

    static final class DetachedNodeIterator<T>
    implements Iterator<T> {
        private Node<T> current;

        DetachedNodeIterator(Node head) {
            this.current = head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object v = this.current.value;
            this.current = this.current.next;
            return v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator is unable to remove elements");
        }
    }

    static final class DetachedNodeIterable<T>
    implements Iterable<T> {
        private Node<T> head;

        public DetachedNodeIterable(Node<T> head) {
            this.head = head;
        }

        @Override
        public Iterator<T> iterator() {
            return new DetachedNodeIterator(this.head);
        }
    }

    static final class Node<T> {
        T value;
        Node<T> next;

        Node(T x) {
            this.value = x;
        }
    }
}

