/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.FieldComparator;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public final class DistanceComparator
extends FieldComparator<Double> {
    private final Point center;
    private final String latitudeField;
    private final String longitudeField;
    private double[] distances;
    private NumericDocValues latitudeValues;
    private NumericDocValues longitudeValues;
    private Double bottomDistance;
    private Double topValue;

    public DistanceComparator(Point center, int numHits, String fieldName) {
        this.center = center;
        this.distances = new double[numHits];
        this.latitudeField = SpatialHelper.formatLatitude(fieldName);
        this.longitudeField = SpatialHelper.formatLongitude(fieldName);
    }

    public int compare(int slot1, int slot2) {
        return Double.compare(this.distances[slot1], this.distances[slot2]);
    }

    public void setBottom(int slot) {
        this.bottomDistance = this.distances[slot];
    }

    public void setTopValue(Double value) {
        this.topValue = value;
    }

    public int compareBottom(int doc) throws IOException {
        return Double.compare(this.bottomDistance, this.center.getDistanceTo(this.latitude(doc), this.longitude(doc)));
    }

    private double longitude(int doc) {
        return Double.longBitsToDouble(this.longitudeValues.get(doc));
    }

    private double latitude(int doc) {
        return Double.longBitsToDouble(this.latitudeValues.get(doc));
    }

    public int compareTop(int doc) throws IOException {
        if (this.topValue == null) {
            return 1;
        }
        double distanceTo = this.center.getDistanceTo(this.latitude(doc), this.longitude(doc));
        return Double.compare(distanceTo, this.topValue);
    }

    public void copy(int slot, int doc) throws IOException {
        this.distances[slot] = this.center.getDistanceTo(this.latitude(doc), this.longitude(doc));
    }

    public DistanceComparator setNextReader(AtomicReaderContext context) throws IOException {
        AtomicReader atomicReader = context.reader();
        this.latitudeValues = atomicReader.getNumericDocValues(this.latitudeField);
        this.longitudeValues = atomicReader.getNumericDocValues(this.longitudeField);
        return this;
    }

    public Double value(int slot) {
        return this.distances[slot];
    }
}

