/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.CoordinateHelper;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public class DistanceCollector
extends Collector {
    private final Point center;
    private final boolean acceptsDocsOutOfOrder;
    private final Collector delegate;
    private final SpatialResultsCollector distances;
    private final String latitudeField;
    private final String longitudeField;
    private int docBase = 0;
    private NumericDocValues latitudeValues;
    private NumericDocValues longitudeValues;

    public DistanceCollector(Collector delegate, Coordinates centerCoordinates, int hitsCount, String fieldname) {
        this.delegate = delegate;
        this.acceptsDocsOutOfOrder = delegate.acceptsDocsOutOfOrder();
        this.center = Point.fromCoordinates(centerCoordinates);
        this.distances = new SpatialResultsCollector(hitsCount);
        this.latitudeField = SpatialHelper.formatLatitude(fieldname);
        this.longitudeField = SpatialHelper.formatLongitude(fieldname);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.delegate.setScorer(scorer);
    }

    public void collect(int doc) throws IOException {
        this.delegate.collect(doc);
        int absolute = this.docBase + doc;
        double lat = CoordinateHelper.coordinate(this.latitudeValues, doc);
        double lon = CoordinateHelper.coordinate(this.longitudeValues, doc);
        this.distances.put(absolute, lat, lon);
    }

    public void setNextReader(AtomicReaderContext newContext) throws IOException {
        this.delegate.setNextReader(newContext);
        AtomicReader atomicReader = newContext.reader();
        this.latitudeValues = atomicReader.getNumericDocValues(this.latitudeField);
        this.longitudeValues = atomicReader.getNumericDocValues(this.longitudeField);
        this.docBase = newContext.docBase;
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.acceptsDocsOutOfOrder;
    }

    public double getDistance(int index) {
        return this.distances.get(index, this.center);
    }

    private static class SpatialResultsCollector {
        final ArrayList<HitEntry> orderedEntries;
        int currentIterator = 0;

        private SpatialResultsCollector(int size) {
            this.orderedEntries = new ArrayList(size);
        }

        public double get(int index, Point center) {
            HitEntry currentEntry;
            int startingPoint = this.currentIterator;
            while (this.currentIterator < this.orderedEntries.size() && (currentEntry = this.orderedEntries.get(this.currentIterator)) != null) {
                if (currentEntry.documentId == index) {
                    return currentEntry.getDistance(center);
                }
                ++this.currentIterator;
            }
            this.currentIterator = 0;
            while (this.currentIterator < startingPoint && (currentEntry = this.orderedEntries.get(this.currentIterator)) != null) {
                if (currentEntry.documentId == index) {
                    return currentEntry.getDistance(center);
                }
                ++this.currentIterator;
            }
            throw new SearchException("Unexpected index: this documentId was not collected");
        }

        void put(int documentId, double latitude, double longitude) {
            this.orderedEntries.add(new HitEntry(documentId, latitude, longitude));
        }
    }

    private static class HitEntry {
        int documentId;
        double latitude;
        double longitude;

        private HitEntry(int documentId, double latitude, double longitude) {
            this.documentId = documentId;
            this.latitude = latitude;
            this.longitude = longitude;
        }

        double getDistance(Point center) {
            return center.getDistanceTo(this.latitude, this.longitude);
        }
    }
}

