/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.standard.std40.UAX29URLEmailTokenizer40;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.util.Version;

public final class UAX29URLEmailAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    public static final CharArraySet STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;

    public UAX29URLEmailAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public UAX29URLEmailAnalyzer() {
        this(STOP_WORDS_SET);
    }

    public UAX29URLEmailAnalyzer(Reader stopwords) throws IOException {
        this(UAX29URLEmailAnalyzer.loadStopwordSet(stopwords));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer src;
        if (this.getVersion().onOrAfter(Version.LUCENE_4_7_0)) {
            src = new UAX29URLEmailTokenizer();
            ((UAX29URLEmailTokenizer)src).setMaxTokenLength(this.maxTokenLength);
        } else {
            src = new UAX29URLEmailTokenizer40();
            ((UAX29URLEmailTokenizer40)src).setMaxTokenLength(this.maxTokenLength);
        }
        TokenFilter tok = new StandardFilter((TokenStream)src);
        tok = new LowerCaseFilter((TokenStream)tok);
        tok = new StopFilter((TokenStream)tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(src, (TokenStream)tok){

            protected void setReader(Reader reader) throws IOException {
                int m = UAX29URLEmailAnalyzer.this.maxTokenLength;
                if (src instanceof UAX29URLEmailTokenizer) {
                    ((UAX29URLEmailTokenizer)src).setMaxTokenLength(m);
                } else {
                    ((UAX29URLEmailTokenizer40)src).setMaxTokenLength(m);
                }
                super.setReader(reader);
            }
        };
    }
}

