/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.util.impl;

import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.Year;
import java.util.Calendar;
import java.util.Date;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class NumericFieldUtils {
    private static final String JAVA_TIME_DURATION = "java.time.Duration";
    private static final String JAVA_TIME_YEAR = "java.time.Year";
    private static final String JAVA_TIME_INSTANT = "java.time.Instant";
    private static final Log log = LoggerFactory.make();

    private NumericFieldUtils() {
    }

    public static Query createNumericRangeQuery(String fieldName, Object from, Object to, boolean includeLower, boolean includeUpper) {
        Class<Serializable> numericClass;
        if (from != null) {
            numericClass = from.getClass();
        } else if (to != null) {
            numericClass = to.getClass();
        } else {
            throw log.rangeQueryWithNullToAndFromValue(fieldName);
        }
        if (numericClass.isAssignableFrom(Double.class)) {
            return NumericRangeQuery.newDoubleRange((String)fieldName, (Double)((Double)from), (Double)((Double)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Byte.class)) {
            return NumericRangeQuery.newIntRange((String)fieldName, (Integer)((Byte)from).intValue(), (Integer)((Byte)to).intValue(), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Short.class)) {
            return NumericRangeQuery.newIntRange((String)fieldName, (Integer)((Short)from).intValue(), (Integer)((Short)to).intValue(), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Long.class)) {
            return NumericRangeQuery.newLongRange((String)fieldName, (Long)((Long)from), (Long)((Long)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Integer.class)) {
            return NumericRangeQuery.newIntRange((String)fieldName, (Integer)((Integer)from), (Integer)((Integer)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Float.class)) {
            return NumericRangeQuery.newFloatRange((String)fieldName, (Float)((Float)from), (Float)((Float)to), (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Date.class)) {
            Long fromValue = from != null ? Long.valueOf(((Date)from).getTime()) : null;
            Long toValue = to != null ? Long.valueOf(((Date)to).getTime()) : null;
            return NumericRangeQuery.newLongRange((String)fieldName, (Long)fromValue, (Long)toValue, (boolean)includeLower, (boolean)includeUpper);
        }
        if (numericClass.isAssignableFrom(Calendar.class)) {
            Long fromValue = from != null ? Long.valueOf(((Calendar)from).getTime().getTime()) : null;
            Long toValue = to != null ? Long.valueOf(((Calendar)to).getTime().getTime()) : null;
            return NumericRangeQuery.newLongRange((String)fieldName, (Long)fromValue, (Long)toValue, (boolean)includeLower, (boolean)includeUpper);
        }
        if (NumericFieldUtils.isAssignableFrom(numericClass, JAVA_TIME_DURATION)) {
            Long fromValue = from != null ? Long.valueOf(((Duration)from).toNanos()) : null;
            Long toValue = to != null ? Long.valueOf(((Duration)to).toNanos()) : null;
            return NumericRangeQuery.newLongRange((String)fieldName, (Long)fromValue, (Long)toValue, (boolean)includeLower, (boolean)includeUpper);
        }
        if (NumericFieldUtils.isAssignableFrom(numericClass, JAVA_TIME_YEAR)) {
            Integer fromValue = from != null ? Integer.valueOf(((Year)from).getValue()) : null;
            Integer toValue = to != null ? Integer.valueOf(((Year)to).getValue()) : null;
            return NumericRangeQuery.newIntRange((String)fieldName, (Integer)fromValue, (Integer)toValue, (boolean)includeLower, (boolean)includeUpper);
        }
        if (NumericFieldUtils.isAssignableFrom(numericClass, JAVA_TIME_INSTANT)) {
            Long fromValue = from != null ? Long.valueOf(((Instant)from).toEpochMilli()) : null;
            Long toValue = to != null ? Long.valueOf(((Instant)to).toEpochMilli()) : null;
            return NumericRangeQuery.newLongRange((String)fieldName, (Long)fromValue, (Long)toValue, (boolean)includeLower, (boolean)includeUpper);
        }
        throw log.numericRangeQueryWithNonNumericToAndFromValues(fieldName);
    }

    private static boolean isAssignableFrom(Class<?> numericClass, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return numericClass.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Query createExactMatchQuery(String fieldName, Object value) {
        return NumericFieldUtils.createNumericRangeQuery(fieldName, value, value, true, true);
    }

    public static boolean requiresNumericRangeQuery(Object value) {
        if (value == null) {
            return false;
        }
        Class<Serializable> numericClass = value.getClass();
        return numericClass.isAssignableFrom(Double.class) || numericClass.isAssignableFrom(Long.class) || numericClass.isAssignableFrom(Integer.class) || numericClass.isAssignableFrom(Float.class) || numericClass.isAssignableFrom(Calendar.class) || NumericFieldUtils.isAssignableFrom(numericClass, JAVA_TIME_INSTANT) || NumericFieldUtils.isAssignableFrom(numericClass, JAVA_TIME_YEAR) || NumericFieldUtils.isAssignableFrom(numericClass, JAVA_TIME_DURATION);
    }
}

