/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.util.impl;

import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.AppliedOnTypeAwareBridge;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;

public class String2FieldBridgeAdaptor
implements FieldBridge,
StringBridge,
AppliedOnTypeAwareBridge {
    private final StringBridge stringBridge;

    public String2FieldBridgeAdaptor(StringBridge stringBridge) {
        this.stringBridge = stringBridge;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        String indexedString = this.stringBridge.objectToString(value);
        if (indexedString == null && luceneOptions.indexNullAs() != null) {
            indexedString = luceneOptions.indexNullAs();
        }
        luceneOptions.addFieldToDocument(name, indexedString, document);
    }

    @Override
    public String objectToString(Object object) {
        return this.stringBridge.objectToString(object);
    }

    public String toString() {
        return "String2FieldBridgeAdaptor [stringBridge=" + this.stringBridge + "]";
    }

    @Override
    public void setAppliedOnType(Class<?> returnType) {
        if (this.stringBridge instanceof AppliedOnTypeAwareBridge) {
            ((AppliedOnTypeAwareBridge)((Object)this.stringBridge)).setAppliedOnType(returnType);
        }
    }
}

