/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.Map;
import java.util.Properties;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultElasticsearchSchemaMigrator
implements ElasticsearchSchemaMigrator,
Startable,
Stoppable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private ServiceManager serviceManager;
    private ElasticsearchSchemaAccessor schemaAccessor;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.schemaAccessor = (ElasticsearchSchemaAccessor)this.serviceManager.requestService(ElasticsearchSchemaAccessor.class);
    }

    public void stop() {
        this.schemaAccessor = null;
        this.serviceManager.releaseService(ElasticsearchSchemaAccessor.class);
        this.serviceManager = null;
    }

    @Override
    public void merge(IndexMetadata indexMetadata, ExecutionOptions executionOptions) {
        String indexName = indexMetadata.getName();
        try {
            for (Map.Entry<String, TypeMapping> entry : indexMetadata.getMappings().entrySet()) {
                String mappingName = entry.getKey();
                TypeMapping mapping = entry.getValue();
                this.schemaAccessor.putMapping(indexName, mappingName, mapping);
            }
        }
        catch (SearchException e) {
            throw LOG.schemaMergeFailed(indexName, (Exception)((Object)e));
        }
    }
}

