/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.spi.ScopedAnalyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;

public class ScopedElasticsearchAnalyzer
implements ElasticsearchAnalyzer,
ScopedAnalyzer {
    private final ElasticsearchAnalyzer globalAnalyzer;
    private final Map<String, ElasticsearchAnalyzer> scopedAnalyzers;

    public ScopedElasticsearchAnalyzer(ElasticsearchAnalyzer globalAnalyzer) {
        this(globalAnalyzer, Collections.emptyMap());
    }

    public ScopedElasticsearchAnalyzer(ElasticsearchAnalyzer globalAnalyzer, Map<String, ElasticsearchAnalyzer> scopedAnalyzers) {
        this.globalAnalyzer = globalAnalyzer;
        this.scopedAnalyzers = Collections.unmodifiableMap(new HashMap<String, ElasticsearchAnalyzer>(scopedAnalyzers));
    }

    ElasticsearchAnalyzer getGlobalAnalyzer() {
        return this.globalAnalyzer;
    }

    Map<String, ElasticsearchAnalyzer> getScopedAnalyzers() {
        return this.scopedAnalyzers;
    }

    private ElasticsearchAnalyzer getDelegate(String fieldName) {
        ElasticsearchAnalyzer analyzer = this.scopedAnalyzers.get(fieldName);
        if (analyzer == null) {
            analyzer = this.globalAnalyzer;
        }
        return analyzer;
    }

    public String getName(String fieldName) {
        return this.getDelegate(fieldName).getName(fieldName);
    }

    @Override
    public AnalyzerDef getDefinition(String fieldName) {
        return this.getDelegate(fieldName).getDefinition(fieldName);
    }

    @Override
    public Class<?> getLuceneClass(String fieldName) {
        return this.getDelegate(fieldName).getLuceneClass(fieldName);
    }

    public void close() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append(this.globalAnalyzer);
        sb.append(",");
        sb.append(this.scopedAnalyzers);
        sb.append(">");
        return sb.toString();
    }
}

