/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.hibernate.search.elasticsearch.settings.impl.FileAsLineArrayParameterValueTransformer;
import org.hibernate.search.exception.SearchException;

public class CharMappingRuleFileParameterValueTransformer
extends FileAsLineArrayParameterValueTransformer {
    private static final Pattern PATTERN = Pattern.compile("\"(.*)\"\\s*=>\\s*\"(.*)\"\\s*$");

    public CharMappingRuleFileParameterValueTransformer(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    @Override
    protected List<String> getLines(InputStream stream) throws IOException {
        List lines = WordlistLoader.getLines((InputStream)stream, (Charset)StandardCharsets.UTF_8);
        ListIterator<String> it = lines.listIterator();
        while (it.hasNext()) {
            String line = (String)it.next();
            Matcher matcher = PATTERN.matcher(line);
            if (matcher.matches()) {
                line = matcher.group(1) + " => " + matcher.group(2);
                it.set(line);
                continue;
            }
            throw new SearchException("Invalid rule syntax: " + line);
        }
        return lines;
    }
}

