/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.searchbox.action.Action;
import io.searchbox.action.DocumentTargetedAction;
import io.searchbox.client.JestResult;
import io.searchbox.core.BulkResult;
import java.util.Properties;
import org.hibernate.search.elasticsearch.impl.GsonService;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.spi.BuildContext;

public class JestAPIFormatter
implements Service,
Startable,
Stoppable {
    private ServiceManager serviceManager;
    private GsonService gsonService;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.gsonService = (GsonService)this.serviceManager.requestService(GsonService.class);
    }

    public void stop() {
        this.gsonService = null;
        this.serviceManager.releaseService(GsonService.class);
        this.serviceManager = null;
    }

    public String formatRequest(Action<?> action) {
        StringBuilder sb = new StringBuilder();
        sb.append("Operation: ").append(action.getClass().getSimpleName()).append("\n");
        sb.append("URI:").append(action.getURI()).append("\n");
        if (action instanceof DocumentTargetedAction) {
            sb.append("Index: ").append(((DocumentTargetedAction)action).getIndex()).append("\n");
            sb.append("Type: ").append(((DocumentTargetedAction)action).getType()).append("\n");
            sb.append("Id: ").append(((DocumentTargetedAction)action).getId()).append("\n");
        }
        sb.append("Data:\n");
        sb.append(this.formatRequestData(action));
        sb.append("\n");
        return sb.toString();
    }

    public String formatRequestData(Action<?> search) {
        Gson gson = this.gsonService.getGson();
        String data = search.getData(gson);
        try {
            gson = this.gsonService.getGsonPrettyPrinting();
            JsonElement tree = (JsonElement)gson.fromJson(data, JsonElement.class);
            return gson.toJson(tree);
        }
        catch (JsonParseException e) {
            return data;
        }
    }

    public String formatResult(JestResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Status: ").append(result.getResponseCode()).append("\n");
        sb.append("Error message: ").append(result.getErrorMessage()).append("\n");
        sb.append("Cluster name: ").append(this.property(result, "cluster_name")).append("\n");
        sb.append("Cluster status: ").append(this.property(result, "status")).append("\n");
        sb.append("\n");
        if (result instanceof BulkResult) {
            for (BulkResult.BulkResultItem item : ((BulkResult)result).getItems()) {
                sb.append("Operation: ").append(item.operation).append("\n");
                sb.append("  Index: ").append(item.index).append("\n");
                sb.append("  Type: ").append(item.type).append("\n");
                sb.append("  Id: ").append(item.id).append("\n");
                sb.append("  Status: ").append(item.status).append("\n");
                sb.append("  Error: ").append(item.error).append("\n");
            }
        }
        return sb.toString();
    }

    private String property(JestResult result, String name) {
        if (result.getJsonObject() == null) {
            return null;
        }
        JsonElement propretyValue = result.getJsonObject().get(name);
        if (propretyValue == null) {
            return null;
        }
        return propretyValue.getAsString();
    }
}

