/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.nulls.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.elasticsearch.nulls.impl.ElasticsearchNullMarkerField;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;

abstract class ElasticsearchNullMarkerCodec
implements NullMarkerCodec {
    protected final NullMarker nullMarker;

    public ElasticsearchNullMarkerCodec(NullMarker nullMarker) {
        this.nullMarker = nullMarker;
    }

    public NullMarker getNullMarker() {
        return this.nullMarker;
    }

    public void encodeNullValue(String fieldName, Document document, LuceneOptions luceneOptions) {
        document.add((IndexableField)new ElasticsearchNullMarkerField(fieldName, this.nullMarker));
    }

    public boolean representsNullValue(IndexableField field) {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.nullMarker + "]";
    }
}

