/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.definition.impl;

import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.search.analyzer.definition.LuceneAnalyzerDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneAnalyzerDefinitionWithTokenizerContext;
import org.hibernate.search.analyzer.definition.LuceneCharFilterDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneTokenFilterDefinitionContext;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalysisDefinitionBuilder;
import org.hibernate.search.analyzer.definition.impl.ParametersBuilder;
import org.hibernate.search.annotations.CharFilterDef;

public class LuceneCharFilterDefinitionContextImpl
implements LuceneCharFilterDefinitionContext,
LuceneAnalysisDefinitionBuilder<CharFilterDef> {
    private final LuceneAnalyzerDefinitionWithTokenizerContext analyzerContext;
    private final Class<? extends CharFilterFactory> factoryClass;
    private final ParametersBuilder params = new ParametersBuilder();

    public LuceneCharFilterDefinitionContextImpl(LuceneAnalyzerDefinitionWithTokenizerContext analyzerContext, Class<? extends CharFilterFactory> factoryClass) {
        this.analyzerContext = analyzerContext;
        this.factoryClass = factoryClass;
    }

    @Override
    public LuceneCharFilterDefinitionContext param(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    @Override
    public LuceneAnalyzerDefinitionContext analyzer(String name) {
        return this.analyzerContext.analyzer(name);
    }

    @Override
    public LuceneCharFilterDefinitionContext charFilter(Class<? extends CharFilterFactory> factory) {
        return this.analyzerContext.charFilter(factory);
    }

    @Override
    public LuceneTokenFilterDefinitionContext tokenFilter(Class<? extends TokenFilterFactory> factory) {
        return this.analyzerContext.tokenFilter(factory);
    }

    @Override
    public CharFilterDef build() {
        AnnotationDescriptor descriptor = new AnnotationDescriptor(CharFilterDef.class);
        descriptor.setValue("factory", this.factoryClass);
        descriptor.setValue("params", (Object)this.params.build());
        return (CharFilterDef)AnnotationFactory.create((AnnotationDescriptor)descriptor);
    }
}

