/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.util.Bits;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.CoordinateHelper;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public final class DistanceFilter
extends Filter {
    private Filter previousFilter;
    private Point center;
    private double radius;
    private String coordinatesField;
    private String latitudeField;
    private String longitudeField;

    public DistanceFilter(Filter previousFilter, Coordinates centerCoordinates, double radius, String coordinatesField) {
        this.previousFilter = previousFilter != null ? previousFilter : new QueryWrapperFilter((Query)new MatchAllDocsQuery());
        this.center = Point.fromCoordinates(centerCoordinates);
        this.radius = radius;
        this.coordinatesField = coordinatesField;
    }

    public DistanceFilter(Filter previousFilter, Coordinates centerCoordinates, double radius, String latitudeField, String longitudeField) {
        this.previousFilter = previousFilter != null ? previousFilter : new QueryWrapperFilter((Query)new MatchAllDocsQuery());
        this.center = Point.fromCoordinates(centerCoordinates);
        this.radius = radius;
        this.coordinatesField = null;
        this.latitudeField = latitudeField;
        this.longitudeField = longitudeField;
    }

    public DocIdSet getDocIdSet(LeafReaderContext context, Bits acceptDocs) throws IOException {
        LeafReader atomicReader = context.reader();
        DocIdSet docs = this.previousFilter.getDocIdSet(context, acceptDocs);
        if (docs == null || docs.iterator() == null) {
            return null;
        }
        final Bits docsWithLatitude = DocValues.getDocsWithField((LeafReader)atomicReader, (String)this.getLatitudeField());
        final Bits docsWithLongitude = DocValues.getDocsWithField((LeafReader)atomicReader, (String)this.getLongitudeField());
        final NumericDocValues latitudeValues = DocValues.getNumeric((LeafReader)atomicReader, (String)this.getLatitudeField());
        final NumericDocValues longitudeValues = DocValues.getNumeric((LeafReader)atomicReader, (String)this.getLongitudeField());
        return new FilteredDocIdSet(docs){

            protected boolean match(int documentIndex) {
                if (docsWithLatitude.get(documentIndex) && docsWithLongitude.get(documentIndex)) {
                    double lat = CoordinateHelper.coordinate(latitudeValues, documentIndex);
                    double lon = CoordinateHelper.coordinate(longitudeValues, documentIndex);
                    if (DistanceFilter.this.center.getDistanceTo(lat, lon) <= DistanceFilter.this.radius) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public String getCoordinatesField() {
        if (this.coordinatesField != null) {
            return this.coordinatesField;
        }
        return SpatialHelper.stripSpatialFieldSuffix(this.latitudeField);
    }

    public double getRadius() {
        return this.radius;
    }

    public Point getCenter() {
        return this.center;
    }

    public Filter getPreviousFilter() {
        return this.previousFilter;
    }

    private String getLatitudeField() {
        if (this.latitudeField != null) {
            return this.latitudeField;
        }
        return SpatialHelper.formatLatitude(this.coordinatesField);
    }

    private String getLongitudeField() {
        if (this.longitudeField != null) {
            return this.longitudeField;
        }
        return SpatialHelper.formatLongitude(this.coordinatesField);
    }

    public int hashCode() {
        int hashCode = 31 * super.hashCode() + this.previousFilter.hashCode();
        hashCode = 31 * hashCode + this.center.hashCode();
        hashCode = 31 * hashCode + Double.hashCode(this.radius);
        hashCode = 31 * hashCode + Objects.hashCode(this.coordinatesField);
        hashCode = 31 * hashCode + Objects.hashCode(this.latitudeField);
        hashCode = 31 * hashCode + Objects.hashCode(this.longitudeField);
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DistanceFilter) {
            DistanceFilter other = (DistanceFilter)((Object)obj);
            return Float.floatToIntBits(this.getBoost()) == Float.floatToIntBits(other.getBoost()) && this.previousFilter.equals((Object)other.previousFilter) && this.center.equals(other.center) && this.radius == other.radius && Objects.equals(this.coordinatesField, other.coordinatesField) && Objects.equals(this.latitudeField, other.latitudeField) && Objects.equals(this.longitudeField, other.longitudeField);
        }
        return false;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("DistanceFilter");
        sb.append("{previousFilter=").append(this.previousFilter);
        sb.append(", center=").append(this.center);
        sb.append(", radius=").append(this.radius);
        if (this.coordinatesField != null) {
            sb.append(", coordinatesField='").append(this.coordinatesField).append('\'');
        } else {
            sb.append(", latitudeField=").append(this.latitudeField);
            sb.append(", longitudeField=").append(this.longitudeField).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }
}

