/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.cloning;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class CloneUtils {
    public static JsonElement deepClone(JsonElement jsonElement) {
        if (jsonElement instanceof JsonObject) {
            return CloneUtils.deepCloneObject(jsonElement);
        }
        if (jsonElement instanceof JsonArray) {
            return CloneUtils.deepCloneArray(jsonElement);
        }
        if (jsonElement instanceof JsonPrimitive) {
            return jsonElement;
        }
        return JsonNull.INSTANCE;
    }

    private static JsonElement deepCloneObject(JsonElement jsonElement) {
        JsonObject jsonObject = (JsonObject)jsonElement;
        JsonObject result = new JsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            result.add((String)entry.getKey(), CloneUtils.deepClone((JsonElement)entry.getValue()));
        }
        return result;
    }

    private static JsonElement deepCloneArray(JsonElement jsonElement) {
        JsonArray jsonArray = (JsonArray)jsonElement;
        JsonArray result = new JsonArray();
        for (JsonElement element : jsonArray) {
            result.add(CloneUtils.deepClone(element));
        }
        return result;
    }
}

