/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.gson.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import org.hibernate.search.elasticsearch.gson.impl.JsonElementType;
import org.hibernate.search.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.exception.AssertionFailure;

public abstract class JsonAccessor {
    private static final JsonAccessor ROOT = new JsonAccessor(){

        @Override
        public JsonElement get(JsonObject root) {
            if (root == null) {
                throw new AssertionFailure("A null root was encountered");
            }
            return root;
        }

        @Override
        public void set(JsonObject root, JsonElement value) {
            throw new UnsupportedOperationException("Cannot set the root element");
        }

        @Override
        public <T extends JsonElement> T getOrCreate(JsonObject root, JsonElementType<T> type) {
            return type.cast(this.get(root));
        }

        @Override
        public void add(JsonObject root, JsonPrimitive value) {
            throw new UnsupportedOperationException("Cannot add a value to the root element");
        }

        public String toString() {
            return "root";
        }

        @Override
        public String getStaticAbsolutePath() {
            return null;
        }
    };

    public abstract JsonElement get(JsonObject var1);

    public abstract void set(JsonObject var1, JsonElement var2) throws UnexpectedJsonElementTypeException;

    public abstract void add(JsonObject var1, JsonPrimitive var2) throws UnexpectedJsonElementTypeException;

    public abstract <T extends JsonElement> T getOrCreate(JsonObject var1, JsonElementType<T> var2) throws UnexpectedJsonElementTypeException;

    public abstract String getStaticAbsolutePath();

    public static JsonAccessor root() {
        return ROOT;
    }

    public JsonAccessor property(String propertyName) {
        return new ObjectPropertyJsonAccessor(this, propertyName);
    }

    public JsonAccessor element(int index) {
        return new ArrayElementJsonAccessor(this, index);
    }

    private static class ArrayElementJsonAccessor
    extends NonRootAccessor<JsonArray> {
        private final int index;

        public ArrayElementJsonAccessor(JsonAccessor parentAccessor, int index) {
            super(parentAccessor);
            this.index = index;
        }

        @Override
        protected JsonElementType<JsonArray> getExpectedParentType() {
            return JsonElementType.ARRAY;
        }

        @Override
        protected JsonElement doGet(JsonArray parent) {
            if (parent != null && this.index < parent.size()) {
                return parent.get(this.index);
            }
            return null;
        }

        @Override
        protected void doSet(JsonArray parent, JsonElement newValue) {
            ArrayElementJsonAccessor.fillTo(parent, this.index);
            parent.set(this.index, newValue);
        }

        private static void fillTo(JsonArray array, int index) {
            for (int i = array.size(); i <= index; ++i) {
                array.add((JsonElement)JsonNull.INSTANCE);
            }
        }

        @Override
        protected void appendRuntimeRelativePath(StringBuilder path) {
            path.append("[").append(this.index).append("]");
        }

        @Override
        protected void appendStaticRelativePath(StringBuilder path, boolean first) {
        }
    }

    private static class ObjectPropertyJsonAccessor
    extends NonRootAccessor<JsonObject> {
        private final String propertyName;

        public ObjectPropertyJsonAccessor(JsonAccessor parentAccessor, String propertyName) {
            super(parentAccessor);
            this.propertyName = propertyName;
        }

        @Override
        protected JsonElementType<JsonObject> getExpectedParentType() {
            return JsonElementType.OBJECT;
        }

        @Override
        protected JsonElement doGet(JsonObject parent) {
            return parent.get(this.propertyName);
        }

        @Override
        protected void doSet(JsonObject parent, JsonElement newValue) {
            parent.add(this.propertyName, newValue);
        }

        @Override
        protected void appendRuntimeRelativePath(StringBuilder path) {
            path.append(".").append(this.propertyName);
        }

        @Override
        protected void appendStaticRelativePath(StringBuilder path, boolean isFirst) {
            if (!isFirst) {
                path.append(".");
            }
            path.append(this.propertyName);
        }
    }

    private static abstract class NonRootAccessor<P extends JsonElement>
    extends JsonAccessor {
        private final JsonAccessor parentAccessor;

        public NonRootAccessor(JsonAccessor parentAccessor) {
            this.parentAccessor = parentAccessor;
        }

        protected abstract JsonElementType<P> getExpectedParentType();

        @Override
        public JsonElement get(JsonObject root) {
            P parent = this.getExpectedParentType().cast(this.parentAccessor.get(root));
            if (parent == null) {
                return null;
            }
            return this.doGet(parent);
        }

        protected abstract JsonElement doGet(P var1);

        @Override
        public void set(JsonObject root, JsonElement newValue) throws UnexpectedJsonElementTypeException {
            P parent = this.parentAccessor.getOrCreate(root, this.getExpectedParentType());
            this.doSet(parent, newValue);
        }

        protected abstract void doSet(P var1, JsonElement var2);

        @Override
        public <T extends JsonElement> T getOrCreate(JsonObject root, JsonElementType<T> type) throws UnexpectedJsonElementTypeException {
            P parent = this.parentAccessor.getOrCreate(root, this.getExpectedParentType());
            JsonElement currentValue = this.doGet(parent);
            if (currentValue == null || currentValue.isJsonNull()) {
                T result = type.newInstance();
                this.doSet(parent, (JsonElement)result);
                return result;
            }
            if (!type.isInstance(currentValue)) {
                throw new UnexpectedJsonElementTypeException((JsonAccessor)this, type, currentValue);
            }
            return type.cast(currentValue);
        }

        @Override
        public void add(JsonObject root, JsonPrimitive newValue) throws UnexpectedJsonElementTypeException {
            P parent = this.parentAccessor.getOrCreate(root, this.getExpectedParentType());
            JsonElement currentValue = this.doGet(parent);
            if (currentValue == null) {
                this.doSet(parent, (JsonElement)newValue);
            } else if (JsonElementType.ARRAY.isInstance(currentValue)) {
                currentValue.getAsJsonArray().add((JsonElement)newValue);
            } else if (JsonElementType.PRIMITIVE.isInstance(currentValue) || JsonElementType.NULL.isInstance(currentValue)) {
                this.doSet(parent, (JsonElement)JsonBuilder.array().add(currentValue).add((JsonElement)newValue).build());
            } else {
                throw new UnexpectedJsonElementTypeException((JsonAccessor)this, Arrays.asList(JsonElementType.ARRAY, JsonElementType.PRIMITIVE, JsonElementType.NULL), currentValue);
            }
        }

        public String toString() {
            StringBuilder path = new StringBuilder();
            if (this.parentAccessor != ROOT) {
                path.append(this.parentAccessor.toString());
            }
            this.appendRuntimeRelativePath(path);
            return path.toString();
        }

        protected abstract void appendRuntimeRelativePath(StringBuilder var1);

        @Override
        public String getStaticAbsolutePath() {
            boolean isFirst;
            StringBuilder path = new StringBuilder();
            if (this.parentAccessor == ROOT) {
                isFirst = true;
            } else {
                isFirst = false;
                path.append(this.parentAccessor.getStaticAbsolutePath());
            }
            this.appendStaticRelativePath(path, isFirst);
            return path.toString();
        }

        protected abstract void appendStaticRelativePath(StringBuilder var1, boolean var2);
    }
}

