/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.nulls.impl;

import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchAsNullStringNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchAsTokenStringNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchBooleanNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchDoubleNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchFloatNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchIntegerNullMarkerCodec;
import org.hibernate.search.elasticsearch.nulls.codec.impl.ElasticsearchLongNullMarkerCodec;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;
import org.hibernate.search.engine.metadata.impl.PartialDocumentFieldMetadata;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class Elasticsearch5MissingValueStrategy
implements MissingValueStrategy {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    public static final Elasticsearch5MissingValueStrategy INSTANCE = new Elasticsearch5MissingValueStrategy();

    public NullMarkerCodec createNullMarkerCodec(Class<?> entityType, PartialDocumentFieldMetadata fieldMetadata, NullMarker nullMarker) {
        Object nullEncoded = nullMarker.nullEncoded();
        if (nullEncoded instanceof String) {
            if (this.isTextDataType(fieldMetadata)) {
                return new ElasticsearchAsTokenStringNullMarkerCodec(nullMarker);
            }
            return new ElasticsearchAsNullStringNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Integer) {
            return new ElasticsearchIntegerNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Long) {
            return new ElasticsearchLongNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Float) {
            return new ElasticsearchFloatNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Double) {
            return new ElasticsearchDoubleNullMarkerCodec(nullMarker);
        }
        if (nullEncoded instanceof Boolean) {
            return new ElasticsearchBooleanNullMarkerCodec(nullMarker);
        }
        throw LOG.unsupportedNullTokenType(entityType, fieldMetadata.getPath().getAbsoluteName(), nullEncoded.getClass());
    }

    private boolean isTextDataType(PartialDocumentFieldMetadata fieldMetadata) {
        FieldHelper.ExtendedFieldType fieldType;
        return fieldMetadata.getIndex().isAnalyzed() && (FieldHelper.ExtendedFieldType.STRING.equals((Object)(fieldType = FieldHelper.getType(fieldMetadata))) || FieldHelper.ExtendedFieldType.UNKNOWN.equals((Object)fieldType));
    }
}

