/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.Map;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.elasticsearch.settings.impl.model.IndexSettings;
import org.hibernate.search.elasticsearch.work.impl.CreateIndexResult;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchSchemaAccessor {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchWorkProcessor workProcessor;

    public ElasticsearchSchemaAccessor(ElasticsearchWorkFactory workFactory, ElasticsearchWorkProcessor workProcessor) {
        this.workFactory = workFactory;
        this.workProcessor = workProcessor;
    }

    public void createIndex(String indexName, IndexSettings settings, ExecutionOptions executionOptions) {
        Object work = this.workFactory.createIndex(indexName).settings(settings).build();
        this.workProcessor.executeSyncUnsafe(work);
    }

    public boolean createIndexIfAbsent(String indexName, IndexSettings settings, ExecutionOptions executionOptions) {
        Object work = this.workFactory.createIndex(indexName).settings(settings).ignoreExisting().build();
        CreateIndexResult result = (CreateIndexResult)((Object)this.workProcessor.executeSyncUnsafe(work));
        return CreateIndexResult.CREATED.equals((Object)result);
    }

    public boolean indexExists(String indexName) {
        Object work = this.workFactory.indexExists(indexName).build();
        return (Boolean)this.workProcessor.executeSyncUnsafe(work);
    }

    public IndexMetadata getCurrentIndexMetadata(String indexName) {
        IndexMetadata indexMetadata = new IndexMetadata();
        indexMetadata.setName(indexName);
        Object getMappingWork = this.workFactory.getIndexTypeMappings(indexName).build();
        try {
            Map mappings = (Map)this.workProcessor.executeSyncUnsafe(getMappingWork);
            indexMetadata.setMappings(mappings);
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchMappingRetrievalForValidationFailed(e);
        }
        Object getSettingsWork = this.workFactory.getIndexSettings(indexName).build();
        try {
            IndexSettings indexSettings = (IndexSettings)this.workProcessor.executeSyncUnsafe(getSettingsWork);
            indexMetadata.setSettings(indexSettings);
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchIndexSettingsRetrievalForValidationFailed(e);
        }
        return indexMetadata;
    }

    public void updateSettings(String indexName, IndexSettings settings) {
        Object work = this.workFactory.putIndexSettings(indexName, settings).build();
        try {
            this.workProcessor.executeSyncUnsafe(work);
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchSettingsUpdateFailed(indexName, e);
        }
    }

    public void putMapping(String indexName, String mappingName, TypeMapping mapping) {
        Object work = this.workFactory.putIndexTypeMapping(indexName, mappingName, mapping).build();
        try {
            this.workProcessor.executeSyncUnsafe(work);
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchMappingCreationFailed(mappingName, e);
        }
    }

    public void waitForIndexStatus(String indexName, ExecutionOptions executionOptions) {
        ElasticsearchIndexStatus requiredIndexStatus = executionOptions.getRequiredIndexStatus();
        String timeoutAndUnit = executionOptions.getIndexManagementTimeoutInMs() + "ms";
        Object work = this.workFactory.waitForIndexStatusWork(indexName, requiredIndexStatus, timeoutAndUnit).build();
        this.workProcessor.executeSyncUnsafe(work);
    }

    public void dropIndex(String indexName, ExecutionOptions executionOptions) {
        Object work = this.workFactory.dropIndex(indexName).build();
        this.workProcessor.executeSyncUnsafe(work);
    }

    public void closeIndex(String indexName) {
        Object work = this.workFactory.closeIndex(indexName).build();
        this.workProcessor.executeSyncUnsafe(work);
        LOG.closedIndex(indexName);
    }

    public void openIndex(String indexName) {
        try {
            Object work = this.workFactory.openIndex(indexName).build();
            this.workProcessor.executeSyncUnsafe(work);
        }
        catch (RuntimeException e) {
            LOG.openedIndex(indexName);
            throw e;
        }
        LOG.openedIndex(indexName);
    }
}

