/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.gson.impl.JsonElementType;
import org.hibernate.search.elasticsearch.gson.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.elasticsearch.impl.JsonAccessorBuilder;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.impl.NestingMarker;
import org.hibernate.search.elasticsearch.impl.ToElasticsearch;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;
import org.hibernate.search.elasticsearch.util.impl.ParentPathMismatchException;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.DeleteByQueryWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.builder.DeleteWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.builder.FlushWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.builder.IndexWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.builder.OptimizeWorkBuilder;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PartialDocumentFieldMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spatial.impl.SpatialHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ElasticsearchIndexWorkVisitor
implements IndexWorkVisitor<IndexingMonitor, ElasticsearchWork<?>> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final URLEncodedString indexName;
    private final boolean refreshAfterWrite;
    private final ExtendedSearchIntegrator searchIntegrator;
    private final ElasticsearchWorkFactory workFactory;

    public ElasticsearchIndexWorkVisitor(URLEncodedString indexName, boolean refreshAfterWrite, ExtendedSearchIntegrator searchIntegrator, ElasticsearchWorkFactory workFactory) {
        this.indexName = indexName;
        this.refreshAfterWrite = refreshAfterWrite;
        this.searchIntegrator = searchIntegrator;
        this.workFactory = workFactory;
    }

    public ElasticsearchWork<?> visitAddWork(AddLuceneWork work, IndexingMonitor monitor) {
        return ((IndexWorkBuilder)((IndexWorkBuilder)this.indexDocument(this.getDocumentId((LuceneWork)work), work.getDocument(), work.getEntityClass()).monitor(monitor).luceneWork((LuceneWork)work)).markIndexDirty(this.refreshAfterWrite)).build();
    }

    public ElasticsearchWork<?> visitDeleteWork(DeleteLuceneWork work, IndexingMonitor monitor) {
        return ((DeleteWorkBuilder)((DeleteWorkBuilder)this.workFactory.delete(this.indexName, ElasticsearchIndexWorkVisitor.entityName((LuceneWork)work), this.getDocumentId((LuceneWork)work)).luceneWork((LuceneWork)work)).markIndexDirty(this.refreshAfterWrite)).build();
    }

    public ElasticsearchWork<?> visitOptimizeWork(OptimizeLuceneWork work, IndexingMonitor monitor) {
        return ((OptimizeWorkBuilder)this.workFactory.optimize().index(this.indexName).luceneWork((LuceneWork)work)).build();
    }

    public ElasticsearchWork<?> visitPurgeAllWork(PurgeAllLuceneWork work, IndexingMonitor monitor) {
        JsonObject payload = this.createDeleteByQueryPayload(JsonBuilder.object().add("match_all", (JsonElement)new JsonObject()).build(), work.getTenantId());
        DeleteByQueryWorkBuilder builder = (DeleteByQueryWorkBuilder)((DeleteByQueryWorkBuilder)this.workFactory.deleteByQuery(this.indexName, payload).luceneWork((LuceneWork)work)).markIndexDirty(this.refreshAfterWrite);
        Set typesToDelete = this.searchIntegrator.getIndexedTypesPolymorphic(new Class[]{work.getEntityClass()});
        for (Class typeToDelete : typesToDelete) {
            builder.type(URLEncodedString.fromString(typeToDelete.getName()));
        }
        return builder.build();
    }

    public ElasticsearchWork<?> visitUpdateWork(UpdateLuceneWork work, IndexingMonitor monitor) {
        return ((IndexWorkBuilder)((IndexWorkBuilder)this.indexDocument(this.getDocumentId((LuceneWork)work), work.getDocument(), work.getEntityClass()).monitor(monitor).luceneWork((LuceneWork)work)).markIndexDirty(this.refreshAfterWrite)).build();
    }

    public ElasticsearchWork<?> visitFlushWork(FlushLuceneWork work, IndexingMonitor monitor) {
        return ((FlushWorkBuilder)this.workFactory.flush().index(this.indexName).luceneWork((LuceneWork)work)).build();
    }

    public ElasticsearchWork<?> visitDeleteByQueryWork(DeleteByQueryLuceneWork work, IndexingMonitor monitor) {
        JsonObject convertedQuery = ToElasticsearch.fromDeletionQuery(this.searchIntegrator.getIndexBinding(work.getEntityClass()).getDocumentBuilder(), work.getDeletionQuery());
        URLEncodedString typeName = URLEncodedString.fromString(work.getEntityClass().getName());
        JsonObject payload = this.createDeleteByQueryPayload(convertedQuery, work.getTenantId());
        return ((DeleteByQueryWorkBuilder)((DeleteByQueryWorkBuilder)this.workFactory.deleteByQuery(this.indexName, payload).luceneWork((LuceneWork)work)).type(typeName).markIndexDirty(this.refreshAfterWrite)).build();
    }

    private JsonObject createDeleteByQueryPayload(JsonObject query, String tenantId) {
        if (tenantId != null) {
            return JsonBuilder.object().add("query", JsonBuilder.object().add("bool", JsonBuilder.object().add("filter", JsonBuilder.object().add("term", JsonBuilder.object().addProperty("__HSearch_TenantId", tenantId))).add("must", (JsonElement)query))).build();
        }
        return JsonBuilder.object().add("query", (JsonElement)query).build();
    }

    private IndexWorkBuilder indexDocument(URLEncodedString id, Document document, Class<?> entityType) {
        JsonObject source = this.convertDocumentToJson(document, entityType);
        URLEncodedString typeName = URLEncodedString.fromString(entityType.getName());
        return this.workFactory.index(this.indexName, typeName, id, source);
    }

    private JsonObject convertDocumentToJson(Document document, Class<?> entityType) {
        EntityIndexBinding indexBinding = this.searchIntegrator.getIndexBinding(entityType);
        JsonObject root = new JsonObject();
        NestingMarker nestingMarker = null;
        JsonAccessorBuilder accessorBuilder = new JsonAccessorBuilder();
        for (IndexableField field : document.getFields()) {
            if (field instanceof NestingMarker) {
                nestingMarker = (NestingMarker)field;
                accessorBuilder.reset();
                accessorBuilder.append(((NestingMarker)field).getPath());
                continue;
            }
            this.convertFieldToJson(root, accessorBuilder, indexBinding, nestingMarker, document, field);
        }
        return root;
    }

    private void convertFieldToJson(JsonObject root, JsonAccessorBuilder accessorBuilder, EntityIndexBinding indexBinding, NestingMarker nestingMarker, Document document, IndexableField field) {
        try {
            EmbeddedTypeMetadata embeddedType;
            String fieldPath = field.name();
            List<NestingMarker.NestingPathComponent> nestingPath = nestingMarker == null ? null : nestingMarker.getPath();
            NestingMarker.NestingPathComponent lastPathComponent = nestingPath == null ? null : nestingPath.get(nestingPath.size() - 1);
            EmbeddedTypeMetadata embeddedTypeMetadata = embeddedType = lastPathComponent == null ? null : lastPathComponent.getEmbeddedTypeMetadata();
            if (embeddedType != null && fieldPath.equals(embeddedType.getEmbeddedNullFieldName())) {
                nestingPath = nestingPath.subList(0, nestingPath.size() - 1);
                accessorBuilder.reset();
                accessorBuilder.append(nestingPath);
                EmbeddedTypeMetadata.Container containerType = embeddedType.getEmbeddedContainer();
                switch (containerType) {
                    case ARRAY: 
                    case COLLECTION: 
                    case MAP: {
                        String value = field.stringValue();
                        accessorBuilder.buildForPath(fieldPath).set(root, (JsonElement)(value != null ? new JsonPrimitive(value) : null));
                        break;
                    }
                    case OBJECT: {
                        break;
                    }
                    default: {
                        throw new AssertionFailure("Unexpected container type: " + containerType);
                    }
                }
            } else {
                if ("$facets".equals(field.name())) {
                    return;
                }
                if (this.isDocValueField(field)) {
                    return;
                }
                if (fieldPath.equals("_hibernate_class")) {
                    return;
                }
                DocumentFieldMetadata documentFieldMetadata = indexBinding.getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(field.name());
                if (documentFieldMetadata == null) {
                    if (SpatialHelper.isSpatialField((String)fieldPath)) {
                        if (SpatialHelper.isSpatialFieldLatitude((String)fieldPath)) {
                            Number value = field.numericValue();
                            String spatialPropertyPath = SpatialHelper.stripSpatialFieldSuffix((String)fieldPath);
                            accessorBuilder.buildForPath(spatialPropertyPath + ".lat").add(root, value != null ? new JsonPrimitive(value) : null);
                        } else if (SpatialHelper.isSpatialFieldLongitude((String)fieldPath)) {
                            Number value = field.numericValue();
                            String spatialPropertyPath = SpatialHelper.stripSpatialFieldSuffix((String)fieldPath);
                            accessorBuilder.buildForPath(spatialPropertyPath + ".lon").add(root, value != null ? new JsonPrimitive(value) : null);
                        } else {
                            String value = field.stringValue();
                            accessorBuilder.buildForPath(fieldPath).add(root, value != null ? new JsonPrimitive(value) : null);
                        }
                    } else {
                        JsonAccessor accessor = accessorBuilder.buildForPath(fieldPath);
                        String stringValue = field.stringValue();
                        Number numericValue = field.numericValue();
                        if (stringValue != null) {
                            accessor.add(root, new JsonPrimitive(stringValue));
                        } else if (numericValue != null) {
                            accessor.add(root, new JsonPrimitive(numericValue));
                        } else {
                            accessor.add(root, null);
                        }
                    }
                } else {
                    JsonAccessor accessor = accessorBuilder.buildForPath(fieldPath);
                    if (field instanceof NullMarker) {
                        accessor.add(root, null);
                        return;
                    }
                    FieldHelper.ExtendedFieldType type = FieldHelper.getType((PartialDocumentFieldMetadata)documentFieldMetadata);
                    if (FieldHelper.ExtendedFieldType.BOOLEAN.equals((Object)type)) {
                        FieldBridge fieldBridge = documentFieldMetadata.getFieldBridge();
                        Boolean value = (Boolean)((TwoWayFieldBridge)fieldBridge).get(field.name(), document);
                        accessor.add(root, value != null ? new JsonPrimitive(value) : null);
                    } else {
                        Number numericValue = field.numericValue();
                        if (numericValue != null) {
                            accessor.add(root, numericValue != null ? new JsonPrimitive(numericValue) : null);
                        } else {
                            String stringValue = field.stringValue();
                            accessor.add(root, stringValue != null ? new JsonPrimitive(stringValue) : null);
                        }
                    }
                }
            }
        }
        catch (ParentPathMismatchException e) {
            throw LOG.indexedEmbeddedPrefixBypass(indexBinding.getDocumentBuilder().getBeanClass(), e.getMismatchingPath(), e.getExpectedParentPath());
        }
        catch (UnexpectedJsonElementTypeException e) {
            List<JsonElementType<?>> expectedTypes = e.getExpectedTypes();
            JsonAccessor accessor = e.getAccessor();
            JsonElement actualValue = e.getActualElement();
            if (expectedTypes.contains(JsonElementType.OBJECT) || JsonElementType.OBJECT.isInstance(actualValue)) {
                throw LOG.fieldIsBothCompositeAndConcrete(indexBinding.getDocumentBuilder().getBeanClass(), accessor.getStaticAbsolutePath());
            }
            throw new AssertionFailure("Unexpected field naming conflict when indexing; this kind of issue should have been detected when building the metadata.", (Throwable)e);
        }
    }

    private URLEncodedString getDocumentId(LuceneWork work) {
        return URLEncodedString.fromString(work.getTenantId() == null ? work.getIdInString() : work.getTenantId() + "_" + work.getIdInString());
    }

    private boolean isDocValueField(IndexableField field) {
        return field.fieldType().docValuesType() != DocValuesType.NONE;
    }

    private static URLEncodedString entityName(LuceneWork work) {
        return URLEncodedString.fromString(work.getEntityClass().getName());
    }
}

