/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.settings.impl.model.IndexSettings;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.GetIndexSettingsWorkBuilder;
import org.hibernate.search.exception.AssertionFailure;

public class GetIndexSettingsWork
extends SimpleElasticsearchWork<IndexSettings> {
    private final URLEncodedString indexName;

    protected GetIndexSettingsWork(Builder builder) {
        super(builder);
        this.indexName = builder.indexName;
    }

    @Override
    protected IndexSettings generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        JsonElement index = parsedResponseBody.get(this.indexName.original);
        if (index == null || !index.isJsonObject()) {
            throw new AssertionFailure("Elasticsearch API call succeeded, but the requested index wasn't mentioned in the result: " + parsedResponseBody);
        }
        JsonElement settings = index.getAsJsonObject().get("settings");
        if (settings == null || !settings.isJsonObject()) {
            throw new AssertionFailure("Elasticsearch API call succeeded, but the requested settings weren't mentioned in the result: " + parsedResponseBody);
        }
        JsonElement indexSettings = settings.getAsJsonObject().get("index");
        if (indexSettings != null) {
            GsonProvider gsonProvider = context.getGsonProvider();
            return (IndexSettings)gsonProvider.getGson().fromJson(indexSettings, IndexSettings.class);
        }
        return new IndexSettings();
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements GetIndexSettingsWorkBuilder {
        private final URLEncodedString indexName;

        public Builder(URLEncodedString indexName) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(this.indexName).pathComponent(Paths._SETTINGS);
            return builder.build();
        }

        @Override
        public GetIndexSettingsWork build() {
            return new GetIndexSettingsWork(this);
        }
    }
}

