/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.GetIndexTypeMappingsWorkBuilder;
import org.hibernate.search.exception.AssertionFailure;

public class GetIndexTypeMappingsWork
extends SimpleElasticsearchWork<Map<String, TypeMapping>> {
    private static final TypeToken<Map<String, TypeMapping>> STRING_TO_TYPE_MAPPING_MAP_TYPE_TOKEN = new TypeToken<Map<String, TypeMapping>>(){};
    private final URLEncodedString indexName;

    protected GetIndexTypeMappingsWork(Builder builder) {
        super(builder);
        this.indexName = builder.indexName;
    }

    @Override
    protected Map<String, TypeMapping> generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        JsonElement index = parsedResponseBody.get(this.indexName.original);
        if (index == null || !index.isJsonObject()) {
            throw new AssertionFailure("Elasticsearch API call succeeded, but the requested index wasn't mentioned in the result: " + parsedResponseBody);
        }
        JsonElement mappings = index.getAsJsonObject().get("mappings");
        if (mappings != null) {
            GsonProvider gsonProvider = context.getGsonProvider();
            Type mapType = STRING_TO_TYPE_MAPPING_MAP_TYPE_TOKEN.getType();
            return (Map)gsonProvider.getGson().fromJson(mappings, mapType);
        }
        return Collections.emptyMap();
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements GetIndexTypeMappingsWorkBuilder {
        private final URLEncodedString indexName;

        public Builder(URLEncodedString indexName) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(this.indexName).pathComponent(Paths._MAPPING);
            return builder.build();
        }

        @Override
        public GetIndexTypeMappingsWork build() {
            return new GetIndexTypeMappingsWork(this);
        }
    }
}

