/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.Version;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.cfg.spi.ParameterAnnotationsReader;
import org.hibernate.search.engine.impl.TokenizerChain;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.HibernateSearchResourceLoader;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class LuceneAnalyzerBuilder {
    private static final String LUCENE_VERSION_PARAM = "luceneMatchVersion";
    private static final Log log = LoggerFactory.make();

    private LuceneAnalyzerBuilder() {
    }

    public static Analyzer buildAnalyzer(AnalyzerDef analyzerDef, Version luceneMatchVersion, ServiceManager serviceManager) throws IOException {
        Map<String, String> mapOfParameters;
        int index;
        HibernateSearchResourceLoader defaultResourceLoader = new HibernateSearchResourceLoader(serviceManager);
        TokenizerDef token = analyzerDef.tokenizer();
        Map<String, String> tokenMapsOfParameters = LuceneAnalyzerBuilder.getMapOfParameters(token.params(), luceneMatchVersion);
        TokenizerFactory tokenFactory = ClassLoaderHelper.instanceFromClass(TokenizerFactory.class, token.factory(), "Tokenizer factory", tokenMapsOfParameters);
        LuceneAnalyzerBuilder.injectResourceLoader(tokenFactory, defaultResourceLoader, tokenMapsOfParameters);
        int length = analyzerDef.filters().length;
        int charLength = analyzerDef.charFilters().length;
        TokenFilterFactory[] filters = new TokenFilterFactory[length];
        CharFilterFactory[] charFilters = new CharFilterFactory[charLength];
        for (index = 0; index < length; ++index) {
            TokenFilterDef filterDef = analyzerDef.filters()[index];
            mapOfParameters = LuceneAnalyzerBuilder.getMapOfParameters(filterDef.params(), luceneMatchVersion);
            filters[index] = ClassLoaderHelper.instanceFromClass(TokenFilterFactory.class, filterDef.factory(), "Token filter factory", mapOfParameters);
            LuceneAnalyzerBuilder.injectResourceLoader(filters[index], defaultResourceLoader, mapOfParameters);
        }
        for (index = 0; index < charFilters.length; ++index) {
            CharFilterDef charFilterDef = analyzerDef.charFilters()[index];
            mapOfParameters = LuceneAnalyzerBuilder.getMapOfParameters(charFilterDef.params(), luceneMatchVersion);
            charFilters[index] = ClassLoaderHelper.instanceFromClass(CharFilterFactory.class, charFilterDef.factory(), "Character filter factory", mapOfParameters);
            LuceneAnalyzerBuilder.injectResourceLoader(charFilters[index], defaultResourceLoader, mapOfParameters);
        }
        return new TokenizerChain(charFilters, tokenFactory, filters);
    }

    private static void injectResourceLoader(Object processor, ResourceLoader defaultResourceLoader, Map<String, String> mapOfParameters) throws IOException {
        if (processor instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)processor).inform(defaultResourceLoader);
        }
    }

    private static Map<String, String> getMapOfParameters(Parameter[] params, Version luceneMatchVersion) {
        Map<String, String> mapOfParams = ParameterAnnotationsReader.toNewMutableMap(params);
        mapOfParams.put(LUCENE_VERSION_PARAM, luceneMatchVersion.toString());
        return mapOfParams;
    }
}

