/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import java.util.ArrayList;
import java.util.List;

public class Window<E> {
    private int externalStartIndex;
    private int capacity;
    private final int initialExternalStartIndex;
    private final List<E> elementData;
    private int internalStartIndex;
    private int size;

    public Window(int initialIndex, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity must be at least 1");
        }
        this.initialExternalStartIndex = initialIndex;
        this.capacity = capacity;
        this.externalStartIndex = initialIndex;
        this.elementData = new ArrayList();
        this.internalStartIndex = 0;
        this.size = 0;
    }

    public int start() {
        return this.externalStartIndex;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public E get(int externalIndex) {
        this.rangeCheck(externalIndex);
        int internalIndex = (externalIndex - this.externalStartIndex + this.internalStartIndex) % this.capacity;
        return this.elementData.get(internalIndex);
    }

    private void rangeCheck(int externalIndex) {
        int start = this.start();
        if (externalIndex < start || start + this.size() <= externalIndex) {
            throw new IndexOutOfBoundsException();
        }
    }

    public boolean add(E element) {
        int newElementIndex = (this.internalStartIndex + this.size) % this.capacity;
        if (this.size == this.capacity) {
            this.internalStartIndex = (this.internalStartIndex + 1) % this.capacity;
            ++this.externalStartIndex;
        } else {
            ++this.size;
        }
        if (newElementIndex == this.elementData.size()) {
            this.elementData.add(element);
        } else {
            this.elementData.set(newElementIndex, element);
        }
        return true;
    }

    public void clear() {
        this.externalStartIndex = this.initialExternalStartIndex;
        for (int i = 0; i < this.size; ++i) {
            this.elementData.set((this.internalStartIndex + i) % this.capacity, null);
        }
        this.internalStartIndex = 0;
        this.size = 0;
    }
}

